<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woothemes.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $product, $woocommerce_loop;

// Ensure visibility
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}

$col_class = ci_theme_get_columns_classes( ! empty( $woocommerce_loop['columns'] ) ? $woocommerce_loop['columns'] : apply_filters( 'loop_shop_columns', 4 ) );

?>
<div class="<?php echo esc_attr( $col_class ); ?>">

	<div <?php post_class( 'item' ); ?>>

		<?php
		/**
		 * woocommerce_before_shop_loop_item hook.
		 *
		 * @hooked woocommerce_template_loop_product_link_open - 10 // Removed by theme.
		 * @hooked woocommerce_template_loop_product_thumbnail - 10 // Added by theme.
		 */
		do_action( 'woocommerce_before_shop_loop_item' );
		?>

		<div class="item-info">

			<?php
			/**
			 * woocommerce_before_shop_loop_item_title hook.
			 *
			 * @hooked woocommerce_show_product_loop_sale_flash - 10 // Removed by theme.
			 * @hooked woocommerce_template_loop_product_thumbnail - 10 // Removed by theme.
			 */
			do_action( 'woocommerce_before_shop_loop_item_title' );

			/**
			 * woocommerce_shop_loop_item_title hook.
			 *
			 * @hooked woocommerce_template_loop_product_title - 10
			 */
			do_action( 'woocommerce_shop_loop_item_title' );
			?>

			<p class="item-byline">

				<?php
				/**
				 * woocommerce_after_shop_loop_item_title hook.
				 *
				 * @hooked woocommerce_template_loop_rating - 5 // Removed by theme.
				 * @hooked woocommerce_template_loop_price - 10
				 * @hooked woocommerce_show_product_loop_sale_flash - 10 // Added by theme.
				 */
				do_action( 'woocommerce_after_shop_loop_item_title' );
				?>

			</p>

		</div>

		<a class="btn item-btn" href="<?php the_permalink(); ?>">
			<?php esc_html_e( 'View More', 'ci_theme' ); ?>
		</a>

		<?php
		/**
		 * woocommerce_after_shop_loop_item hook.
		 *
		 * @hooked woocommerce_template_loop_product_link_close - 5 // Removed by theme.
		 * @hooked woocommerce_template_loop_add_to_cart - 10 // Removed by theme.
		 */
		do_action( 'woocommerce_after_shop_loop_item' );
		?>

	</div>

</div>
