<?php

function wonderplugin_audio_css_allow($allowed_attr) {

	if ( !is_array($allowed_attr) ) {
		$allowed_attr = array();
	}
	
	array_push($allowed_attr, 'position', 'top', 'left', 'bottom', 'right');

	return $allowed_attr;
}

function wonderplugin_audio_tags_allow( $allowedposttags ) {
	
	if ( isset($allowedposttags['a']) && is_array($allowedposttags['a']) )
	{
		$allowedposttags['a']['download'] = true;
		$allowedposttags['a']['onclick'] = true;
		$allowedposttags['a']['data-group'] = true;
		$allowedposttags['a']['data-width'] = true;
		$allowedposttags['a']['data-height'] = true;
	}
	
	return $allowedposttags;
}

function wonderplugin_audio_wp_check_filetype_and_ext($data, $file, $filename, $mimes) {

	$filetype = wp_check_filetype( $filename, $mimes );

	return array(
			'ext'             => $filetype['ext'],
			'type'            => $filetype['type'],
			'proper_filename' => $data['proper_filename']
	);
}