<?php
/*
 * Template Name: Discography Listing
 */
?>

<?php get_header(); ?>

<?php while ( have_posts() ): the_post(); ?>

	<main id="main">
		<div class="container">
			<div class="row">
				<div class="col-xs-12">
					<h3 class="section-title"><?php the_title(); ?></h3>

					<?php
						$cpt            = 'cpt_discography';
						$cpt_taxonomy   = 'section';
						$masonry        = get_post_meta( get_the_ID(), 'discography_listing_masonry', true );
						$isotope        = get_post_meta( get_the_ID(), 'discography_listing_isotope', true );
						$columns        = get_post_meta( get_the_ID(), 'discography_listing_columns', true );
						$posts_per_page = get_post_meta( get_the_ID(), 'discography_listing_posts_per_page', true );
						$disc_date      = get_post_meta( get_the_ID(), 'ci_cpt_discography_date', true );

						$div_class = '';
						if ( 'on' == $isotope || 'on' == $masonry ) {
							$div_class = 'list-masonry';
						}
					?>

					<?php if ( 'on' == $isotope ) : ?>
						<ul class="filters-nav group">
							<li><a href="#filter" class="selected btn small transparent" data-filter="*"><?php esc_html_e( 'All Items', 'ci_theme' ); ?></a></li>
							<?php $cats = get_terms( $cpt_taxonomy, array( 'hide_empty' => 1 ) ); ?>
							<?php foreach ( $cats as $cat ) : ?>
								<li><a href="#filter" class="btn small transparent" data-filter=".term-<?php echo esc_attr( $cat->term_id ); ?>"><?php echo esc_html( $cat->name ); ?></a></li>
							<?php endforeach; ?>
						</ul>
					<?php endif; ?>


					<div class="row item-list <?php echo esc_attr( $div_class ); ?>">
						<?php
							$item_classes = '';
							switch ( $columns ) {
								case 1:
									$item_classes = 'col-xs-12';
									break;
								case 2:
									$item_classes = 'col-xs-12 col-sm-6';
									break;
								case 3:
									$item_classes = 'col-xs-12 col-sm-6 col-md-4';
									break;
								case 4:
									$item_classes = 'col-xs-12 col-sm-6 col-md-4 col-lg-3';
									break;
							}

							$args = array(
								'paged'     => ci_get_page_var(),
								'post_type' => $cpt,
							);


							if ( $posts_per_page >= 1 ) {
								$args['posts_per_page'] = $posts_per_page;
							} elseif ( $posts_per_page <= -1 ) {
								$args['posts_per_page'] = -1;
							}

							if ( 'on' == $isotope ) {
								$args['posts_per_page'] = -1;
							}

							$full_width_class = 1 == $columns ? ' item-fullwidth ' : '';

							$q = new WP_Query( $args );
						?>

						<?php while ( $q->have_posts() ) : $q->the_post(); ?>

							<?php
								$terms_classes = '';
								if ( 'on' == $isotope ) {
									$terms         = get_the_terms( get_the_ID(), $cpt_taxonomy );
									$terms         = ! empty( $terms ) ? $terms : array();
									$terms_classes = implode( ' ', array_map( 'urldecode', wp_list_pluck( $terms, 'slug' ) ) );
									foreach ( wp_list_pluck( $terms, 'term_id' ) as $term_id ) {
										$terms_classes .= ' term-' . $term_id;
									}
								}
							?>
							<?php
								$disc_label     = get_post_meta( get_the_ID(), 'ci_cpt_discography_label', true );
								$disc_cat_no    = get_post_meta( get_the_ID(), 'ci_cpt_discography_cat_no', true );
								$disc_date      = get_post_meta( get_the_ID(), 'ci_cpt_discography_date', true );
								$disc_timestamp = strtotime( $disc_date, current_time( 'timestamp' ) );
								$disc_fields    = get_post_meta( get_the_ID(), 'ci_cpt_discography_fields', true );
								$disc_tracks    = get_post_meta( get_the_ID(), 'ci_cpt_discography_tracks', true );
							?>
                            <div class="col-md-3 col-sm-3">
                            <h2 class="group__heading"><?php if( !empty( $disc_date ) ): ?>
			<tr>
				
				<td><?php echo date_i18n( get_option('date_format'), $disc_timestamp ); ?></td>
			</tr>
		<?php endif; ?></h2>
                            </div>
                            <div class="col-md-9 col-sm-9">
                            	<div class="group-right">
                                	<article class="teaser teaser--small">   
                                    <div class="row">
                                    	<div class="col-md-4">
                                        	<div class="teaser__media">
                                      <div><a href="<?php the_permalink(); ?>"><?php the_post_thumbnail( 'ci_square' );?></a></div>
                                    </div>
                                        </div>
                                        <div class="col-md-8">
                                        	<div class="teaser__details">
                                           <h2 class="teaser__title heading--top"><?php get_template_part( 'listing-meta' ); ?></h2>
                                      </div>
                                        </div>
                                    </div>
                                    
                                    
                                </article>
                                </div>
                            </div>
							<?php /*?><div class="<?php echo esc_attr( $item_classes ); ?> <?php echo esc_attr( $terms_classes ); ?>">
								<div <?php post_class( 'item' . $full_width_class ); ?>>
									<a href="<?php the_permalink(); ?>" class="item-hold">
										<figure class="item-thumb">
											<?php
												if ( 1 == $columns ) {
													the_post_thumbnail( 'ci_blog_full' );
												} elseif ( 'on' == $masonry ) {
													the_post_thumbnail( 'ci_masonry' );
												} else {
													the_post_thumbnail( 'ci_square' );
												}
											?>
										</figure>
									</a>

									<?php get_template_part( 'listing-meta' ); ?>

									<a class="btn item-btn" href="<?php the_permalink(); ?>"><?php echo ci_get_read_more_text( get_post_type() ); ?></a>
								</div>
							</div><?php */?>
						<?php endwhile; ?>
						<?php wp_reset_postdata(); ?>

					</div>
					<?php ci_pagination( array(), $q ); ?>
				</div>
			</div>
		</div>
	</main>

<?php endwhile; ?>

<?php get_footer(); ?>
