<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.3.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

get_header( 'shop' );

/**
 * Hook: woocommerce_before_main_content.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked woocommerce_breadcrumb - 20 // REMOVED by theme
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
do_action( 'woocommerce_before_main_content' );

?>
<div class="col-md-8">

	<div class="shop-actions group">
		<div class="actions">
			<?php woocommerce_result_count(); ?>

			<div class="product-number">
				<span><?php esc_html_e( 'View:', 'ci_theme' ); ?></span>
				<a href="<?php echo esc_url( add_query_arg( 'view', ci_setting( 'eshop_products_view_first' ), get_permalink( ci_translate_post_id( wc_get_page_id( 'shop' ), true, 'page' ) ) ) ); ?>"><?php ci_e_setting( 'eshop_products_view_first' ); ?></a>
				<a href="<?php echo esc_url( add_query_arg( 'view', ci_setting( 'eshop_products_view_second' ), get_permalink( ci_translate_post_id( wc_get_page_id( 'shop' ), true, 'page' ) ) ) ); ?>"><?php ci_e_setting( 'eshop_products_view_second' ); ?></a>
				<?php if ( ci_setting( 'eshop_products_view_all' ) ) : ?>
					<a href="<?php echo esc_url( add_query_arg( 'view', 'all', get_permalink( ci_translate_post_id( wc_get_page_id( 'shop' ), true, 'page' ) ) ) ); ?>"><?php esc_html_e( 'All', 'ci_theme' ); ?></a>
				<?php endif; ?>
			</div>
		</div> <!-- .shop-actions -->

		<?php
		/**
		 * Hook: woocommerce_before_shop_loop.
		 *
		 * @hooked wc_print_notices - 10
		 * @hooked woocommerce_result_count - 20 // REMOVED by theme
		 * @hooked woocommerce_catalog_ordering - 30
		 */
		do_action( 'woocommerce_before_shop_loop' );
		?>
	</div>

	<?php if ( is_tax() && apply_filters( 'woocommerce_show_page_title', true ) ) : ?>
		<h2 class="section-title"><?php woocommerce_page_title(); ?></h2>
	<?php endif; ?>

	<?php
	/**
	 * Hook: woocommerce_archive_description.
	 *
	 * @hooked woocommerce_taxonomy_archive_description - 10
	 * @hooked woocommerce_product_archive_description - 10
	 */
	do_action( 'woocommerce_archive_description' );
	?>

	<div class="product-list item-list row">
		<?php
		if ( have_posts() ) {

			woocommerce_product_loop_start();

			if ( wc_get_loop_prop( 'total' ) ) {
				while ( have_posts() ) {
					the_post();

					/**
					 * Hook: woocommerce_shop_loop.
					 *
					 * @hooked WC_Structured_Data::generate_product_data() - 10
					 */
					do_action( 'woocommerce_shop_loop' );

					wc_get_template_part( 'content', 'product' );
				}
			}

			woocommerce_product_loop_end();

			/**
			 * Hook: woocommerce_after_shop_loop.
			 *
			 * @hooked woocommerce_pagination - 10 // REMOVED by theme
			 */
			do_action( 'woocommerce_after_shop_loop' );
		} else {
			?>
			<div class="col-xs-12">
				<?php
				/**
				 * Hook: woocommerce_no_products_found.
				 *
				 * @hooked wc_no_products_found - 10
				 */
				do_action( 'woocommerce_no_products_found' );
				?>
			</div>
			<?php
		}
		?>
	</div>

	<?php woocommerce_pagination(); ?>

</div>

<div class="col-md-4">
	<?php
	/**
	 * Hook: woocommerce_sidebar.
	 *
	 * @hooked woocommerce_get_sidebar - 10
	 */
	do_action( 'woocommerce_sidebar' );
	?>
</div>

<?php
/**
 * Hook: woocommerce_after_main_content.
 *
 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
 */
do_action( 'woocommerce_after_main_content' );

get_footer( 'shop' );
