jQuery(window).on("load", function() {
	"use strict";

	/* -----------------------------------------
	 FlexSlider Init
	 ----------------------------------------- */
	var slider = jQuery('.flexslider');
	if ( slider.length ) {
		jQuery(".flexslider").flexslider({
			prevText: '',
			nextText: '',
			directionNav: false,
			controlNav: true,
			start: function(slider) {
				slider.removeClass('loading');
			}
		});
	}

	/* -----------------------------------------
	 Parallax
	 ----------------------------------------- */
	function initParallax() {
		jQuery('.parallax').each(function() {
			var $self = jQuery(this),
					offsetCoords = $self.offset(),
					yPos = 0,
					topOffset = offsetCoords.top,
					speed = $(this).data('speed');

			var lastScrollTop = 0,
				$window = jQuery(window);

			$window.scroll(function() {
				// If this section is in view
				if ( ($window.scrollTop() + $window.height()) > (topOffset) &&
					(( topOffset + $self.height()) > $window.scrollTop() )) {

					var current = $self.css('backgroundPosition').split(" ");
					current = current[1].replace('px', '');

					var st = jQuery(this).scrollTop();
					if (st > lastScrollTop) {
						// Down
						yPos = (parseInt(current, 10) - speed);
						if ( yPos > $self.height() ) { yPos = $self.height(); }
					} else {
						// Up
						yPos = (parseInt(current, 10) + speed);
						if ( yPos > 0 ) { yPos = 0; }
					}
					lastScrollTop = st;

					var coords = '50% '+ yPos + 'px';

					// Move the background
					$self.css({ backgroundPosition: coords });
				}
			});
		});
	}

	if ( jQuery(window).width() > 767 ) {
		initParallax();
	}

	/* -----------------------------------------
	 Isotope / Masonry
	 ----------------------------------------- */
	var $container = jQuery('.list-masonry'),
			$filters = jQuery(".filters-nav");
		$container.isotope();

	if ( $filters.length ) {
		jQuery('.filters-nav li a').click(function(){
			var selector = jQuery(this).attr('data-filter');
			jQuery(this).parent().siblings().find('a').removeClass('selected');
			jQuery(this).addClass("selected");

			$container.isotope({
				filter: selector,
				animationOptions: {
					duration: 750,
					easing: 'linear',
					queue: false
				}
			});

			return false;
		});
	}

});

jQuery(document).ready(function($) {
	"use strict";

	/* -----------------------------------------
	 Responsive Menus Init with mmenu
	 ----------------------------------------- */
	var mainNav = $("#navigation"),
			mobileNav = $("#mobilemenu");
	mainNav.clone().removeAttr('id').removeClass().appendTo(mobileNav);
	mobileNav.find('li').removeAttr('id');

	mobileNav.mmenu({
		offCanvas: {
			position: 'top',
			zposition: 'front'
		}
	});

	/* -----------------------------------------
	 Main Navigation Init
	 ----------------------------------------- */
	$('#navigation').superfish({
		delay:       300,
		animation:   { opacity:'show', height:'show' },
		speed:       'fast',
		dropShadows: false
	});

	/* -----------------------------------------
	 Responsive Videos with fitVids
	 ----------------------------------------- */
	$('body').fitVids();

	/* -----------------------------------------
	 Lightbox
	 ----------------------------------------- */
	$(".fancybox, a[data-rel^='prettyPhoto']").fancybox({
		fitToView: true,
		padding: 0,
		nextEffect: 'fade',
		prevEffect: 'fade'
	});

	/* -----------------------------------------
	 Event Map Init
	 ----------------------------------------- */
	var event_map = $("#event_map");
	if ( event_map.length ) {
		var lat = event_map.data('lat'),
				lng = event_map.data('lng'),
				tipText = event_map.data('tooltip-txt'),
				titleText = event_map.attr('title');

		map_init(lat, lng, tipText, titleText);
	}

	/* -----------------------------------------
	 SoundManager2 Init
	 ----------------------------------------- */
	soundManager.setup({
		url: 'js/swf'
	});

	/* -----------------------------------------
	 SoundCloud Trigger
	 ----------------------------------------- */
	if ($('.soundcloud-wrap').length) {
		$('.sc-play').click(function(e){
			var target = $(this).parent().find('.soundcloud-wrap');
			target.slideToggle('fast');
			e.preventDefault();
		});
	}

	var $buttons = $(".track-buttons");

	function addTallClasstoTrack() {
		if ( $(window).width() < 1032 && $buttons.length ) {
			$('.track').each(function() {
				if ( $(this).find(".track-buttons").length ) {
					$(this).addClass('tall');
				}
			});
		} else {
			$(".track").removeClass('tall');
		}
	}

	addTallClasstoTrack();

	$(window).on('resize', function(e) {
		addTallClasstoTrack();
	});

	/* -----------------------------------------
	 Galleries (stapel.js)
	 ----------------------------------------- */
	var tpclose = $('.tp-close');

	var stapel = $( '#tp-grid' ).stapel( {
		gutter    : 30,
		pileAngles: 2,
		onAfterOpen: function(pileName) {
			tpclose.fadeIn();
		}
	} );

	tpclose.on('click', function(e) {
		$(this).hide();
		stapel.closePile();

		e.preventDefault();
	});
});

function map_init(lat, lng, tipText, titleText) {
	'use strict';
	var myLatlng = new google.maps.LatLng(lat, lng);
	var mapOptions = {
		zoom: 8,
		center: myLatlng,
		mapTypeId: google.maps.MapTypeId.ROADMAP,
		styles: [{"stylers":[{"saturation":-100},{"gamma":1}]},{"elementType":"labels.text.stroke","stylers":[{"visibility":"off"}]},{"featureType":"poi.business","elementType":"labels.text","stylers":[{"visibility":"off"}]},{"featureType":"poi.business","elementType":"labels.icon","stylers":[{"visibility":"off"}]},{"featureType":"poi.place_of_worship","elementType":"labels.text","stylers":[{"visibility":"off"}]},{"featureType":"poi.place_of_worship","elementType":"labels.icon","stylers":[{"visibility":"off"}]},{"featureType":"road","elementType":"geometry","stylers":[{"visibility":"simplified"}]},{"featureType":"water","stylers":[{"visibility":"on"},{"saturation":50},{"gamma":0},{"hue":"#50a5d1"}]},{"featureType":"administrative.neighborhood","elementType":"labels.text.fill","stylers":[{"color":"#333333"}]},{"featureType":"road.local","elementType":"labels.text","stylers":[{"weight":0.5},{"color":"#333333"}]},{"featureType":"transit.station","elementType":"labels.icon","stylers":[{"gamma":1},{"saturation":50}]}]
	};

	var map = new google.maps.Map(document.getElementById('event_map'), mapOptions);

	var contentString = '<div class="tip-content">' + tipText + '</div>';

	var infowindow = new google.maps.InfoWindow({
		content: contentString
	});

	var marker = new google.maps.Marker({
		position: myLatlng,
		map: map,
		title: titleText
	});

	google.maps.event.addListener(marker, 'click', function() {
		infowindow.open(map,marker);
	});
}