<?php
session_start();
include ("config/connection.php"); 
 
 
 
 
/**
 * This file contains the Backup_Database class wich performs
 * a partial or complete backup of any given MySQL database
 * @author Daniel López Azaña <http://www.daniloaz.com-->
 * @version 1.0
 */

// Report all errors
//error_reporting(E_ALL);

/**
 * Define database parameters here
 */
define("DB_USER", 'genxsmed_welch');
define("DB_PASSWORD", 'workforce123$');
define("DB_NAME", 'genxsmed_welch');
define("DB_HOST", 'localhost');
define("OUTPUT_DIR", 'backups');
define("TABLES", '*');

/**
 * 
 */
$backupDatabase = new Backup_Database(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);
$status = $backupDatabase->backupTables(TABLES, OUTPUT_DIR);

if($status)
{
	$msg=base64_encode('Database Backup Successful..');
	header("location: list_backup.php?msg=$msg");
	exit();
}
else
{
	$msg=base64_encode('Error! There is an error during backup..');
	header("location: list_backup.php?msg=$msg");
	exit();
}



































































/**
 * The Backup_Database class
 */
class Backup_Database {
    /**
     * Host where database is located
     */
    var $host = '';

    /**
     * Username used to connect to database
     */
    var $username = '';

    /**
     * Password used to connect to database
     */
    var $passwd = '';

    /**
     * Database to backup
     */
    var $dbName = '';

    /**
     * Database charset
     */
    var $charset = '';

    /**
     * Constructor initializes database
     */
	 function __construct()
	 {
		 //$this->Backup_Database($host, $username, $passwd, $dbName, $charset = 'utf8');
	 }
    function Backup_Database($host, $username, $passwd, $dbName, $charset = 'utf8')
    {
        $this->host     = $host;
        $this->username = $username;
        $this->passwd   = $passwd;
        $this->dbName   = $dbName;
        $this->charset  = $charset;

        $this->initializeDatabase();
    }
 
    protected function initializeDatabase()
    {
		
        $conn = mysql_connect($this->host, $this->username, $this->passwd);
        mysql_select_db($this->dbName, $conn);
        if (! mysql_set_charset ($this->charset, $conn))
        {
            mysql_query('SET NAMES '.$this->charset);
        }
    }

    /**
     * Backup the whole database or just some tables
     * Use '*' for whole database or 'table1 table2 table3...'
     * @param string $tables
     */
    public function backupTables($tables = '*', $outputDir = '.')
    {
        try
        {
            /**
            * Tables to export
            */
            if($tables == '*')
            {
                $tables = array();
                $result = mysql_query('SHOW TABLES')or die(mysql_error());
                while($row = mysql_fetch_row($result))
                {
                    $tables[] = $row[0];
                }
            }
            else
            {
                $tables = is_array($tables) ? $tables : explode(',',$tables);
            }

            $sql = '';//CREATE DATABASE IF NOT EXISTS '.$this->dbName.";\n\n";
           // $sql .= 'USE '.$this->dbName.";\n\n";

            /**
            * Iterate tables
            */
            foreach($tables as $table)
            {
               // echo "Backing up ".$table." table...";

                $result = mysql_query('SELECT * FROM '.$table);
                $numFields = mysql_num_fields($result);

                $sql .= 'DROP TABLE IF EXISTS '.$table.';';
                $row2 = mysql_fetch_row(mysql_query('SHOW CREATE TABLE '.$table));
                $sql.= "\n\n".$row2[1].";\n\n";

                for ($i = 0; $i < $numFields; $i++) 
                {
                    while($row = mysql_fetch_row($result))
                    {
                        $sql .= 'INSERT INTO '.$table.' VALUES(';
                        for($j=0; $j<$numFields; $j++) 
                        {
                            $row[$j] = addslashes($row[$j]);
                            //$row[$j] = clean($row[$j]);
							if(@isset($row[$j])){
							$str = @trim($row[$j]);
							if(get_magic_quotes_gpc()) {
								$str = stripslashes($str);
							}
							$row[$j]= mysql_real_escape_string($str);
							}
							else{
								$row[$j]='NULL';
							} 
								 
							  
                            if (isset($row[$j]))
                            {
                                $sql .= '"'.$row[$j].'"' ;
                            }
                            else
                            {
                                $sql.= '""';
                            }

                            if ($j < ($numFields-1))
                            {
                                $sql .= ',';
                            }
                        }

                        $sql.= ");\n";
                    }
                }

                $sql.="\n\n\n";

                
            }
        }
        catch (Exception $e)
        {
            var_dump($e->getMessage());
            return false;
        }

        return $this->saveFile($sql, $outputDir);
    }

    /**
     * Save SQL to file
     * @param string $sql
     */
    protected function saveFile(&$sql, $outputDir = '.')
    {
        if (!$sql) return false;
		$file_name= 'db-backup-'.$this->dbName.'-'.date("Ymd-His", time()).'.sql';
		mysql_query("INSERT INTO `backup` (`file`) VALUES ( '$file_name')");

        try
        {
            $handle = fopen($outputDir.'/'.$file_name,'w+');
            fwrite($handle, $sql);
            fclose($handle);
        }
        catch (Exception $e)
        {
            var_dump($e->getMessage());
            return false;
        }

        return true;
    }
}


