DROP TABLE IF EXISTS backup;

CREATE TABLE `backup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file` varchar(255) NOT NULL,
  `when` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO backup VALUES("1","db-backup--20140924-145742.sql","2014-09-24 14:57:42");



DROP TABLE IF EXISTS child_pages;

CREATE TABLE `child_pages` (
  `c_id` int(4) NOT NULL AUTO_INCREMENT,
  `page` varchar(255) NOT NULL,
  `page_title` text,
  `desc` longtext,
  `title` text,
  `description` varchar(1024) DEFAULT NULL,
  `keywords` varchar(1024) DEFAULT NULL,
  `robots` varchar(255) NOT NULL DEFAULT 'index,follow',
  `ordr` int(11) NOT NULL DEFAULT '0',
  `t_nav` tinyint(1) NOT NULL DEFAULT '1',
  `show_in_footer` int(1) NOT NULL DEFAULT '1',
  `IStatus` int(1) NOT NULL DEFAULT '1',
  `pid` int(11) NOT NULL DEFAULT '0',
  `header_image` varchar(255) NOT NULL,
  `top_header_image` varchar(255) NOT NULL,
  `google_analytics` text NOT NULL,
  `header_image_text` varchar(255) NOT NULL,
  `show_in_leftnav` tinyint(1) NOT NULL,
  `nav_title` varchar(255) NOT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`c_id`)
) ENGINE=MyISAM AUTO_INCREMENT=41 DEFAULT CHARSET=latin1;

INSERT INTO child_pages VALUES("1","history","History","","History","","","index,follow","0","0","0","1","0","09_09_46_08_09_14_000000Concord_grapes_on_vine.jpg","09_09_33_08_09_14_000000Welchs-History.png","","","0","History","");
INSERT INTO child_pages VALUES("38","our-history","Our History","<p>The Concord grape was first cultivated in 1849 by Ephraim Wales Bull in Concord, Massachusetts. He wanted to create a grape that could withstand the colder climate of the Northeast. Using the Vitis labrusca, or &quot;fox&quot; grape, native to the area, he planted 22,000 seedlings. After six years he finally selected a single vine he thought worth keeping and named it after his hometown. Bull&#39;s original vine still exists today in Concord!</p>\r\n\r\n<p>The first unfermented grape juice known to be processed in the United States was by a Vineland, New Jersey dentist, Dr. Thomas Welch in 1869. Dr. Welch, his wife and 17-year old son, Charles, gathered 40 pounds of Concord grapes from the trellis in front of their house. In their kitchen, they cooked the grapes for a few minutes, squeezed the juice out through cloth bags, and poured the world&#39;s first processed fresh fruit juice into twelve quart bottles on the kitchen table.</p>\r\n\r\n<p>To preserve the juice, Dr. Welch stoppered the bottles with cork and wax and boiled them in water hoping to kill any yeast in the juice to prevent fermentation. Dr. Welch&#39;s process was a success, and his application of Louis Pasteur&#39;s theory of pasteurization to preserve fresh grape juice pioneered the industry of canned and bottled fruit juices in America. This first juice was used on the Communion table in the local Methodist church for sacramental purposes, and most of the first orders for grape juice came from churches for Communion.</p>\r\n\r\n<p>Charles Welch transferred the juice operations to Watkins Glen, New York in 1896, and the following year to Westfield, New York. He processed 300 tons of grapes in 1897.</p>\r\n\r\n<p>In 1952, Welch&#39;s was sold to the National Grape Cooperative Association who remains our owners today. In 1971, Welch&#39;s enter the Japanese market with bulk concentrate for other manufacturers which grew&nbsp;into a huge success. In the mid-eighties, President Everett Baldwin moved the headquarters from Westfield, New York to Concord, Massachusetts, the birthplace of the Concord grape. During his tenure, he updated packaging, created a new logo and introduced many new products.</p>\r\n\r\n<p>Today, Welch&#39;s is led by our dynamic President &amp; CEO, Mr. Brad Irwin who continues to guide us into exciting new areas like Ingredients, Licensing and Innovation that will create&nbsp;greater value for our 1000 owner farmers at National Grape Cooperative and for the millions of consumers who cherish our iconic brand. We are farmers. We are family. We are grape. And we love purple!</p>","Our History","","","index,follow","2","1","1","1","1","10_09_47_08_09_14_000000Niagara_grapes_on_vine.jpg","02_09_51_09_09_14_000000Welchs History.png","","Our History","1","Our History","");
INSERT INTO child_pages VALUES("2","uniqueness","Uniqueness","<p>The Concord grape is a special grape.. This sweet, rich, bold purple grape needs a temperate climate to grow - specifically, we need the lake for warmth in the fall and coolness in the Spring.&nbsp;Just like wine, Welch&#39;s 100% Grape Juice gets its taste from where the grapes are grown. It&#39;s because of the Concord grape that Welch&#39;s 100% Grape Juice is so delicious and unique.</p>","Uniqueness","","","index,follow","1","1","1","1","2","11_09_30_08_09_14_000000Niagara_grapes_on_vine.jpg","05_09_57_12_09_14_000000IMG_0442.png","","Uniqueness","1","Uniqueness","");
INSERT INTO child_pages VALUES("3","harvest-season","Harvest Season","<p>Our harvest runs from early September to the end of October.</p>","Harvest Season","","","index,follow","6","1","1","1","2","11_09_14_08_09_14_000000Concord_grapes_on_vine.jpg","11_09_14_08_09_14_000000Grape Harvest.png","","Harvest","1","Harvest Season","");
INSERT INTO child_pages VALUES("4","organization","Organization","<p>Welch&#39;s Global Ingredients Group is a division of Welch&rsquo;s Food, which is own by National Grape Cooperative.&nbsp;</p>","Organization","","","index,follow","3","1","1","1","1","11_09_57_08_09_14_000000Concord_grapes_on_vine.jpg","04_09_31_12_09_14_000000IMG_0442.png","","Organization","1","Organization","");
INSERT INTO child_pages VALUES("5","vitis-labrusca-vs-vitis-vinifera","Vitis labrusca vs Vitis vinifera","","Vitis labrusca vs Vitis vinifera","","","index,follow","2","1","1","1","2","11_09_42_08_09_14_000000Concord_grapes_on_vine.jpg","11_09_40_08_09_14_000000Niagra-&-Concord-Grapes.png","","Vitis labrusca vs Vitis vinifera","1","Vitis labrusca vs Vitis vinifera","");
INSERT INTO child_pages VALUES("6","concentrates","Concentrates","<p><img alt=\\\"\\\" src=\\\"/Robinson/ckfinder/userfiles/images/products/Concentrates.png\\\" /></p>\r\n\r\n<p>**Shaded blue column connotes product code(s) specs for concentrates.*</p>","Concentrates","","","index,follow","1","1","1","1","3","01_09_49_09_09_14_000000Concord_grapes_on_vine.jpg","09_09_24_10_09_14_000000Grapes in a basket.png","","Concentrates","1","Concentrates","");
INSERT INTO child_pages VALUES("7","national-grape-cooperative","National Grape Cooperative","<p>At the heart of Welch&rsquo;s you will find 1000 committed multi-generation family farmer owners. &nbsp;For these men and women, grapes aren&rsquo;t just juice and ingredients, but a way of life. &nbsp;And it shows &ndash; many of Welch&rsquo;s family farmers have been working land that&rsquo;s been in their families for generations.</p>\r\n\r\n<p>With over 40,000 acres (16,000 hectares) of vineyards in the United States and Canada, Welch&rsquo;s family farms span across North America. &nbsp;Every farmer has tremendous passion and pride for their work, ensuring the highest quality grapes for our juices, jellies and more &ndash; year after year.</p>","National Grape Cooperative","","","index,follow","4","1","1","1","1","11_09_17_08_09_14_000000Concord_grapes_on_vine.jpg","06_09_10_12_09_14_000000Sign.png","","National Grape Cooperative","1","National Grape Cooperative","");
INSERT INTO child_pages VALUES("8","concord-grapes","Concord Grapes: A Whole Bunch of Good","<p>&nbsp;</p>\r\n\r\n<p>Indeed the Concord grape is a little purple fruit that packs quite a nutrition punch. That&#39;s because Concord grapes have natural plant nutrients called polyphenols and research suggests that certain polyphenols may play a role in supporting heart health. To add to that, more than a decade&#39;s worth of research suggests that drinking 100% grape juice made with Concord grapes can help support a healthy heart.&nbsp;</p>","Concord Grapes: A Whole Bunch of Good","","","index,follow","3","1","1","1","2","11_09_29_08_09_14_000000Concord_grapes_on_vine.jpg","02_09_14_18_09_14_000000Basket-grapes.png","","Concord Grapes: A Whole Bunch of Good","1","Concord Grapes","");
INSERT INTO child_pages VALUES("9","affordability","Affordability","<p>The Concord grape which has been around for 145 years, is one of the most affordable grape juices.</p>\r\n\r\n<h3><strong>The Concord Grape: A Whole Bunch of Good</strong></h3>","","","","index,follow","4","1","1","1","2","11_09_05_08_09_14_000000Concord_grapes_on_vine.jpg","02_09_27_18_09_14_000000Afford.png","","Affordability","1","Affordability","");
INSERT INTO child_pages VALUES("10","locations-of-vineyards","Locations of Vineyards","<div>&nbsp;</div>\r\n\r\n<div>\r\n<div>National Grape Cooperative has over 43,000 acres (+16000 hectares) of vineyards, 85% of our purple Concord grape and 15% of our white Niagara grape, which stretch from the Western US in the Yakima Valley, Washington to Michigan and Ohio in the Mid-west to Pennsylvania , New York and Canada on the East coast.</div>\r\n</div>","Locations of Vineyards","","","index,follow","5","1","1","1","2","09_09_23_08_09_14_000000Concord_grapes_on_vine.jpg","11_09_40_08_09_14_000000Vineyards.png","","Locations of Vineyards","1","Locations of Vineyards","");
INSERT INTO child_pages VALUES("11","blends","Blends","<p><img alt=\\\"\\\" src=\\\"/Robinson/ckfinder/userfiles/images/products/Blends.png\\\" /></p>\r\n\r\n<p>*Shaded blue column connotes product code(s) specs for Blends.</p>","Blends","","","index,follow","2","1","1","1","3","01_09_23_09_09_14_000000Concord_grapes_on_vine.jpg","04_09_52_12_09_14_000000IMG_0442.png","","Blends","1","Blends","");
INSERT INTO child_pages VALUES("12","purees","Purees","<p><img alt=\\\"\\\" src=\\\"/Robinson/ckfinder/userfiles/images/products/Puree.png\\\" />*Shaded blue column connotes product code(s) specs for Purees.</p>","Purees","","","index,follow","3","1","1","1","3","01_09_41_09_09_14_000000Concord_grapes_on_vine.jpg","04_09_11_12_09_14_000000IMG_0442.png","","Purees","1","Purees","");
INSERT INTO child_pages VALUES("13","essences","Essences","<p><img alt=\\\"\\\" src=\\\"/Robinson/ckfinder/userfiles/images/products/Essence.png\\\" /></p>\r\n\r\n<p>*Shaded blue column connotes product code(s) specs for Essences.</p>","Essences","","","index,follow","4","1","1","1","3","01_09_36_09_09_14_000000Concord_grapes_on_vine.jpg","04_09_28_12_09_14_000000IMG_0442.png","","Essences","1","Essences","");
INSERT INTO child_pages VALUES("14","shelf-life","Shelf Life","<h2><strong>Shelf Life:</strong> 2 years</h2>\r\n\r\n<p><strong>Storage of drums:</strong> Less than 0&deg;F or -18&deg;C</p>\r\n\r\n<p><strong>Packaging:</strong> Tankers (4300 gallons at 68 Brix or 16.277 liters), drums (50 gallons or 189.27 liters or 52 gallons or 196.84 liters) and pails (5 gallons or 18.93 liters)</p>\r\n\r\n<p><strong>Shipping Temperature:</strong> &nbsp;depends on shipping time. &nbsp;Frozen drums can be shipped in a dry reefer if less than 20 days from frozen storage warehouse to frozen storage warehouse. &nbsp;A natural thawing process will begin bu the product will remain frozen until arrival. &nbsp;Every effort should be made to keep the container cool such as avoiding direct sunlight.</p>\r\n\r\n<p><strong>Continuance of Supply</strong>: Welch&rsquo;s is the marketing arm of National Grape Cooperative, the leading Concord and Niagara grape vineyard growers in the U.S. with over 40,000 acres (16000 hectares) under vine and over 60% of the total Concord market. &nbsp;We can indeed assure sufficient supply.</p>\r\n\r\n<p><strong>Long-Term Pricing:</strong> Welch&rsquo;s makes every effort to guarantee long-term pricing.</p>\r\n\r\n<p><strong>Lead Times:</strong> Welch&rsquo;s requires 4-6 weeks average lead time to process an order.</p>\r\n\r\n<p><strong>Ship Time</strong>: Will vary depending on final destination. &nbsp;Average ship time is 3 weeks to Asia and 5 weeks to Europe from our Grandview, Washington plant.</p>","Shelf Life","","","index,follow","1","1","1","1","4","01_09_05_09_09_14_000000Concord_grapes_on_vine.jpg","04_09_29_12_09_14_000000IMG_0442.png","","Shelf Life","1","Shelf Life","");
INSERT INTO child_pages VALUES("15","storage","Storage","<p><strong>Shelf Life</strong>: 2 years</p>\r\n\r\n<h2><strong>Storage of drums:</strong> Less than 0&deg;F or -18&deg;C</h2>\r\n\r\n<p><strong>Packaging:</strong> Tankers (4300 gallons at 68 Brix or 16.277 liters), drums (50 gallons or 189.27 liters or 52 gallons or 196.84 liters) and pails (5 gallons or 18.93 liters)</p>\r\n\r\n<p><strong>Shipping Temperature: </strong>&nbsp;depends on shipping time. &nbsp;Frozen drums can be shipped in a dry reefer if less than 20 days from frozen storage warehouse to frozen storage warehouse. &nbsp;A natural thawing process will begin bu the product will remain frozen until arrival. &nbsp;Every effort should be made to keep the container cool such as avoiding direct sunlight.</p>\r\n\r\n<p><strong>Continuance of Supply</strong>: Welch&rsquo;s is the marketing arm of National Grape Cooperative, the leading Concord and Niagara grape vineyard growers in the U.S. with over 40,000 acres (16000 hectares) under vine and over 60% of the total Concord market. &nbsp;We can indeed assure sufficient supply.</p>\r\n\r\n<p><strong>Long-Term Pricing:</strong> Welch&rsquo;s makes every effort to guarantee long-term pricing.</p>\r\n\r\n<p><strong>Lead Times:</strong> Welch&rsquo;s requires 4-6 weeks average lead time to process an order.</p>\r\n\r\n<p><strong>Ship Time:</strong> Will vary depending on final destination. &nbsp;Average ship time is 3 weeks to Asia and 5 weeks to Europe from our Grandview, Washington plant.</p>","Storage","","","index,follow","2","1","1","1","4","01_09_20_09_09_14_000000Concord_grapes_on_vine.jpg","04_09_13_12_09_14_000000IMG_0442.png","","Storage","1","Storage","");
INSERT INTO child_pages VALUES("16","packaging","Packaging","<p><strong>Shelf Life</strong>: 2 years</p>\r\n\r\n<p><strong>Storage of drums:</strong> Less than 0&deg;F or -18&deg;C</p>\r\n\r\n<h2><strong>Packaging:</strong> Tankers (4300 gallons at 68 Brix or 16.277 liters), drums (50 gallons or 189.27 liters or 52 gallons or 196.84 liters) and pails (5 gallons or 18.93 liters)</h2>\r\n\r\n<p><strong>Shipping Temperature</strong>: &nbsp;depends on shipping time. &nbsp;Frozen drums can be shipped in a dry reefer if less than 20 days from frozen storage warehouse to frozen storage warehouse. &nbsp;A natural thawing process will begin bu the product will remain frozen until arrival. &nbsp;Every effort should be made to keep the container cool such as avoiding direct sunlight.</p>\r\n\r\n<p><strong>Continuance of Supply:</strong> Welch&rsquo;s is the marketing arm of National Grape Cooperative, the leading Concord and Niagara grape vineyard growers in the U.S. with over 40,000 acres (16000 hectares) under vine and over 60% of the total Concord market. &nbsp;We can indeed assure sufficient supply.</p>\r\n\r\n<p><strong>Long-Term Pricing:</strong> Welch&rsquo;s makes every effort to guarantee long-term pricing.</p>\r\n\r\n<p><strong>Lead Times:</strong> Welch&rsquo;s requires 4-6 weeks average lead time to process an order.</p>\r\n\r\n<p><strong>Ship Time:</strong> Will vary depending on final destination. &nbsp;Average ship time is 3 weeks to Asia and 5 weeks to Europe from our Grandview, Washington plant.</p>","Packaging","","","index,follow","3","1","1","1","4","01_09_36_09_09_14_000000Concord_grapes_on_vine.jpg","11_09_17_12_09_14_000000DRUM_WELCHS.png","","Packaging","1","Packaging","");
INSERT INTO child_pages VALUES("17","shipping-temperature","Shipping Temperature","<p><strong>Shelf Life:</strong> 2 years</p>\r\n\r\n<p><strong>Storage of drums</strong>: Less than 0&deg;F or -18&deg;C</p>\r\n\r\n<p><strong>Packaging</strong>: Tankers (4300 gallons at 68 Brix or 16.277 liters), drums (50 gallons or 189.27 liters or 52 gallons or 196.84 liters) and pails (5 gallons or 18.93 liters)</p>\r\n\r\n<h2><strong>Shipping Temperature:</strong> &nbsp;depends on shipping time. &nbsp;Frozen drums can be shipped in a dry reefer if less than 20 days from frozen storage warehouse to frozen storage warehouse. &nbsp;A natural thawing process will begin bu the product will remain frozen until arrival. &nbsp;Every effort should be made to keep the container cool such as avoiding direct sunlight.</h2>\r\n\r\n<p><strong>Continuance of Supply: </strong>Welch&rsquo;s is the marketing arm of National Grape Cooperative, the leading Concord and Niagara grape vineyard growers in the U.S. with over 40,000 acres (16000 hectares) under vine and over 60% of the total Concord market. &nbsp;We can indeed assure sufficient supply.</p>\r\n\r\n<p><strong>Long-Term Pricing</strong>: Welch&rsquo;s makes every effort to guarantee long-term pricing.</p>\r\n\r\n<p><strong>Lead Times:</strong> Welch&rsquo;s requires 4-6 weeks average lead time to process an order.</p>\r\n\r\n<p><strong>Ship Time:</strong> Will vary depending on final destination. &nbsp;Average ship time is 3 weeks to Asia and 5 weeks to Europe from our Grandview, Washington plant.</p>","Shipping Temperature","","","index,follow","4","1","1","1","4","09_09_22_10_09_14_000000Concord_grapes_on_vine.jpg","04_09_52_12_09_14_000000IMG_0442.png","","Shipping Temperature","1","Shipping Temperature","");
INSERT INTO child_pages VALUES("18","continuance-of-supply","Continuance of Supply","<p><strong>Shelf Life</strong>: 2 years</p>\r\n\r\n<p><br />\r\n<strong>Storage of drums:</strong>&nbsp;Less than 0&deg;F or -18&deg;C</p>\r\n\r\n<p><br />\r\n<strong>Packaging:</strong>&nbsp;pails, drums, tanktainers</p>\r\n\r\n<p><br />\r\n<strong>Shipping Temperature:&nbsp;</strong>&nbsp;depends on shipping time. &nbsp;Frozen drums can be shipped in a dry reefer if less than 20 days from frozen storage warehouse to frozen storage warehouse. &nbsp;A natural thawing process will begin bu the product will remain frozen until arrival. &nbsp;Every effort should be made to keep the container cool such as avoiding direct sunlight.</p>\r\n\r\n<h2><br />\r\n<strong>Continuance of Supply:</strong>&nbsp;Welch&rsquo;s is the marketing arm of National Grape Cooperative, the leading Concord and Niagara grape growers in the U.S. with over 40,000 acres (16000 hectares) under vine and over 60% of the total Concord market. &nbsp;We can indeed assure sufficient supply.</h2>\r\n\r\n<p><br />\r\n<strong>Long-Term Pricing</strong>: Welch&rsquo;s makes every effort to guarantee long-term pricing.</p>\r\n\r\n<p><br />\r\n<strong>Lead Times:</strong>&nbsp;Welch&rsquo;s requires 4-6 weeks average lead time to process an order.</p>\r\n\r\n<p><br />\r\n<strong>Ship Time:</strong>&nbsp;Will vary depending on final destination. &nbsp;Average ship time is 3 weeks to Asia and 5 weeks to Europe from our Grandview, Washington plant.</p>","Continuance of Supply","","","index,follow","5","1","1","1","4","01_09_15_09_09_14_000000Concord_grapes_on_vine.jpg","04_09_11_12_09_14_000000IMG_0442.png","","Continuance of Supply","1","Continuance of Supply","");
INSERT INTO child_pages VALUES("19","long-term-pricing","Long Term Pricing","<p><strong>Shelf Life</strong>: 2 years</p>\r\n\r\n<p><strong>Storage of drums</strong>: Less than 0&deg;F or -18&deg;C</p>\r\n\r\n<p><strong>Packaging: </strong>Tankers (4300 gallons at 68 Brix or 16.277 liters), drums (50 gallons or 189.27 liters or 52 gallons or 196.84 liters) and pails (5 gallons or 18.93 liters)</p>\r\n\r\n<p><strong>Shipping Temperature:</strong> &nbsp;depends on shipping time. &nbsp;Frozen drums can be shipped in a dry reefer if less than 20 days from frozen storage warehouse to frozen storage warehouse. &nbsp;A natural thawing process will begin bu the product will remain frozen until arrival. &nbsp;Every effort should be made to keep the container cool such as avoiding direct sunlight.</p>\r\n\r\n<p><strong>Continuance of Supply</strong>: Welch&rsquo;s is the marketing arm of National Grape Cooperative, the leading Concord and Niagara grape vineyard growers in the U.S. with over 40,000 acres (16000 hectares) under vine and over 60% of the total Concord market. &nbsp;We can indeed assure sufficient supply.</p>\r\n\r\n<h2><strong>Long-Term Pricing</strong>: Welch&rsquo;s makes every effort to guarantee long-term pricing.</h2>\r\n\r\n<p><strong>Lead Times</strong>: Welch&rsquo;s requires 4-6 weeks average lead time to process an order.</p>\r\n\r\n<p><strong>Ship Time</strong>: Will vary depending on final destination. &nbsp;Average ship time is 3 weeks to Asia and 5 weeks to Europe from our Grandview, Washington plant.</p>","Long Term Pricing","","","index,follow","6","1","1","1","4","01_09_39_09_09_14_000000Concord_grapes_on_vine.jpg","04_09_24_12_09_14_000000IMG_0442.png","","Long Term Pricing","1","Long Term Pricing","");
INSERT INTO child_pages VALUES("20","lead-time","Lead Time","<p><strong>Shelf Life: </strong>2 years</p>\r\n\r\n<p><strong>Storage of drums:</strong> Less than 0&deg;F or -18&deg;C</p>\r\n\r\n<p><strong>Packaging:</strong> Tankers (4300 gallons at 68 Brix or 16.277 liters), drums (50 gallons or 189.27 liters or 52 gallons or 196.84 liters) and pails (5 gallons or 18.93 liters)</p>\r\n\r\n<p><strong>Shipping Temperature:</strong> &nbsp;depends on shipping time. &nbsp;Frozen drums can be shipped in a dry reefer if less than 20 days from frozen storage warehouse to frozen storage warehouse. &nbsp;A natural thawing process will begin bu the product will remain frozen until arrival. &nbsp;Every effort should be made to keep the container cool such as avoiding direct sunlight.</p>\r\n\r\n<p><strong>Continuance of Supply</strong>: Welch&rsquo;s is the marketing arm of National Grape Cooperative, the leading Concord and Niagara grape vineyard growers in the U.S. with over 40,000 acres (16000 hectares) under vine and over 60% of the total Concord market. &nbsp;We can indeed assure sufficient supply.</p>\r\n\r\n<p><strong>Long-Term Pricing:</strong> Welch&rsquo;s makes every effort to guarantee long-term pricing.</p>\r\n\r\n<h2><strong>Lead Times</strong>: Welch&rsquo;s requires 4-6 weeks average lead time to process an order.</h2>\r\n\r\n<p><strong>Ship Time</strong>: Will vary depending on final destination. &nbsp;Average ship time is 3 weeks to Asia and 5 weeks to Europe from our Grandview, Washington plant.</p>","Lead Time","","","index,follow","7","1","1","1","4","01_09_04_09_09_14_000000Concord_grapes_on_vine.jpg","04_09_37_12_09_14_000000IMG_0442.png","","Lead Time","1","Lead Time","");
INSERT INTO child_pages VALUES("21","ship-time","Ship Time","<p><strong>Shelf Life</strong>: 2 years</p>\r\n\r\n<p><strong>Storage of drums:</strong> Less than 0&deg;F or -18&deg;C</p>\r\n\r\n<p><strong>Packaging</strong>: Tankers (4300 gallons at 68 Brix or 16.277 liters), drums (50 gallons or 189.27 liters or 52 gallons or 196.84 liters) and pails (5 gallons or 18.93 liters)</p>\r\n\r\n<p><strong>Shipping Temperature:</strong> &nbsp;depends on shipping time. &nbsp;Frozen drums can be shipped in a dry reefer if less than 20 days from frozen storage warehouse to frozen storage warehouse. &nbsp;A natural thawing process will begin bu the product will remain frozen until arrival. &nbsp;Every effort should be made to keep the container cool such as avoiding direct sunlight.</p>\r\n\r\n<p><strong>Continuance of Supply: </strong>Welch&rsquo;s is the marketing arm of National Grape Cooperative, the leading Concord and Niagara grape vineyard growers in the U.S. with over 40,000 acres (16000 hectares) under vine and over 60% of the total Concord market. &nbsp;We can indeed assure sufficient supply.</p>\r\n\r\n<p><strong>Long-Term Pricing</strong>: Welch&rsquo;s makes every effort to guarantee long-term pricing.</p>\r\n\r\n<p><strong>Lead Times:</strong> Welch&rsquo;s requires 4-6 weeks average lead time to process an order.</p>\r\n\r\n<h2><strong>Ship Time</strong>: Will vary depending on final destination. &nbsp;Average ship time is 3 weeks to Asia and 5 weeks to Europe from our Grandview, Washington plant.</h2>","Ship Time","","","index,follow","8","1","1","1","4","01_09_55_09_09_14_000000Concord_grapes_on_vine.jpg","04_09_12_12_09_14_000000IMG_0442.png","","Ship Time","1","Ship Time","");
INSERT INTO child_pages VALUES("22","juice-beverages-smoothies","Juice Beverages Smoothies","<div>\r\n<div>\r\n<p><img alt=\\\"\\\" src=\\\"/Robinson/ckfinder/userfiles/images/Applications/Juices.png\\\" style=\\\"width:100%\\\" /></p>\r\n\r\n<p>The sweet, bold, purple Concord is indeed a very unique and versatile grape ideal for a wide range of Beverage applications.&nbsp; It is perfect for 100% juices, blends, CSD&rsquo;s and smoothies.&nbsp; Both of our Concord and Niagara (white) grape concentrates deliver a delicious flavor.&nbsp;</p>\r\n\r\n<p><span style=\\\"font-family:arial,helvetica,sans-serif; font-size:12px\\\">*Shaded blue connotes acceptable use.</span></p>\r\n</div>\r\n</div>","Juice Beverages Smoothies","","","index,follow","1","1","1","1","9","03_09_37_09_09_14_000000Concord_grapes_on_vine.jpg","03_09_28_09_09_14_000000Welchs Juices.png","","Juice/Beverages/Smoothies","1","Juice/Beverages/Smoothies","");
INSERT INTO child_pages VALUES("23","jams-jellies-marmalades","Jams, Jellies & Marmalades","<p><img alt=\\\"\\\" src=\\\"/Robinson/ckfinder/userfiles/images/Applications/Jellies%20Jams.png\\\" style=\\\"width:100%\\\" /></p>\r\n\r\n<p>The sweet, bold, purple Concord grape is indeed a very unique and versatile grape perfect for a wide range of Jams, Jellies and Marmalades applications.&nbsp; Both our Concord and Niagara Purees and Concentrates are perfect to deliver a taste you will not soon forget.&nbsp;</p>\r\n\r\n<p><span style=\\\"font-family:arial,helvetica,sans-serif; font-size:12px\\\">*Shaded blue connotes acceptable use.</span></p>","Jams, Jellies & Marmalades","","","index,follow","2","1","1","1","9","03_09_58_09_09_14_000000Concord_grapes_on_vine.jpg","03_09_57_09_09_14_000000Welchs Jellies.png","","Jams, Jellies & Marmalades","1","Jams, Jellies & Marmalades","");
INSERT INTO child_pages VALUES("24","dairy-ice-cream","Dairy & Ice Cream","<p><img alt=\\\"\\\" src=\\\"/Robinson/ckfinder/userfiles/images/Applications/Dairy.png\\\" style=\\\"width:100%\\\" /></p>\r\n\r\n<p>The sweet, bold, purple Concord grape is indeed a very unique and versatile grape perfect for a wide range of Dairy products like yogurt, cream spreads as well as ice cream.&nbsp; Our Concord Purees and Concentrates are perfect to deliver a smooth and creamy taste you will not soon forget.&nbsp;</p>\r\n\r\n<p><span style=\\\"font-family:arial,helvetica,sans-serif; font-size:12px\\\">*Shaded blue connotes acceptable use.</span></p>","Dairy & Ice Cream","","","index,follow","3","1","1","1","9","03_09_12_09_09_14_000000Concord_grapes_on_vine.jpg","10_09_30_22_09_14_000000dairy-2.png","","Dairy & Ice Cream","1","Dairy & Ice Cream","");
INSERT INTO child_pages VALUES("25","frozen-desserts-novelties","Frozen Desserts/Novelties","<p><img alt=\\\"\\\" src=\\\"/Robinson/ckfinder/userfiles/images/Applications/Frozen%20Desserts.png\\\" style=\\\"width:100%\\\" /></p>\r\n\r\n<p>The sweet, bold, purple Concord grape is indeed a very unique and versatile grape perfect for a wide range of Frozen Desserts and Novelties like pops and ice bars.&nbsp; Our Concord and Niagara Concentrates and Purees are very suitable for this type of low temperature application.&nbsp; Both flavor and color are very stable.&nbsp;</p>\r\n\r\n<p><span style=\\\"font-family:arial,helvetica,sans-serif; font-size:12px\\\">*Shaded blue connotes acceptable use.</span></p>","Frozen Desserts/Novelties","","","index,follow","4","1","1","1","9","07_09_12_06_09_14_000000band-1.jpg","01_09_34_09_09_14_000000Welchs Ice Bars.png","","Frozen Desserts/Novelties","1","Frozen Desserts/Novelties","");
INSERT INTO child_pages VALUES("26","confectionary","Confectionary","<p><img alt=\\\"\\\" src=\\\"/Robinson/ckfinder/userfiles/images/Applications/Confectionary.png\\\" style=\\\"width:100%\\\" /></p>\r\n\r\n<p>The sweet, bold purple Concord grape is indeed a very unique and versatile grape perfect for a wide range of applications such as Confectionary.&nbsp; It is perfect for soft candies like gummy bears as well as hard candies, gums and even chocolates.&nbsp; Both our Concord and Niagara (white) grape concentrates and Purees are perfect as a filling or glaze.&nbsp;</p>\r\n\r\n<p><span style=\\\"font-family:arial,helvetica,sans-serif; font-size:12px\\\">*Shaded blue connotes acceptable use.</span>&nbsp;</p>","Confectionary","","","index,follow","5","1","1","1","9","03_09_46_09_09_14_000000Concord_grapes_on_vine.jpg","03_09_31_09_09_14_000000Welchs CONFECTIONARY.png","","Confectionary","1","Confectionary","");
INSERT INTO child_pages VALUES("27","sauces-dips","Sauces / Dips","<p><img alt=\\\"\\\" src=\\\"/Robinson/ckfinder/userfiles/images/Applications/Sauces%20Dips.png\\\" style=\\\"width:100%\\\" /></p>\r\n\r\n<p>The sweet, bold, purple Concord grape is indeed a very unique and versatile grape perfect for a wide range of Sauces and Dips like dipping and grilling sauces, marinades and dressings. &nbsp;Our Concord Concentrates and Purees work very well in this type of application.&nbsp;</p>\r\n\r\n<p><span style=\\\"font-family:arial,helvetica,sans-serif; font-size:12px\\\">*Shaded blue connotes acceptable use.</span></p>","Sauces / Dips","","","index,follow","6","1","1","1","9","03_09_38_09_09_14_000000Concord_grapes_on_vine.jpg","03_09_54_09_09_14_000000Welchs Sauces.png","","Sauces/Dips","1","Sauces / Dips","");
INSERT INTO child_pages VALUES("28","snacks-bakery","Snacks / Bakery","<p><img alt=\\\"\\\" src=\\\"/Robinson/ckfinder/userfiles/images/Applications/Snacks.png\\\" style=\\\"width:100%\\\" /></p>\r\n\r\n<p>The sweet, bold, purple Concord grape is indeed a very unique and versatile grape perfect for a wide range of Snack Foods and Bakery applications such as cookies, danish, cereal bars, cereal, pies and cakes as toppings, filling, fruit preps, icing or flour.&nbsp; Our Concord Concentrates and Purees will give you a color and taste that you will soon not forget.&nbsp;</p>\r\n\r\n<p><span style=\\\"font-family:arial,helvetica,sans-serif; font-size:12px\\\">*Shaded blue connotes acceptable use.</span></p>","Snacks / Bakery","","","index,follow","7","1","1","1","9","03_09_59_09_09_14_000000Concord_grapes_on_vine.jpg","03_09_28_09_09_14_000000Welchs Bakery.png","","Snacks/Bakery","1","Snacks / Bakery","");
INSERT INTO child_pages VALUES("39","our-farmers","Our Farmers","<div class=\\\"row\\\">\r\n<div class=\\\"col-lg-6 farmer\\\">\r\n<div class=\\\"farmer-img\\\"><img src=\\\"http://webproone.com/projects/welch/images/Dave_Nichols.jpg\\\" style=\\\"height:375px; width:500px\\\" /></div>\r\n\r\n<div class=\\\"farmer-name\\\">Dave Nichols</div>\r\n\r\n<div class=\\\"txt\\\">&quot;It takes a lot of care to bring a grapevine into production.&quot;</div>\r\n<div class=\\\"farmer-sig\\\">Dave Nichols</div>\r\n</div>\r\n\r\n<div class=\\\"col-lg-6 farmer\\\">\r\n<div class=\\\"farmer-img\\\"><img src=\\\"http://webproone.com/projects/welch/images/Bob_Militello.jpg\\\" style=\\\"height:375px; width:500px\\\" /></div>\r\n\r\n<div class=\\\"farmer-name\\\">Bob Militello</div>\r\n\r\n<div class=\\\"txt\\\">&quot;The Welch&#39;s brand name and label stand for quality and trust.&quot;</div>\r\n<div class=\\\"farmer-sig\\\">Bob Militello</div>\r\n</div>\r\n\r\n<div class=\\\"col-lg-6 farmer\\\">\r\n<div class=\\\"farmer-img\\\"><img src=\\\"http://webproone.com/projects/welch/images/Dan_Sprague.jpg\\\" style=\\\"height:375px; width:500px\\\" /></div>\r\n\r\n<div class=\\\"farmer-name\\\">Dan Sprague</div>\r\n\r\n<div class=\\\"txt\\\">&quot;I&#39;m glad to be part of a good company that works very hard at becoming a great company.&quot;</div>\r\n<div class=\\\"farmer-sig\\\">Dan Sprague</div>\r\n</div>\r\n\r\n<div class=\\\"col-lg-6 farmer\\\">\r\n<div class=\\\"farmer-img\\\"><img src=\\\"http://webproone.com/projects/welch/images/TimGrow.jpg\\\" style=\\\"height:375px; width:500px\\\" /></div>\r\n\r\n<div class=\\\"farmer-name\\\">Tim Grow</div>\r\n\r\n<div class=\\\"txt\\\">&quot;It&#39;s just a real thrilling event for me to see the work of my labor come across that belt in the form of Concord Grapes.&quot;</div>\r\n<div class=\\\"farmer-sig\\\">Tim Grow</div>\r\n</div>\r\n</div>","Our Farmers","","","index,follow","5","1","1","1","1","01_09_38_09_09_14_000000Concord_grapes_on_vine.jpg","","","Our Farmers","1","Our Farmers","");
INSERT INTO child_pages VALUES("29","alcoholic-beverages-syrups","Alcoholic Beverages / Mixers / Syrups","<p><img alt=\\\"\\\" src=\\\"/Robinson/ckfinder/userfiles/images/Applications/Alcoholic%20Beverages.png\\\" style=\\\"width:100%\\\" /></p>\r\n\r\n<p>The sweet, bold, purple Concord is indeed a very unique and versatile grape ideal for a wide range of Alcoholic Beverage, Mixer and Syrup applications.&nbsp; It is perfect for cocktails, spirits, liqueurs and a wide variety of mixers and syrups.&nbsp; Both of our Concord and Niagara (white) grape concentrates deliver a delicious flavor.&nbsp;</p>\r\n\r\n<p><span style=\\\"font-family:arial,helvetica,sans-serif; font-size:12px\\\">*Shaded blue connotes acceptable use.</span></p>","Alcoholic Beverages / Mixers / Syrups","","","index,follow","8","1","1","1","9","03_09_11_09_09_14_000000Concord_grapes_on_vine.jpg","03_09_23_09_09_14_000000Welchs Beverages.png","","Alcoholic Beverages / Mixers / Syrups","1","Alcoholic Beverages / Mixers / Syrups","");
INSERT INTO child_pages VALUES("37","other","Other","<p><img alt=\\\"\\\" src=\\\"/Robinson/ckfinder/userfiles/images/products/Other.png\\\" />*Shaded blue column connotes product code(s) specs for a particular product.</p>","Other","","","index,follow","5","1","1","1","3","01_09_52_09_09_14_000000Concord_grapes_on_vine.jpg","04_09_48_12_09_14_000000IMG_0442.png","","","1","Other","");
INSERT INTO child_pages VALUES("30","","","","","","","index,follow","0","0","0","1","0","","","","","0","","");
INSERT INTO child_pages VALUES("31","vineyard-care","Vineyard Care","<h2><strong>Vineyard Care:</strong></h2>\r\n\r\n<h2>Quality and care of our vineyards are controlled through the owners of Welch Foods, the National Grape Cooperative. &nbsp;The growers follow strict vineyard management practices through the Cooperative Sustainability Program to maximize yields and ensure a high-quality crop.</h2>\r\n\r\n<h2>&nbsp;</h2>\r\n\r\n<p><strong><span style=\\\"font-family:arial,sans-serif; font-size:10pt\\\">Harvest:</span></strong></p>\r\n\r\n<p><span style=\\\"font-family:arial,sans-serif; font-size:10pt\\\">Grapes are harvested by use of mechanical harvesters and are pressed&nbsp;within eight hours.&nbsp; The close proximity of our vineyards to our processing plants ensures grape quality is preserved from the vineyard to the plant.&nbsp; Strict standards are in place to ensure a consistent and high-quality crop from year to year.</span></p>\r\n\r\n<p><strong><span style=\\\"font-family:arial,sans-serif; font-size:10pt\\\">Processing Plant: &nbsp;</span></strong></p>\r\n\r\n<p><span style=\\\"font-family:arial,sans-serif; font-size:10pt\\\">The plant&rsquo;s extensive production capabilities include grape harvesting, juice storage, concentrator operations, and shipment to many domestic and international locations.&nbsp; &nbsp;&nbsp;&nbsp;</span></p>\r\n\r\n<p><strong><span style=\\\"font-family:arial,sans-serif; font-size:10pt\\\">Certification:</span></strong></p>\r\n\r\n<p><span style=\\\"font-family:arial,sans-serif; font-size:10pt\\\">Grandview, Washington Plant is GFSI Certified (SQF &ndash; Level II).&nbsp; Other certifications include Halal, Orthodox Union, Circle U, Triangle K, and Organic.</span></p>\r\n\r\n<p><strong><span style=\\\"font-family:arial,sans-serif; font-size:10pt\\\">HACCP:</span></strong></p>\r\n\r\n<p><span style=\\\"font-family:arial,sans-serif; font-size:10pt\\\">Food safety of all products produced at Welch&rsquo;s facilities, for both internal and external customers, is our highest priority.&nbsp; Our HACCP System was developed using the principles identified in the National Advisory Committee on Microbiological Criteria for Foods (NACMCF)&nbsp;<em>Hazard Analysis and Critical Control Point Principles and Application Guidelines</em>&nbsp;(1997).&nbsp;&nbsp; New and emerging legislative/regulatory and customer requirements are incorporated into the HACCP program as needed with guidance from the Welch&rsquo;s Corporate HACCP Advisory Committee. The HACCP system is reviewed and validated annually by trained and competent personnel.&nbsp;</span></p>\r\n\r\n<p>&nbsp;</p>","Vineyard Care","","","index,follow","1","1","1","1","6","04_09_17_12_09_14_000000Niagara_grapes_on_vine.jpg","04_09_45_12_09_14_000000IMG_0442.png","","Vineyard Care","1","Vineyard Care","");
INSERT INTO child_pages VALUES("32","harvest","Harvest","<p><strong>Vineyard Care:</strong><br />\r\nQuality and care of our vineyards are controlled through the owners of Welch Foods, the National Grape Cooperative. &nbsp;The growers follow strict vineyard management practices through the Cooperative Sustainability Program to maximize yields and ensure a high-quality crop.</p>\r\n\r\n<h2><strong>Harvest:</strong><br />\r\nGrapes are harvested by use of mechanical harvesters and are pressed&nbsp;within eight hours. &nbsp;The close proximity of our vineyards to our processing plants ensures grape quality is preserved from the vineyard to the plant. &nbsp;Strict standards are in place to ensure a consistent and high-quality crop from year to year.</h2>\r\n\r\n<p><strong>Processing Plant: &nbsp;</strong><br />\r\nThe plant&rsquo;s extensive production capabilities include grape harvesting, juice storage, concentrator operations, and shipment to many domestic and international locations. &nbsp; &nbsp;&nbsp;</p>\r\n\r\n<p><strong>Certification:</strong><br />\r\nGrandview, Washington Plant is GFSI Certified (SQF &ndash; Level II). &nbsp;Other certifications include Halal, Orthodox Union, Circle U, Triangle K, and Organic.</p>\r\n\r\n<p><strong>HACCP:</strong><br />\r\nFood safety of all products produced at Welch&rsquo;s facilities, for both internal and external customers, is our highest priority. &nbsp;Our HACCP System was developed using the principles identified in the National Advisory Committee on Microbiological Criteria for Foods (NACMCF) Hazard Analysis and Critical Control Point Principles and Application Guidelines (1997). &nbsp; New and emerging legislative/regulatory and customer requirements are incorporated into the HACCP program as needed with guidance from the Welch&rsquo;s Corporate HACCP Advisory Committee. The HACCP system is reviewed and validated annually by trained and competent personnel.&nbsp;</p>\r\n\r\n<p>&nbsp;</p>","Harvest","","","index,follow","2","1","1","1","6","01_09_00_09_09_14_000000Concord_grapes_on_vine.jpg","04_09_57_12_09_14_000000IMG_0442.png","","Harvest","1","Harvest","");
INSERT INTO child_pages VALUES("33","processing-plant","Processing Plant","<p><strong>Vineyard Care:</strong><br />\r\nQuality and care of our vineyards are controlled through the owners of Welch Foods, the National Grape Cooperative. &nbsp;The growers follow strict vineyard management practices through the Cooperative Sustainability Program to maximize yields and ensure a high-quality crop.</p>\r\n\r\n<p><strong>Harvest:</strong><br />\r\nGrapes are harvested by use of mechanical harvesters and are pressed&nbsp;within eight hours. &nbsp;The close proximity of our vineyards to our processing plants ensures grape quality is preserved from the vineyard to the plant. &nbsp;Strict standards are in place to ensure a consistent and high-quality crop from year to year.</p>\r\n\r\n<h2><strong>Processing Plant:</strong> &nbsp;<br />\r\nThe plant&rsquo;s extensive production capabilities include grape harvesting, juice storage, concentrator operations, and shipment to many domestic and international locations. &nbsp; &nbsp;&nbsp;</h2>\r\n\r\n<p><strong>Certification:</strong><br />\r\nGrandview, Washington Plant is GFSI Certified (SQF &ndash; Level II). &nbsp;Other certifications include Halal, Orthodox Union, Circle U, Triangle K, and Organic.</p>\r\n\r\n<p><strong>HACCP:</strong><br />\r\nFood safety of all products produced at Welch&rsquo;s facilities, for both internal and external customers, is our highest priority. &nbsp;Our HACCP System was developed using the principles identified in the National Advisory Committee on Microbiological Criteria for Foods (NACMCF) Hazard Analysis and Critical Control Point Principles and Application Guidelines (1997). &nbsp; New and emerging legislative/regulatory and customer requirements are incorporated into the HACCP program as needed with guidance from the Welch&rsquo;s Corporate HACCP Advisory Committee. The HACCP system is reviewed and validated annually by trained and competent personnel.&nbsp;</p>\r\n\r\n<p>&nbsp;</p>","Processing Plant","","","index,follow","3","1","1","1","6","01_09_20_09_09_14_000000Concord_grapes_on_vine.jpg","04_09_14_12_09_14_000000IMG_0442.png","","Processing Plant","1","Processing Plant","");
INSERT INTO child_pages VALUES("34","certification","Certification","<p><strong>Vineyard Care:</strong><br />\r\nQuality and care of our vineyards are controlled through the owners of Welch Foods, the National Grape Cooperative. &nbsp;The growers follow strict vineyard management practices through the Cooperative Sustainability Program to maximize yields and ensure a high-quality crop.</p>\r\n\r\n<p><strong>Harvest:</strong><br />\r\nGrapes are harvested by use of mechanical harvesters and are pressed within eight hours. &nbsp;The close proximity of our vineyards to our processing plants ensures grape quality is preserved from the vineyard to the plant. &nbsp;Strict standards are in place to ensure a consistent and high-quality crop from year to year.</p>\r\n\r\n<p><strong>Processing Plant: &nbsp;</strong><br />\r\nThe plant&rsquo;s extensive production capabilities include grape harvesting, juice storage, concentrator operations, and shipment to many domestic and international locations. &nbsp; &nbsp;&nbsp;</p>\r\n\r\n<h2><strong>Certification:</strong><br />\r\nGrandview, Washington Plant is GFSI Certified (SQF &ndash; Level II). &nbsp;Other certifications may include Halal, Orthodox Union, Circle U, Triangle K or Organic on a case-by-case basis, as noted in corresponding product specifications.</h2>\r\n\r\n<p><strong>HACCP:</strong><br />\r\nFood safety of all products produced at Welch&rsquo;s facilities, for both internal and external customers, is our highest priority. &nbsp;Our HACCP System was developed using the principles identified in the National Advisory Committee on Microbiological Criteria for Foods (NACMCF) Hazard Analysis and Critical Control Point Principles and Application Guidelines (1997). &nbsp; New and emerging legislative/regulatory and customer requirements are incorporated into the HACCP program as needed with guidance from the Welch&rsquo;s Corporate HACCP Advisory Committee. The HACCP system is reviewed and validated annually by trained and competent personnel.&nbsp;</p>\r\n\r\n<p>&nbsp;</p>","Certification","","","index,follow","4","1","1","1","6","01_09_37_09_09_14_000000Concord_grapes_on_vine.jpg","04_09_27_12_09_14_000000IMG_0442.png","","Certification","1","Certification","");
INSERT INTO child_pages VALUES("35","haccp","HACCP","<p><strong>Vineyard Care:</strong><br />\r\nQuality and care of our vineyards are controlled through the owners of Welch Foods, the National Grape Cooperative. &nbsp;The growers follow strict vineyard management practices through the Cooperative Sustainability Program to maximize yields and ensure a high-quality crop.</p>\r\n\r\n<p><strong>Harvest:</strong><br />\r\nGrapes are harvested by use of mechanical harvesters and are pressed within eight hours. &nbsp;The close proximity of our vineyards to our processing plants ensures grape quality is preserved from the vineyard to the plant. &nbsp;Strict standards are in place to ensure a consistent and high-quality crop from year to year.</p>\r\n\r\n<p><strong>Processing Plant: &nbsp;</strong><br />\r\nThe plant&rsquo;s extensive production capabilities include grape harvesting, juice storage, concentrator operations, and shipment to many domestic and international locations. &nbsp; &nbsp;&nbsp;</p>\r\n\r\n<p><strong>Certification:</strong><br />\r\nGrandview, Washington Plant is GFSI Certified (SQF &ndash; Level II). &nbsp;Other certifications include Halal, Orthodox Union, Circle U, Triangle K, and Organic.</p>\r\n\r\n<h2><strong>HACCP:</strong><br />\r\nFood safety of all products produced at Welch&rsquo;s facilities, for both internal and external customers, is our highest priority. &nbsp;Our HACCP System was developed using the principles identified in the National Advisory Committee on Microbiological Criteria for Foods (NACMCF) Hazard Analysis and Critical Control Point Principles and Application Guidelines (1997). &nbsp; New and emerging legislative/regulatory and customer requirements are incorporated into the HACCP program as needed with guidance from the Welch&rsquo;s Corporate HACCP Advisory Committee. The HACCP system is reviewed and validated annually by trained and competent personnel.&nbsp;</h2>\r\n\r\n<p>&nbsp;</p>","HACCP","","","index,follow","5","1","1","1","6","04_09_46_12_09_14_000000Niagara_grapes_on_vine (1).jpg","04_09_44_12_09_14_000000IMG_0442.png","","HACCP","1","HACCP","");
INSERT INTO child_pages VALUES("36","grape-center-of-excellence","Grape Center of Excellence","<p><span style=\\\"font-family:arial,sans-serif; font-size:10pt\\\">Welch&rsquo;s Global Ingredients has a fully trained and supportive R&amp;D and Product Development staff in grape juice, beverage and food applications.&nbsp; Providing leadership in Grape science, Grape Chemistry, Formulation, Process Technology, Research, Testing, Innovation, Analytical Methods and New Product Development</span></p>","Grape Center of Excellence","","","index,follow","1","1","1","1","7","01_09_31_09_09_14_000000Concord_grapes_on_vine.jpg","11_09_47_22_09_14_000000grape-center.png","","Grape Center of Excellence","1","Grape Center of Excellence","");



DROP TABLE IF EXISTS tbl_admin;

CREATE TABLE `tbl_admin` (
  `IAdminID` int(11) NOT NULL AUTO_INCREMENT,
  `sUserName` varchar(255) NOT NULL,
  `bLoginPassword` varchar(255) NOT NULL,
  `role` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`IAdminID`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

INSERT INTO tbl_admin VALUES("1","admin","202cb962ac59075b964b07152d234b70","1");
INSERT INTO tbl_admin VALUES("5","test@gmail.com","202cb962ac59075b964b07152d234b70","0");
INSERT INTO tbl_admin VALUES("6","test@yahoo.com","202cb962ac59075b964b07152d234b70","0");



DROP TABLE IF EXISTS tbl_banners;

CREATE TABLE `tbl_banners` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image` varchar(255) NOT NULL,
  `ordr` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=latin1;

INSERT INTO tbl_banners VALUES("9","09_09_2014_04_09_02_fullimage1.jpg","1");
INSERT INTO tbl_banners VALUES("10","09_09_2014_04_09_52_fullimage2.jpg","2");
INSERT INTO tbl_banners VALUES("12","23_09_2014_01_09_02_bann.jpg","4");
INSERT INTO tbl_banners VALUES("14","15_09_2014_10_09_32_slider_33.jpg","3");



DROP TABLE IF EXISTS tbl_companyprofile;

CREATE TABLE `tbl_companyprofile` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `slogan` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `city` varchar(255) NOT NULL,
  `state` varchar(255) NOT NULL,
  `country` varchar(255) NOT NULL,
  `copy` varchar(1000) NOT NULL,
  `logo` varchar(255) NOT NULL,
  `favicon` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO tbl_companyprofile VALUES("1","Welch","Global Ingredients Group","","(1) 456 6717","info@.welchsgi.com","121415 Xyz, Abc 0000","City","CA 98197","Country","© Welch\\\'s 2014. All Rights Reserved","11_09_2014_04_09_19_logo.png","04_09_2014_06_09_44_favicon.ico");



DROP TABLE IF EXISTS tbl_contacts;

CREATE TABLE `tbl_contacts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `company` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `city` varchar(255) NOT NULL,
  `state` varchar(255) NOT NULL,
  `zip` varchar(255) NOT NULL,
  `country` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `product` varchar(255) NOT NULL,
  `application` varchar(255) NOT NULL,
  `msg` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS tbl_documents;

CREATE TABLE `tbl_documents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(500) NOT NULL,
  `docu` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS tbl_events;

CREATE TABLE `tbl_events` (
  `id` int(4) NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `page_title` text,
  `desc` longtext,
  `name` text,
  `description` varchar(1024) DEFAULT NULL,
  `keywords` varchar(1024) DEFAULT NULL,
  `robots` varchar(255) NOT NULL DEFAULT 'index,follow',
  `header_image` varchar(255) NOT NULL,
  `top_header_image` varchar(255) NOT NULL,
  `header_image_text` varchar(255) NOT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=latin1;

INSERT INTO tbl_events VALUES("15","fi-asia-jakarta","FI ASIA, JAKARTA, INDONESIA,","<p><strong>Join us in Jakarta for Fi Asia 2014</strong></p>\r\n\r\n<p><strong>Let our success be yours</strong> Fi Asia has grown 25% annually over the last 4 years and promises to maintain its exclusive position as the most important route to the entire Southeast-Asia food and beverage industry.</p>\r\n\r\n<p><a href=\\\"http://www.figlobal.com/asia-indonesia/home/\\\" target=\\\"_blank\\\">Read More</a></p>","FI ASIA, JAKARTA, INDONESIA, OCT 15-17, 2014, JAKARTA INTERNATIONAL EXPO, BOOTH #T14","","","index,follow","","","FI ASIA, JAKARTA, INDONESIA,","http://www.figlobal.com/asia-indonesia/home/");
INSERT INTO tbl_events VALUES("16","sial-paris","SIAL, PARIS, FRANCE, OCT 20-24, 2014, EXHIBITING IN WILD FLAVORS STAND","<p><strong>&quot;SIAL, the world&#39;s largest food innovation marketplace&quot;</strong></p>\r\n\r\n<p><a href=\\\"http://www.sialparis.com\\\" target=\\\"_blank\\\">Read More</a></p>\r\n\r\n<p>&nbsp;</p>","SIAL, PARIS, FRANCE, OCT 20-24, 2014, EXHIBITING IN WILD FLAVORS STAND at Hall 5B, Booth G 031","","","index,follow","12_09_39_10_09_14band-3.jpg","07_09_57_09_09_14inner-header.jpg","FI ASIA, JAKARTA, INDONESIA,","http://www.sialparis.com/");
INSERT INTO tbl_events VALUES("17","gulfood","GULFOOD, DUBAI, UAE, NOV 9-11, 2014, EXHIBITING IN WILD FLAVORS STAND","<p>The BIGGEST food and beverage process industry event for the Middle East, Africa and Indian Sub-Continent. FREE to attend for all our visitors.</p>\r\n\r\n<p>If you are looking to buy ingredients, find new equipment or source better logistics solutions, Gulfood Manufacturing is the show to visit this November.</p>\r\n\r\n<p><a href=\\\"http://www.gulfoodmanufacturing.com\\\" target=\\\"_blank\\\">Read More</a></p>","GULFOOD, DUBAI, UAE, NOV 9-11, 2014, EXHIBITING IN WILD FLAVORS STAND at Hall Sheikh Saeed 3, Booth S3-C34","","","index,follow","12_09_49_10_09_14band-1.jpg","12_09_49_10_09_14inner-header.jpg","EXHIBITING IN WILD FLAVORS STAND","http://www.gulfoodmanufacturing.com/");



DROP TABLE IF EXISTS tbl_gallery;

CREATE TABLE `tbl_gallery` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(500) NOT NULL,
  `pid` int(11) NOT NULL,
  `c_id` int(11) NOT NULL,
  `image` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;

INSERT INTO tbl_gallery VALUES("8","Juice / Beverages / Smoothies","9","22","02_09_41_10_09_1412_09_30_09_09_14Welchs-Smoothie.png");
INSERT INTO tbl_gallery VALUES("9","Jams, Jellies & Marmalades","9","23","05_09_53_09_09_14imge2.png");
INSERT INTO tbl_gallery VALUES("10","Dairy & Ice Cream","9","24","06_09_38_12_09_14Welchs-Purple_Cow-redo_LR.jpg");
INSERT INTO tbl_gallery VALUES("11","Frozen Desserts/Novelties","9","25","09_09_17_11_09_1405_09_09_09_09_14image3.png");
INSERT INTO tbl_gallery VALUES("12","Confectionary","9","26","05_09_37_09_09_14image5.png");
INSERT INTO tbl_gallery VALUES("13","Sauces/Dips","9","27","05_09_52_09_09_14image6.png");
INSERT INTO tbl_gallery VALUES("14","Snacks/Bakery","9","28","05_09_05_09_09_14image7.png");
INSERT INTO tbl_gallery VALUES("15","Alcoholic Beverages / Mixers / Syrups","9","29","05_09_38_09_09_14image8.jpg");



DROP TABLE IF EXISTS tbl_hometxt;

CREATE TABLE `tbl_hometxt` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` text CHARACTER SET utf8 NOT NULL,
  `h_image` varchar(255) NOT NULL,
  `h_image_t` varchar(255) NOT NULL,
  `s_t` varchar(255) NOT NULL,
  `video` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO tbl_hometxt VALUES("1","<p>At the heart of Welch&#39;s are 1,000 family farmers who make everything possible. Each and every farmer is a grape growing expert, who takes great pride in the vineyards they&#39;ve cultivated for generations. It&#39;s our farmer&#39;s dedication to growing the best Concord and Niagara grapes that&#39;s allowed us to provide families with the delicious juices, jams and jellies they&#39;ve loved for years</p>\r\n\r\n<p>Our story began over 140 years ago, when Thomas Bramwell Welch decided to serve grape juice instead of wine at his church. Welch was the first to pasteurize bottled fruit juice using Concord grapes, paving the way for a future industry. After its debut at the Chicago World&#39;s Fair in 1893, Welch&#39;s Grape Juice went on to become the national family favorite it is today.</p>","12_09_01_04_09_14Welchs-Applications.jpg","Concord Grape","A Whole Bunch of Good","<iframe width=\\\"100%\\\" height=\\\"230\\\" frameborder=\\\"0\\\" scrolling=\\\"no\\\" allowtransparency=\\\"true\\\" id=\\\"\\\" src=\\\"http://money.cnn.com/.element/ssi/video/6.0/players/embed.player.html?videoid=video/smallbusiness/2012/10/09/smb-hwgs-welchs.cnnmoney\\\">&amp;amp;lt;br /&amp;amp;gt; &amp;amp;gt;</iframe>");



DROP TABLE IF EXISTS tbl_index;

CREATE TABLE `tbl_index` (
  `id` int(4) NOT NULL AUTO_INCREMENT,
  `page_title` text,
  `description` varchar(1024) DEFAULT NULL,
  `keywords` varchar(1024) DEFAULT NULL,
  `robots` varchar(255) NOT NULL DEFAULT 'index,follow',
  `google_analytics` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO tbl_index VALUES("1","Welch\\\'s Global Ingredients | Buy Juice & Fruit Products | juices, jams, jellies & spreads","Welch\\\'s Global Ingredients | Buy Juice & Fruit Products | juices, jams, jellies & spreads","Welch\\\'s Global Ingredients | Buy Juice & Fruit Products | juices, jams, jellies & spreads","index,follow","");



DROP TABLE IF EXISTS tbl_news;

CREATE TABLE `tbl_news` (
  `id` int(4) NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `page_title` text,
  `desc` longtext,
  `name` text,
  `description` varchar(1024) DEFAULT NULL,
  `keywords` varchar(1024) DEFAULT NULL,
  `robots` varchar(255) NOT NULL DEFAULT 'index,follow',
  `header_image` varchar(255) NOT NULL,
  `top_header_image` varchar(255) NOT NULL,
  `header_image_text` varchar(255) NOT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=latin1;

INSERT INTO tbl_news VALUES("15","new","","","News 3","","","index,follow","","","","http://welch.com");
INSERT INTO tbl_news VALUES("16","news","","","News 2","","","index,follow","","","","");
INSERT INTO tbl_news VALUES("17","the-new","","","News1","","","index,follow","","","","");



DROP TABLE IF EXISTS tbl_pages;

CREATE TABLE `tbl_pages` (
  `pid` int(4) NOT NULL AUTO_INCREMENT,
  `page` varchar(255) CHARACTER SET latin1 NOT NULL,
  `page_title` text CHARACTER SET latin1,
  `desc` longtext CHARACTER SET latin1,
  `title` text CHARACTER SET latin1,
  `description` varchar(1024) CHARACTER SET latin1 DEFAULT NULL,
  `keywords` varchar(1024) CHARACTER SET latin1 DEFAULT NULL,
  `robots` varchar(255) CHARACTER SET latin1 NOT NULL DEFAULT 'index,follow',
  `ordr` int(11) NOT NULL DEFAULT '0',
  `t_nav` tinyint(1) NOT NULL DEFAULT '1',
  `show_in_footer` int(1) NOT NULL DEFAULT '1',
  `IStatus` int(1) NOT NULL DEFAULT '1',
  `header_image` varchar(255) CHARACTER SET latin1 NOT NULL,
  `top_header_image` varchar(255) CHARACTER SET latin1 NOT NULL,
  `google_analytics` text CHARACTER SET latin1 NOT NULL,
  `header_image_text` varchar(255) CHARACTER SET latin1 NOT NULL,
  `have_child` tinyint(1) NOT NULL DEFAULT '0',
  `show_in_leftnav` tinyint(1) NOT NULL DEFAULT '1',
  `nav_title` varchar(255) CHARACTER SET latin1 NOT NULL,
  `url` text NOT NULL,
  `y_mail` varchar(255) NOT NULL,
  PRIMARY KEY (`pid`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

INSERT INTO tbl_pages VALUES("1","about-us","About Us","<p>At the heart of Welch&#39;s are 1,000 family farmers who make everything possible. Each and every farmer is a grape growing expert, who takes great pride in the vineyards they&#39;ve cultivated for generations. It&#39;s our farmer&#39;s dedication to growing the best Concord and Niagara grapes that&#39;s allowed us to provide families with the delicious juices, jams and jellies they&#39;ve loved for years</p>\r\n\r\n<p>Our story began over 140 years ago, when Thomas Bramwell Welch decided to serve grape juice instead of wine at his church. Welch was the first to pasteurize bottled fruit juice using Concord grapes, paving the way for a future industry. After its debut at the Chicago World&#39;s Fair in 1893, Welch&#39;s Grape Juice went on to become the national family favorite it is today.</p>","About Us","AboutUs","About welch","index,follow","1","1","1","1","11_09_56_08_09_14Concord_grapes_on_vine.jpg","10_09_05_10_09_1411_09_10_08_09_14About Welchs.jpg","","About Us","1","1","About Us","","");
INSERT INTO tbl_pages VALUES("2","concord-niagara","Concord Niagara","","Concord/Niagara","","","index,follow","2","1","1","1","11_09_50_08_09_14Concord_grapes_on_vine.jpg","04_09_26_12_09_14Niagra.png","","Concord/Niagara","1","1","Concord/Niagara","","");
INSERT INTO tbl_pages VALUES("3","products","Products","<p><img alt=\\\"\\\" src=\\\"/Robinson/ckfinder/userfiles/images/products/Products.png\\\" style=\\\"width:100%\\\" />*Shaded blue column connotes product code(s) specs for specific product.</p>","Products","","","index,follow","3","1","1","1","01_09_44_09_09_14Concord_grapes_on_vine.jpg","10_09_46_10_09_14A-Grapes.png","","Only the very best Ingredients","1","0","Products","","");
INSERT INTO tbl_pages VALUES("4","product-faq-s","Product FAQ\\\'s","<p><strong>Shelf Life</strong>: 2 years</p>\r\n\r\n<p><strong>Storage of drums:</strong> Less than 0&deg;F or -18&deg;C</p>\r\n\r\n<p><strong>Packaging</strong>: Tankers (4300 gallons at 68 Brix or 16.277 liters), drums (50 gallons or 189.27 liters or 52 gallons or 196.84 liters) and pails (5 gallons or 18.93 liters)</p>\r\n\r\n<p><strong>Shipping Temperature</strong>: &nbsp;depends on shipping time. &nbsp;Frozen drums can be shipped in a dry reefer if less than 20 days from frozen storage warehouse to frozen storage warehouse. &nbsp;A natural thawing process will begin bu the product will remain frozen until arrival. &nbsp;Every effort should be made to keep the container cool such as avoiding direct sunlight.</p>\r\n\r\n<p><strong>Continuance of Supply: </strong>Welch&rsquo;s is the marketing arm of National Grape Cooperative, the leading Concord and Niagara grape vineyard growers in the U.S. with over 40,000 acres (16000 hectares) under vine and over 60% of the total Concord market. &nbsp;We can indeed assure sufficient supply.</p>\r\n\r\n<p><strong>Long-Term Pricing</strong>: Welch&rsquo;s makes every effort to guarantee long-term pricing.</p>\r\n\r\n<p><strong>Lead Times</strong>: Welch&rsquo;s requires 4-6 weeks average lead time to process an order.</p>\r\n\r\n<p><strong>Ship Time: </strong>Will vary depending on final destination. &nbsp;Average ship time is 3 weeks to Asia and 5 weeks to Europe from our Grandview, Washington plant.</p>","Product FAQ\\\'s","","","index,follow","4","1","1","1","01_09_40_09_09_14Concord_grapes_on_vine.jpg","10_09_13_10_09_14A-Grapes.png","","Packaging","1","1","Product FAQ\\\'s","","");
INSERT INTO tbl_pages VALUES("5","privacy-policy","Privacy Policy","<h2 style=\\\"box-sizing: border-box; font-size: 18px; margin: 0.83em 0px 8px; color: rgb(34, 31, 115); font-family: AvenirLTStd-Medium, Arial, Helvetica, sans-serif; line-height: 22px; border-bottom-width: 2px; border-bottom-style: solid; border-bottom-color: rgb(34, 31, 115);\\\">Our Commitment to Privacy</h2>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">Your privacy is important to us. To better protect your privacy we provide this policy to explain our information practices and the choices you can make about the way your information is collected and used on the www.welchs.com website. To make this policy easy to find, we make it available on our homepage and at every point where personally identifiable information may be requested.</p>\r\n\r\n<h2 style=\\\"box-sizing: border-box; font-size: 18px; margin: 0.83em 0px 8px; color: rgb(34, 31, 115); font-family: AvenirLTStd-Medium, Arial, Helvetica, sans-serif; line-height: 22px; border-bottom-width: 2px; border-bottom-style: solid; border-bottom-color: rgb(34, 31, 115);\\\">The Information We Collect</h2>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">Welch&#39;s will not collect any personally-identifiable information about you through our website unless you provide it to us voluntarily. This policy applies to all information collected or submitted on the Welch&#39;s website. On some pages, you can make requests, register to receive materials or enter promotions. The types of personal information collected include: name, address, e-mail address, phone number, gender, permission to contact the person completing the registration, number of children in the household, if the registrant is a Welch&#39;s consumer or not, and general questions relating to product preferences or areas of interest on our website. We also collect the age of anyone who attempts to register this personally identifiable information on our site. We do this in order to fully comply with the rules and regulations under the Children&#39;s Online Privacy Protection Act to obtain parental consent for our visitors under the age of 13.</p>\r\n\r\n<h2 style=\\\"box-sizing: border-box; font-size: 18px; margin: 0.83em 0px 8px; color: rgb(34, 31, 115); font-family: AvenirLTStd-Medium, Arial, Helvetica, sans-serif; line-height: 22px; border-bottom-width: 2px; border-bottom-style: solid; border-bottom-color: rgb(34, 31, 115);\\\">The Way We Use Information</h2>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">In order to participate in any promotional activities (such as a sweepstakes) or request a coupon from Welch&#39;s or partake in certain other activities offered only within a members-only section within www.welchs.com, called &quot;My Grapelink&quot;, a complete and approved registration record is required. Any area outside of the &quot;My Grapelink&quot; area of welchs.com is open to all visitors of the website.</p>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">We will use the information collected on the Welch&#39;s website to (a) allow registered users to access the &quot;My Grapelink&quot; section; (b) communicate with those registered users who have authorized Welch&#39;s to contact them to provide updates about our products and promotions; (c) develop new marketing and product ideas; and (d) notify sweepstakes winners of what they have won.</p>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">Information provided by registration or through a survey may be used internally by us to improve the design of our website, to increase our understanding of our consumers and their product preferences, and for other marketing and promotional purposes. For example, we may study responses relating to the perceptions or flavor preferences of our products by consumers. These learnings may then be used to shape future marketing decisions by us.</p>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">Welch&#39;s also collects aggregate, non-personally-identifiable information on users by recording the IP address from the computers of visitors to welchs.com. An IP address is a number that is assigned to your computer when you surf the Web. Web servers, or the computers that provide the web pages to your computer for you to view, automatically identify your computer by its IP address. When you use your computer to request to view a page from a server, your IP address is logged by that server. Welch&#39;s does not link IP addresses to anything personally identifiable. Your visit to welchs.com will be logged; however, you will remain anonymous to us. We track the number of people that view each page of our website to better understand which features are most popular and best meet the needs of our visitors.</p>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">Welch&#39;s will not sell or rent your personally identifiable information to anyone. Welch&#39;s will send personally identifiable information about you to other companies or people when:</p>\r\n\r\n<ul style=\\\"box-sizing: border-box; margin: 0px 0px 3px; padding-right: 0px; padding-left: 0px; list-style: none; line-height: 17px; color: rgb(0, 0, 0); font-family: Arial, Helvetica, sans-serif;\\\">\r\n	<li style=\\\"box-sizing: border-box; color: rgb(34, 31, 115); list-style-type: disc; margin-left: 20px; margin-bottom: 10px;\\\">We have your consent to do so.</li>\r\n	<li style=\\\"box-sizing: border-box; color: rgb(34, 31, 115); list-style-type: disc; margin-left: 20px; margin-bottom: 10px;\\\">We need to share the information in order to provide the product or service you have requested.</li>\r\n	<li style=\\\"box-sizing: border-box; color: rgb(34, 31, 115); list-style-type: disc; margin-left: 20px; margin-bottom: 10px;\\\">We need to send the information to companies who work on behalf of Welch&#39;s to provide a product or service for you on our behalf. Examples include hosting and helping to run this Web site, delivering packages, sending postal mail and e-mail, removing repetitive information from customer lists, analyzing data, providing marketing assistance, and providing customer service. Unless we tell you differently, these companies do not have any right to use the personally identifiable information we provide to them beyond what is necessary to assist us, unless they have your consent to do so.</li>\r\n	<li style=\\\"box-sizing: border-box; color: rgb(34, 31, 115); list-style-type: disc; margin-left: 20px; margin-bottom: 10px;\\\">We need to respond to valid legal process. This includes a search warrant, subpoena, or court order, and any other instance when we believe we are required to do so by law. We may also make disclosures to protect your safety during emergencies if your physical safety is believed to be at risk, to protect the security or integrity of the Welch&#39;s Web site, or to take precautions against liability. We will take reasonable steps to limit the scope of these disclosures.</li>\r\n</ul>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">Other than as set out above, you will receive notice when information about you might go to third parties, and you will have an opportunity to choose not to share the information (opt-out).</p>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">Welch&#39;s may share aggregated, non-personally identifiable information about our users with other companies for marketing and promotional purposes.</p>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">If you do not register with welchs.com, but only provide us with your e-mail address in connection with contacting Welch&#39;s by e-mail, we will use your e-mail addresses to answer your e-mail. If you authorize Welch&#39;s to contact you, we may use your e-mail address to send you notice of values and promotions, such as coupon offerings and sweepstakes.</p>\r\n\r\n<h2 style=\\\"box-sizing: border-box; font-size: 18px; margin: 0.83em 0px 8px; color: rgb(34, 31, 115); font-family: AvenirLTStd-Medium, Arial, Helvetica, sans-serif; line-height: 22px; border-bottom-width: 2px; border-bottom-style: solid; border-bottom-color: rgb(34, 31, 115);\\\">Use of Cookies</h2>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">Welch&#39;s website uses cookies to customize the visits of consumers to the &quot;My Grapelink&quot; section within the welchs.com website. Cookies are messages given to a Web browser (a software program that resides on your computer and allows you to surf the Web) by a Web server when the Web browser requests to &quot;see&quot; pages on a Web site. The browser stores the message from the server and sends it back to the server each time the browser requests to see a page from that server.</p>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">The use of cookies is an industry standard and you will find them at most websites. Most browsers are set to accept cookies. You always have the option to set the browser on your computer to refuse cookies. The main purpose of cookies is to identify users and prepare customized web pages for them to view. For example, you may receive a welcome message that includes your name instead of a generic welcome message. A cookie will also retrieve the information that was voluntarily provided by you to help improve your user experience or speed up your navigation on a website. You will need to enable the use of cookies to register on and navigate through the &quot;My Grapelink&quot; pages of welchs.com. You will not need to enable cookies to use any other part of welchs.com that does not require a personal registration record.</p>\r\n\r\n<h2 style=\\\"box-sizing: border-box; font-size: 18px; margin: 0.83em 0px 8px; color: rgb(34, 31, 115); font-family: AvenirLTStd-Medium, Arial, Helvetica, sans-serif; line-height: 22px; border-bottom-width: 2px; border-bottom-style: solid; border-bottom-color: rgb(34, 31, 115);\\\">Our Commitment to Data Security</h2>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">In an endeavor to prevent unauthorized access, maintain data accuracy, and ensure the correct use of information, we have put in place appropriate physical and electronic procedures to safeguard and secure personal information we collect. We cannot guarantee the security of any information that you disclose online, and you do so at your own risk.</p>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">Welch&#39;s incorporates security measures to protect our data from unauthorized use. Firewalls are utilized to protect our servers and network from unauthorized users accessing and tampering with files and other information that we store.</p>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">Although we take the utmost care to protect your information, we cannot ensure the security of any information that you disclose online and transmit to us.</p>\r\n\r\n<h2 style=\\\"box-sizing: border-box; font-size: 18px; margin: 0.83em 0px 8px; color: rgb(34, 31, 115); font-family: AvenirLTStd-Medium, Arial, Helvetica, sans-serif; line-height: 22px; border-bottom-width: 2px; border-bottom-style: solid; border-bottom-color: rgb(34, 31, 115);\\\">How You Can Access or Correct Your Information</h2>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">After registering with welchs.com, you will always have the option of editing the information you provided in your registration. To do this, visit the &quot;My Grapelink&quot; section of welchs.com, log in using your e-mail and password, and click on the &quot;My Account&quot; link on the &quot;My Grapelink&quot; page. You then may update your personal information or change your password. If you forget your password, go to the login page (&quot;Welcome to Welch&#39;s Grapelink&quot;) of &quot;My Grapelink&quot;, enter your e-mail address and click on the &quot;Retrieve my Password&quot; link. If you would like to unsubscribe from our database, please&nbsp;<a href=\\\"mailto:support@welchs.com\\\" style=\\\"box-sizing: border-box; color: rgb(135, 108, 220);\\\">click here</a>&nbsp;and type &quot;unsubscribe&quot; in your e-mail message.</p>\r\n\r\n<h2 style=\\\"box-sizing: border-box; font-size: 18px; margin: 0.83em 0px 8px; color: rgb(34, 31, 115); font-family: AvenirLTStd-Medium, Arial, Helvetica, sans-serif; line-height: 22px; border-bottom-width: 2px; border-bottom-style: solid; border-bottom-color: rgb(34, 31, 115);\\\"><a name=\\\"child\\\" style=\\\"box-sizing: border-box; padding: 0px; color: rgb(34, 31, 115); background-image: none; background-position: initial; background-repeat: initial;\\\"></a>Our Commitment to Children&#39;s Privacy</h2>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">Welch&#39;s is committed to doing its part to protect the privacy of young children. Accordingly, and consistent with the Federal Children&#39;s Online Privacy Protection Act of 1998 (COPPA), Welch&#39;s will never knowingly collect personally identifiable information from anyone under the age of 13 without first obtaining verifiable consent from the child&#39;s parent or legal guardian.</p>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">The following sections of our Privacy Policy explain how Welch&#39;s collects and protects children&#39;s personal information, by describing:</p>\r\n\r\n<ul style=\\\"box-sizing: border-box; margin: 0px 0px 3px; padding-right: 0px; padding-left: 0px; list-style: none; line-height: 17px; color: rgb(0, 0, 0); font-family: Arial, Helvetica, sans-serif;\\\">\r\n	<li style=\\\"box-sizing: border-box; color: rgb(34, 31, 115); list-style-type: disc; margin-left: 20px; margin-bottom: 10px;\\\">The personal information we collect from children under the age of 13 when they register on Welch&#39;s website and why we collect this information;</li>\r\n	<li style=\\\"box-sizing: border-box; color: rgb(34, 31, 115); list-style-type: disc; margin-left: 20px; margin-bottom: 10px;\\\">How we may use the information we collect from children under the age of 13;</li>\r\n	<li style=\\\"box-sizing: border-box; color: rgb(34, 31, 115); list-style-type: disc; margin-left: 20px; margin-bottom: 10px;\\\">How a parent may give us permission to obtain registration information from a child who is under the age of 13;</li>\r\n	<li style=\\\"box-sizing: border-box; color: rgb(34, 31, 115); list-style-type: disc; margin-left: 20px; margin-bottom: 10px;\\\">How a parent may edit or delete the information submitted to us from a child who is under the age of 13;</li>\r\n	<li style=\\\"box-sizing: border-box; color: rgb(34, 31, 115); list-style-type: disc; margin-left: 20px; margin-bottom: 10px;\\\">Who we may share this information with;</li>\r\n	<li style=\\\"box-sizing: border-box; color: rgb(34, 31, 115); list-style-type: disc; margin-left: 20px; margin-bottom: 10px;\\\">Whether or not the information we request is necessary to register or participate in an activity on the Welch&#39;s website.</li>\r\n</ul>\r\n\r\n<h3 style=\\\"box-sizing: border-box; font-size: 16px; margin: 1em 0px 0px; color: rgb(34, 31, 115); font-family: AvenirLTStd-Medium, Arial, Helvetica, sans-serif; line-height: 19px;\\\">1.&nbsp;The Information We Collect from Children Under 13</h3>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">Welch&#39;s collects personal information from children under 13 so that they may participate as registered members of welchs.com and have access to the &quot;My Grapelink&quot; section of the Welch&#39;s website. &quot;My Grapelink&quot; allows registered users to participate in promotional activities such as contests and sweepstakes or request a coupon from Welch&#39;s.</p>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">We request the following information in order to register on Welch&#39;s website:</p>\r\n\r\n<ul style=\\\"box-sizing: border-box; margin: 0px 0px 3px; padding-right: 0px; padding-left: 0px; list-style: none; line-height: 17px; color: rgb(0, 0, 0); font-family: Arial, Helvetica, sans-serif;\\\">\r\n	<li style=\\\"box-sizing: border-box; color: rgb(34, 31, 115); list-style-type: disc; margin-left: 20px; margin-bottom: 10px;\\\">E-mail address</li>\r\n	<li style=\\\"box-sizing: border-box; color: rgb(34, 31, 115); list-style-type: disc; margin-left: 20px; margin-bottom: 10px;\\\">Password (selected by the child)</li>\r\n	<li style=\\\"box-sizing: border-box; color: rgb(34, 31, 115); list-style-type: disc; margin-left: 20px; margin-bottom: 10px;\\\">Actual Name</li>\r\n	<li style=\\\"box-sizing: border-box; color: rgb(34, 31, 115); list-style-type: disc; margin-left: 20px; margin-bottom: 10px;\\\">Address, including city, state and zip code</li>\r\n	<li style=\\\"box-sizing: border-box; color: rgb(34, 31, 115); list-style-type: disc; margin-left: 20px; margin-bottom: 10px;\\\">Phone Number</li>\r\n	<li style=\\\"box-sizing: border-box; color: rgb(34, 31, 115); list-style-type: disc; margin-left: 20px; margin-bottom: 10px;\\\">Gender</li>\r\n	<li style=\\\"box-sizing: border-box; color: rgb(34, 31, 115); list-style-type: disc; margin-left: 20px; margin-bottom: 10px;\\\">Age (by range, not by specific date of birth)</li>\r\n	<li style=\\\"box-sizing: border-box; color: rgb(34, 31, 115); list-style-type: disc; margin-left: 20px; margin-bottom: 10px;\\\">Permission to contact the person completing the registration to provide future announcements of values and promotions. (A grant of such permission to contact is not a prerequisite to participation in the &quot;My Grapelink&quot; section.)</li>\r\n	<li style=\\\"box-sizing: border-box; color: rgb(34, 31, 115); list-style-type: disc; margin-left: 20px; margin-bottom: 10px;\\\">Number of children in the household (optional)</li>\r\n	<li style=\\\"box-sizing: border-box; color: rgb(34, 31, 115); list-style-type: disc; margin-left: 20px; margin-bottom: 10px;\\\">If the registrant is a Welch&#39;s consumer or not (optional)</li>\r\n	<li style=\\\"box-sizing: border-box; color: rgb(34, 31, 115); list-style-type: disc; margin-left: 20px; margin-bottom: 10px;\\\">General questions relating to product preferences or areas of interest on our website (optional)</li>\r\n</ul>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">If a registrant selects the &quot;under 13&quot; age range in that field, we will not use any information provided by that child unless and until we obtain parental consent to do so. We will request that the child provide us with their parent&#39;s or legal guardian&#39;s e-mail address, mailing address and phone number so we can request consent to retain the child&#39;s information. Until parental consent is received, for a child under 13, we will not use this information in any way. If Welch&#39;s does not receive verifiable parental consent within seven days of the child&#39;s attempt to register with welchs.com, we will permanently delete the child&#39;s personal information.</p>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">Welch&#39;s will not ask a child under age 13 to provide financially sensitive information such as credit card numbers.</p>\r\n\r\n<h3 style=\\\"box-sizing: border-box; font-size: 16px; margin: 1em 0px 0px; color: rgb(34, 31, 115); font-family: AvenirLTStd-Medium, Arial, Helvetica, sans-serif; line-height: 19px;\\\">2.&nbsp;How We May Use Information We Collect From Children Under Age 13</h3>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">We will use the information collected on the Welch&#39;s website to (a) allow registered users under 13 access to a members-only section within www.welchs.com, called &quot;My Grapelink&quot; and (b) communicate with our under 13 registered visitors via permission-based email messages, to provide updates about our products and promotions.</p>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">Unless the parent chooses to register as well with welchs.com, we will not use the parent&#39;s or guardian&#39;s e-mail address or mailing address for any purpose other than to communicate with the parent or guardian in order to obtain permission for their child to register and participate on the Welch&#39;s website. After the parent has provided consent for us to retain their child&#39;s information, we will keep the parent&#39;s information provided by the child on file to show that we have complied with our privacy protection policy, to send future requests for consent if necessary, and to ensure that only the child&#39;s parent can review the child&#39;s personal information. The parent will have an option to create their own registration record with us when they access their child&#39;s record to review, approve or delete it.</p>\r\n\r\n<h3 style=\\\"box-sizing: border-box; font-size: 16px; margin: 1em 0px 0px; color: rgb(34, 31, 115); font-family: AvenirLTStd-Medium, Arial, Helvetica, sans-serif; line-height: 19px;\\\">3.&nbsp;Permission Process - How a Parent May Give Consent to Collection of Information from a Child under Age 13</h3>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">As outlined above, all children under the age of 13 will be required to provide us with the name, mailing address, e-mail address, and phone number of their parent or legal guardian in order to seek to become officially registered on the Welch&#39;s website. Once the child has provided this information, we will send an e-mail to the parent explaining that the child is attempting to register on the site and explaining how the parent can provide consent or deny consent for the child&#39;s registration. This e-mail to the parent will provide the parent with a specific link, to access the child&#39;s information. Once the parent accesses the child&#39;s record, the parent will have the option to:</p>\r\n\r\n<ul style=\\\"box-sizing: border-box; margin: 0px 0px 3px; padding-right: 0px; padding-left: 0px; list-style: none; line-height: 17px; color: rgb(0, 0, 0); font-family: Arial, Helvetica, sans-serif;\\\">\r\n	<li style=\\\"box-sizing: border-box; color: rgb(34, 31, 115); list-style-type: disc; margin-left: 20px; margin-bottom: 10px;\\\">Provide consent to retaining and using the child&#39;s information</li>\r\n	<li style=\\\"box-sizing: border-box; color: rgb(34, 31, 115); list-style-type: disc; margin-left: 20px; margin-bottom: 10px;\\\">Edit the child&#39;s information and provide consent to retaining and using it</li>\r\n	<li style=\\\"box-sizing: border-box; color: rgb(34, 31, 115); list-style-type: disc; margin-left: 20px; margin-bottom: 10px;\\\">Deny consent and delete the child&#39;s information</li>\r\n</ul>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">If a parent or guardian provides consent to collection and use of the child&#39;s information, an e-mail is sent to the parent, with a copy to the child, to confirm that Welch&#39;s has received parental consent and that the child now may participate as an officially registered member of the site. The child&#39;s registration to the Welch&#39;s website will be activated once the parent visits the website provides consent for Welch&#39;s to retain and use the child&#39;s information as outlined above.</p>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">In the event that the parent or guardian of the child who wishes to register to create a My Grapelink account does not have an e-mail account and does not have access to the Internet to create an e-mail account, an alternative means of parental consent will be provided. The child who is registering has the option of clicking on a link, located next to the e-mail field on the Parent/Guardian Consent Request page of My Grapelink. Once clicked upon, this link will provide instruction to the child to enter the following e-mail address into the e-mail field of the Parent/Guardian Consent Request page: customerservice@welchs.com. After this e-mail is entered, the child will complete the remainder of the page with their parent or guardian&#39;s name, address and phone number. After the child submits the information by clicking on the submit button at the bottom of the page, their record will be forwarded to customerservice@welchs.com, an internal Welch&#39;s e-mail account, established to receive such requests. Upon receipt, the e-mail will be printed out and mailed to the parent of the child who wishes to register. The e-mail printout, and two copies of the printout of the child&#39;s information that the child provided to Welch&#39;s, will accompany a letter to the parent. This letter will provide the same information as the e-mail letter that is sent to the parent upon the child&#39;s attempt to register. Welch&#39;s will require the parent to return one copy of the form containing their child&#39;s information with their signature, indicating their consent for Welch&#39;s to retain their child&#39;s online information. The parent may also edit the record and return one copy of the child&#39;s record, with their signature, to Welch&#39;s. The parent may also request that the record be deleted by indicating their wishes in writing on one copy of the child&#39;s record. If, within 21 days of the date that the child enters their information into Welch&#39;s Grapelink, a return letter is not received from the parent with instructions to approve (provide consent), edit (and provide consent) or delete the record of the child, the record will be automatically deleted by welchs.com. Parents who elect to return the letter of request for their consent for Welch&#39;s to retain their child&#39;s information must be addressed to:&nbsp;<br style=\\\"box-sizing: border-box;\\\" />\r\n<br style=\\\"box-sizing: border-box;\\\" />\r\nWelch&#39;s Consumer Affairs<br style=\\\"box-sizing: border-box;\\\" />\r\n2 South Portage Street<br style=\\\"box-sizing: border-box;\\\" />\r\nWestfield, NY 14787-1492<br style=\\\"box-sizing: border-box;\\\" />\r\nAttn: www.welchs.com</p>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">Once Welch&#39;s has received consent from the parent of the child attempting to register, a letter confirming that consent to registration will be mailed to the parent, with a copy to the child.</p>\r\n\r\n<h3 style=\\\"box-sizing: border-box; font-size: 16px; margin: 1em 0px 0px; color: rgb(34, 31, 115); font-family: AvenirLTStd-Medium, Arial, Helvetica, sans-serif; line-height: 19px;\\\">4.&nbsp;How a Parent May Edit or Delete Their Child&#39;s Information or Revoke Consent</h3>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">The parent or guardian of a registered child, will always have the option at any time to view, change, or delete any of the information we have collected from their child. For security reasons, we will not give out any of the information that we have on file to enable access to a child&#39;s record. If a parent does not have the e-mail message that was sent to the parent containing the hypertext link (URL) to the child&#39;s personal information (the e-mail with a subject line &quot;Request for Consent to Collect Child&#39;s Personal Information&quot;), the parent may send an e-mail to: support@welchs.com and provide us with the child&#39;s name and the parent&#39;s e-mail address. The parent&#39;s e-mail address must match the parental e-mail address that the child provided to Welch&#39;s and to which Welch&#39;s e-mailed the request for parental consent. If the e-mail address you provide us in your request matches that provided by the child and from which we received parental consent, Welch&#39;s will then resend the original &quot;Request for Consent to Collect Child&#39;s Personal Information&quot; to the same e-mail address to which we originally sent it.</p>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">A parent or guardian of a child who does not have an e-mail account and has given their written consent to Welch&#39;s to retain the information provided by and collected about their child (as outlined in the section above: Permission Process &ndash; How a Parent May Give Consent to Collection of Information from a Child under Age 13) may wish to edit or delete this record in the future. The parent may do this by sending a written request at the address below, with explicit directions to edit or to delete their child&#39;s record. Welch&#39;s will mail to the parent a written confirmation of this edit or deletion, with a copy to the child.</p>\r\n\r\n<h3 style=\\\"box-sizing: border-box; font-size: 16px; margin: 1em 0px 0px; color: rgb(34, 31, 115); font-family: AvenirLTStd-Medium, Arial, Helvetica, sans-serif; line-height: 19px;\\\">5.&nbsp;Who We May Share this Information With</h3>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">Welch&#39;s has set forth the same guidelines regarding the way we use personal information to apply to the personally identifiable information of children under 13 who register with our site, as with registrants who are over the age of 13 and do not require parental consent to register with welchs.com:</p>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">Welch&#39;s will not sell or rent your personally identifiable information to anyone. Welch&#39;s will send personally identifiable information about you to other companies or people when:</p>\r\n\r\n<ul style=\\\"box-sizing: border-box; margin: 0px 0px 3px; padding-right: 0px; padding-left: 0px; list-style: none; line-height: 17px; color: rgb(0, 0, 0); font-family: Arial, Helvetica, sans-serif;\\\">\r\n	<li style=\\\"box-sizing: border-box; color: rgb(34, 31, 115); list-style-type: disc; margin-left: 20px; margin-bottom: 10px;\\\">We have your consent to do so.</li>\r\n	<li style=\\\"box-sizing: border-box; color: rgb(34, 31, 115); list-style-type: disc; margin-left: 20px; margin-bottom: 10px;\\\">We need to share the information in order to provide the product or service you have requested.</li>\r\n	<li style=\\\"box-sizing: border-box; color: rgb(34, 31, 115); list-style-type: disc; margin-left: 20px; margin-bottom: 10px;\\\">We need to send the information to companies who work on behalf of Welch&#39;s to provide a product or service for you on our behalf. Examples include hosting and helping to run this Web site, delivering packages, sending postal mail and e-mail, removing repetitive information from customer lists, analyzing data, providing marketing assistance, and providing customer service. Unless we tell you differently, these companies do not have any right to use the personally identifiable information we provide to them beyond what is necessary to assist us, unless they have your consent to do so.</li>\r\n	<li style=\\\"box-sizing: border-box; color: rgb(34, 31, 115); list-style-type: disc; margin-left: 20px; margin-bottom: 10px;\\\">We need to respond to valid legal process. This includes a search warrant, subpoena, or court order, and any other instance when we believe we are required to do so by law. We may also make disclosures to protect your safety during emergencies if your physical safety is believed to be at risk, to protect the security or integrity of the Welch&#39;s Web site, or to take precautions against liability. We will take reasonable steps to limit the scope of these disclosures.</li>\r\n</ul>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">Other than as set out above, you will receive notice when information about you might go to third parties, and you will have an opportunity to choose not to share the information (opt-out).</p>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">Welch&#39;s may share aggregated, non-personally identifiable information about our users with other companies for marketing and promotional purposes.</p>\r\n\r\n<h3 style=\\\"box-sizing: border-box; font-size: 16px; margin: 1em 0px 0px; color: rgb(34, 31, 115); font-family: AvenirLTStd-Medium, Arial, Helvetica, sans-serif; line-height: 19px;\\\">6.&nbsp;Whether or Not the Information We Request is Necessary to Register or Participate in an Activity on the Welch&#39;s Website</h3>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">Welch&#39;s cannot and will not condition a child&#39;s participation in an activity on this site on the child disclosing more personal information than is reasonably necessary to participate in the activity. Personal information sufficient to create a complete and approved registration record is required in order to participate in any promotional activities (such as sweepstakes) or, request a coupon from Welch&#39;s through the &quot;My Grapelink&quot; members-only section of welchs.com. All areas outside of the &quot;My Grapelink&quot; area of welchs.com are open to all visitors to the website.</p>\r\n\r\n<h2 style=\\\"box-sizing: border-box; font-size: 18px; margin: 0.83em 0px 8px; color: rgb(34, 31, 115); font-family: AvenirLTStd-Medium, Arial, Helvetica, sans-serif; line-height: 22px; border-bottom-width: 2px; border-bottom-style: solid; border-bottom-color: rgb(34, 31, 115);\\\">Changes in Our Policy</h2>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">Welch&#39;s reserves the right to change this Privacy Policy at our discretion. If we decide to change our Privacy Policy we will post those changes here. We encourage you to visit this section of our website frequently to be informed of any changes. If you provide consent to collection and use of personal information about your child and we make any material change in the type of information we collect or the way we use that information, we will notify you of those changes and obtain your permission before we request any additional personal information from your child. We will not change our policy to allow us to give personal information to a third party without first obtaining permission from our registered users and their parent or legal guardian if they are under age 13.</p>\r\n\r\n<h2 style=\\\"box-sizing: border-box; font-size: 18px; margin: 0.83em 0px 8px; color: rgb(34, 31, 115); font-family: AvenirLTStd-Medium, Arial, Helvetica, sans-serif; line-height: 22px; border-bottom-width: 2px; border-bottom-style: solid; border-bottom-color: rgb(34, 31, 115);\\\">Your Consent to this Privacy Policy</h2>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">By using this website, you agree to the parameters of this policy and agree to the terms stated herein by Welch&#39;s and Welch Foods Incorporated. If you do not agree with these terms, please do not use this site or submit any personal information.</p>\r\n\r\n<h2 style=\\\"box-sizing: border-box; font-size: 18px; margin: 0.83em 0px 8px; color: rgb(34, 31, 115); font-family: AvenirLTStd-Medium, Arial, Helvetica, sans-serif; line-height: 22px; border-bottom-width: 2px; border-bottom-style: solid; border-bottom-color: rgb(34, 31, 115);\\\">How to Contact Us</h2>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">If you have any questions or concerns about this Privacy Policy or our data collection practices, please contact us as follows:</p>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">Consumer Affairs<br style=\\\"box-sizing: border-box;\\\" />\r\nWelch Foods Inc., A Cooperative<br style=\\\"box-sizing: border-box;\\\" />\r\n2 South Portage Street<br style=\\\"box-sizing: border-box;\\\" />\r\nWestfield, NY 14787-1492<br style=\\\"box-sizing: border-box;\\\" />\r\nPhone: (800) 340-6870</p>\r\n\r\n<p style=\\\"box-sizing: border-box; margin: 0px 0px 15px; color: rgb(34, 31, 115); line-height: 17px; padding-right: 10px; font-family: Arial, Helvetica, sans-serif;\\\">email:&nbsp;<a href=\\\"mailto:askwelchs@welchs.com\\\" style=\\\"box-sizing: border-box; color: rgb(135, 108, 220);\\\">askwelchs@welchs.com</a></p>","Privacy Policy","","","noindex,nofollow","0","0","0","1","08_09_15_09_09_14Niagara_grapes_on_vine.jpg","02_09_26_09_09_14Privacy-Policy.png","","Privacy Policy","0","0","Privacy Policy","","");
INSERT INTO tbl_pages VALUES("6","quality-control","Quality Control","<p><strong>Vineyard Care</strong></p>\r\n\r\n<p><strong>Harvest</strong></p>\r\n\r\n<p><strong>Processing Plant</strong></p>\r\n\r\n<p><strong>Certification</strong></p>\r\n\r\n<p><strong>HACCP</strong></p>","Quality Control","","","index,follow","5","1","1","1","01_09_15_09_09_14Concord_grapes_on_vine.jpg","10_09_42_10_09_14A-Grapes.png","","Quality Control","1","1","Quality Control","","");
INSERT INTO tbl_pages VALUES("7","r-d","R&D","<p>Welch&#39;s Global Ingredients has a fully trained and supportive R&amp;D and Product Development staff in grape juice, beverage and food applications. This group, known as the Grape Center of Excellence, provides leadership in a number of areas important to maintaining and improving the quality and marketability of Welch&#39;s Concord and Niagara grapes. Specifically, the GCOE scope is from vineyard to bottle and our areas of research focus on:</p>\r\n\r\n<p>* Improving the quality of our Concord and Niagara grapes by working closely with our grower-owners</p>\r\n\r\n<p>* Deepening our understanding of grape chemistry to improve quality, cost and processing efficiency</p>\r\n\r\n<p>* Formulation and processing technology to deliver consistent taste, despite the variation in crop size and quality</p>\r\n\r\n<p>* Developing new analytical methods to characterize juice quality and control grape processing</p>\r\n\r\n<p>* Conducting clinical testing to understand the health and nutrition benefits of Concord and Niagara grape juice</p>\r\n\r\n<p>* Developing novel Concord and Niagara ingredients for Welch&#39;s and external customers</p>","R&D","","","index,follow","6","1","0","1","06_09_59_12_09_14RD.jpg","09_09_45_11_09_14RD_Greg_May.png","","R&D","1","1","R&D","","");
INSERT INTO tbl_pages VALUES("8","definitions","Definitions","<p><strong style=\\\"line-height: 1.6em;\\\">Brix = </strong><span style=\\\"line-height: 1.6em;\\\">% soluble solids by weight as measured by refractive index (bending of light) relative to sucrose in pure water). 1 degree Brix = 1% sucrose by weight. The Brix scale is used to measure the amount of Water Soluble Solids in a juice. The main contributors to Brix readings in grape juice are the naturally present sugars (glucose &amp; fructose). Acids (tartaric and malic), anthocyanins and other polyphenols, potassium and other minerals, and pectins, may also make a small increase in the Brix value, since these compounds affect the refractive index.&nbsp;</span></p>\r\n\r\n<p><strong>WSS =</strong> Water soluble solids, those carbohydrate and acid based solids that dissolve in water, often synonymous with Brix. The main contributors to WSS readings in grape juice are the naturally present sugars (glucose &amp; fructose). Acids (tartaric and malic), anthocyanins and other polyphenols, potassium and other minerals, and pectins, may also make a small increase in the solids value.&nbsp;</p>\r\n\r\n<p><strong>ISS = </strong>Insoluble solids, typically complex carbohydrates, tartrate complexes, and polymerized compounds from fruit skin and pulp that are not soluble in water.&nbsp;</p>\r\n\r\n<p><strong>Titratable Acidity =</strong> a measure of the total amount of available hydrogen ions (from acid) in a sample. It is measured by titration (neutralization with base to specific endpoint pH) and it is typically reported as % citric or tartaric acid (weight per weight or weight per volume).&nbsp;</p>\r\n\r\n<p><strong>pH</strong> = a logarithmic quantification of the degree of acidic or basic nature of a sample. pH scale = 0-14 with 7.0 = neutral and &lt;7.0 = acidic and &gt;7.0= basic. Juices tend to be pH 2.5-4.5 depending on type. Grape juice tends to be 3.0-4.0.&nbsp;</p>\r\n\r\n<p><strong>Color = </strong>For purple or red grape juices, Welch&rsquo;s measures color as absorbance units at 520 nm per gram of sample, corrected for the dilution volume and measured at pH 3.2.&nbsp;</p>\r\n\r\n<p><strong>Density =</strong> weight per unit of volume, typically reported as pounds per gallon or milligrams per liter.&nbsp;</p>\r\n\r\n<p><strong>Turbidity =</strong> measurement of cloudiness or haze in a liquid sample. Reported in various units, Welch&rsquo;s uses NTU or Nephelometric Turbidity Units. A Nephelometer measures the amount of light scattered in a controlled way.&nbsp;</p>\r\n\r\n<p>NFC = Not from concentrate juice, or as-is pressed from fruit and not reconstituted from concentrated juice.&nbsp;</p>\r\n\r\n<p><strong>Concentrate =</strong> water is removed from single strength juice by application of heat &amp; vacuum to reduce the volume, stabilize the fruit juice solids and simplify storage and transportation of juice.&nbsp;</p>\r\n\r\n<p><strong>Essence =</strong> volatile flavor components captured during concentration and either stored separately or added back to concentrated juice.&nbsp;</p>\r\n\r\n<p><strong>Soda Base =</strong> a concentrated blend of juices, sugars, acids, and flavors that are used to make single strength sodas when carbonated water is added.&nbsp;</p>","Definitions","","","index,follow","7","1","0","1","01_09_57_09_09_14Concord_grapes_on_vine.jpg","10_09_35_10_09_14A-Grapes.png","","Definitions","0","1","Definitions","","");
INSERT INTO tbl_pages VALUES("9","applications","Applications","<p><strong><img alt=\\\"\\\" src=\\\"/Robinson/ckfinder/userfiles/images/Applications/Applications.png\\\" style=\\\"height:598px; width:669px\\\" /></strong></p>\r\n\r\n<p><strong>Juice / Beverages / Smoothies</strong></p>\r\n\r\n<p><strong>Jams, Jellies &amp; Marmalades</strong></p>\r\n\r\n<p><strong>Dairy &amp; Ice Cream</strong></p>\r\n\r\n<p><strong>Frozen Desserts/Novelties</strong></p>\r\n\r\n<p><strong>Confectionary</strong></p>\r\n\r\n<p><strong>Sauces / Dips</strong></p>\r\n\r\n<p><strong>Snacks / Bakery</strong></p>\r\n\r\n<p><strong>Alcoholic Beverages / Mixers / Syrups</strong></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\\\"font-family:arial,helvetica,sans-serif; font-size:12px\\\">*Shaded blue connotes acceptable use.</span></p>","Applications","","","index,follow","8","1","1","1","01_09_35_09_09_14Concord_grapes_on_vine.jpg","10_09_57_10_09_14A-Grapes.png","","Applications","1","1","Applications","","");
INSERT INTO tbl_pages VALUES("10","health-nutrition","Health & Nutrition","<address>\r\n<p>Two research studies on commonly consumed beverages found that Concord Grape Juice had one of the highest concentrations of polyphenols among the juices tested. &nbsp;In a study conducted at the University of Glasgow,&sup1; Welch&rsquo;s Purple Grape Juice (made from Concord grapes) had the highest polyphenol concentration &nbsp;among the 13 juice and juice drinks tested, including two other grape juices. &nbsp;The Purple Grape Juice also contained the largest number of polyphenol compounds. &nbsp;In another study, Seerem and colleagues reported that Concord Grape Juice was among the juices with the highest average polyphenol concentration (see chart above).&sup2;&rdquo; &nbsp;</p>\r\n\r\n<p>&sup1;Mullen W, Marks SC and Crozier A. Evaluation of Phenolic Compounds in Commercial Fruit Juices and Fruit Drinks. J Agric Food Chem. 2007. 55:3148-3157. &nbsp;&sup2; Seeram NP, Aviram M, Zhang Y, Henning SM, Feng L, Dreher M and Heber D. Comparison of Antioxidant Potency of Commonly Consumed Polyphenol-Rich Beverages in the United States. J Agric Food Chem. 2008. 56(4):1415&ndash;1422.</p>\r\n</address>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p align=\\\"center\\\"><strong>HEALTH BENEFITS OF CONCORD GRAPE</strong></p>\r\n\r\n<p align=\\\"center\\\">Health and Nutrition Glossary</p>\r\n\r\n<p>Go to: <a href=\\\"http://www.welchs.com/health-and-nutrition/glossary#phytonutrients\\\">http://www.welchs.com/health-and-nutrition/glossary#phytonutrients</a>&nbsp; (use same links)</p>\r\n\r\n<p><strong>Antioxidants</strong> are compounds in foods and beverages that can help protect healthy cells from the damaging effects of <a href=\\\"http://www.welchs.com/health-and-nutrition/glossary#oxidativestress\\\">oxidative stress</a>, a condition that may, over time, have an impact on health. Vitamins C, E and A (as beta carotene), and the mineral selenium, and certain <a href=\\\"http://www.welchs.com/health-and-nutrition/glossary#phytonutrients\\\">phytonutrients</a> (such as <a href=\\\"http://www.welchs.com/health-and-nutrition/glossary#polyphenols\\\">polyphenols</a>) can act as antioxidants.</p>\r\n\r\n<p><strong>Concord grape</strong> is a hearty American grape with a thick, dark purple skin and seeds that naturally have plant nutrients (<a href=\\\"http://www.welchs.com/health-and-nutrition/glossary#phytonutrients\\\">phytonutrients</a>) called <a href=\\\"http://www.welchs.com/health-and-nutrition/glossary#polyphenols\\\">polyphenols</a>. Not only do polyphenols give Concord grapes their vibrant color, these plant nutrients also act as antioxidants and deliver benefits to promote health. Seedless grapes, like red table grapes, do not appear to contain the same quantity of these polyphenols.</p>\r\n\r\n<p><strong>Flavonoids</strong> are the largest and most studied subgroup of <a href=\\\"http://www.welchs.com/health-and-nutrition/glossary#polyphenols\\\">polyphenols</a> and represent the vast majority of the polyphenols found in both the <a href=\\\"http://www.welchs.com/health-and-nutrition/glossary#niagaragrapes\\\">Niagara</a> and <a href=\\\"http://www.welchs.com/health-and-nutrition/glossary#concordgrapes\\\">Concord grapes</a>. There are thousands of different flavonoids in fruits, vegetables and certain plant-derived beverages (i.e., teas and juices). Many of these flavonoids act as antioxidants and are becoming popular because of emerging science that suggests flavonoids may have health-supporting effects.</p>\r\n\r\n<p><strong>Macronutrients</strong> are nutrients the body needs in large quantities, like carbohydrates, fats and proteins.</p>\r\n\r\n<p><strong>Micronutrients</strong> are nutrients the body needs in smaller quantities, like vitamins, minerals and trace elements.</p>\r\n\r\n<p><strong>Niagara grape</strong> is a hearty American grape, and like its cousin the <a href=\\\"http://www.welchs.com/health-and-nutrition/glossary#concordgrape\\\">Concord</a>, it is a seeded grape with natural plant nutrients (<a href=\\\"http://www.welchs.com/health-and-nutrition/glossary#phytonutrients\\\">phytonutrients</a>) called <a href=\\\"http://www.welchs.com/health-and-nutrition/glossary#polyphenols\\\">polyphenols</a>. Seedless grapes, like green table grapes, do not appear to contain the same quantity of these potentially health-supporting phytonutrients.</p>\r\n\r\n<p><strong>Nutrients</strong> are compounds needed for human growth and development.</p>\r\n\r\n<p><strong>Oxidative stress</strong> is a condition that can damage healthy cells. It has been identified as a possible contributor to certain chronic health problems.</p>\r\n\r\n<p><strong>Phytonutrients</strong> are plant-based nutrients that appear to have health-supporting effects but are not considered essential for human survival. Fruits, vegetables, grains, legumes, nuts and teas have these compounds, which are being actively studied for their potential impact on health.</p>\r\n\r\n<p><strong>Polyphenols</strong> are a subgroup of <a href=\\\"http://www.welchs.com/health-and-nutrition/glossary#phytonutrients\\\">phytonutrients</a>. They are found in foods like onions, tea, red wine, grapes, and certain nuts. Polyphenols naturally protect plants against pathogens, parasites and predators, and often contribute to the flavor and color of fruits and vegetables. More research is necessary to determine their impact on human health.</p>\r\n\r\n<p><strong>Resveratrol</strong> is a natural compound (a <a href=\\\"http://www.welchs.com/health-and-nutrition/glossary#polyphenol\\\">polyphenol</a>) that can sometimes be found in the skin of grapes &mdash; with more found in dark grapes found in cooler climates, with less sunlight and more rainfall. Certain plants produce resveratrol in response to environmental stress like fungal infections. Scientists became interested in studying resveratrol as part of the possible link to the French paradox.</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><strong>Power of Purple</strong></p>\r\n\r\n<p>If there&rsquo;s one rule to remember about healthy eating, it&rsquo;s to paint your plate with lots of color. Colorful fruits and vegetables offer essential vitamins, minerals and beneficial plant nutrients, like <a href=\\\"http://www.welchs.com/health-and-nutrition/glossary#polyphenols\\\">polyphenols</a>. And, while it&rsquo;s certainly important to eat a rainbow of produce, it&rsquo;s worth paying attention to the purples and blues.</p>\r\n\r\n<p>According to an analysis of the diets of more than 15,000 adults and children, consuming purple and blue foods, such as <a href=\\\"http://www.welchs.com/health-and-nutrition/health-benefits-of-concord-grapes/concord-grapes-and-heart-health\\\">Concord grapes</a> and 100% grape juice, may help Americans get more of the nutrients they need each day and have overall healthier diets.<sup>1</sup> In general, adults and children who consumed purple and blue produce ate more fruit and had healthier diets compared to non-purple and blue produce eaters.<sup>1</sup> Unfortunately, according to the Produce for Better Health Foundation, only 3% of Americans&#39; fruit and vegetable intake is from the purple and blue category.<sup>2</sup></p>\r\n\r\n<p><strong>References</strong></p>\r\n\r\n<p style=\\\"margin-left:2.25pt;\\\">1.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; McGill CR, Wightman JD, Fulgoni S and Fulgoni III VL. Consumption of Purple/Blue Produce is Associated with Increased Nutrient Intake and Reduced Risk for Metabolic Syndrome: Results From the National Health and Nutrition Examination Survey 1999-2002. Am J Lifestyle Med. May/June 2011. 5(3):279-290.</p>\r\n\r\n<p style=\\\"margin-left:2.25pt;\\\">2.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Produce For Better Health Foundation. State of the Plate Study on America&#39;s Consumption of Fruits and Vegetables. Wilmington, Delaware. 2003.</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>A recent Welch&rsquo;s survey found that two-thirds of Americans recognize that red wine, salmon, oatmeal, or olive oil are heart-healthy foods; however, a fraction of these same shoppers buy these foods on a monthly basis.<sup>1</sup> To add to that, only 29% of those surveyed were aware that they can get many of the same natural plant nutrients that are in red wine from grape juice made with Concord grapes.</p>\r\n\r\n<p>Indeed the <a href=\\\"http://www.welchs.com/docs/default-source/health-and-nutrition/power_of_grape_consumer.pdf?sfvrsn=6\\\" title=\\\"Concord grape\\\">Concord grape</a> is a little purple fruit that packs quite a nutrition punch. That&#39;s because Concord grapes have natural plant nutrients called <a href=\\\"http://www.welchs.com/health-and-nutrition/glossary\\\">polyphenols</a> &mdash; and research suggests that certain polyphenols may play a role in supporting heart health. To add to that, more than a decade&rsquo;s worth of research suggests that drinking 100% grape juice made with Concord grapes can help support a healthy heart.</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>Concord Grapes &amp; Health&nbsp; (from <a href=\\\"http://www.grapescience.com/\\\">www.grapescience.com</a>)</p>\r\n\r\n<p><a href=\\\"http://www.grapescience.com/concord-grapes-and-health/cardiovascular-health.aspx\\\"><strong>Learn more about grapes and cardiovascular health</strong></a></p>\r\n\r\n<p>http://www.grapescience.com/concord-grapes-and-health/</p>\r\n\r\n<p><a href=\\\"http://www.grapescience.com/concord-grapes-and-health/cognitive-function.aspx\\\"><strong>Learn more about grapes and cognitive health</strong></a></p>\r\n\r\n<p>http://www.grapescience.com/concord-grapes-and-health/</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><a href=\\\"http://www.grapescience.com/concord-grapes-and-health/immunity.aspx\\\"><strong>Learn more about grapes and immune system health</strong></a></p>\r\n\r\n<p>http://www.grapescience.com/concord-grapes-and-health/</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>Two research studies on commonly consumed beverages found that Concord Grape Juice had one of the highest concentrations of polyphenols among the juices tested.&nbsp; In a study conducted at the University of Glasgow,&sup1; Welch&rsquo;s Purple Grape Juice (made from Concord grapes) had the highest polyphenol concentration&nbsp; among the 13 juice and juice drinks tested, including two other grape juices.&nbsp; The Purple Grape Juice also contained the largest number of polyphenol compounds.&nbsp; In another study, Seerem and colleagues reported that Concord Grape Juice was among the juices with the highest average polyphenol concentration (see chart).&sup2;</p>\r\n\r\n<p>References:</p>\r\n\r\n<p>&sup1; Mullen W, Marks SC and Crozier A. Evaluation of Phenolic Compounds in Commercial Fruit Juices and Fruit Drinks. J Agric Food Chem. 2007. 55:3148-3157.</p>\r\n\r\n<p>&sup2; Seeram NP, Aviram M, Zhang Y, Henning SM, Feng L, Dreher M and Heber D. Comparison of Antioxidant Potency of Commonly Consumed Polyphenol-Rich Beverages in the United States. J Agric Food Chem. 2008. 56(4):1415&ndash;1422.</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>","Health & Nutrition","","","index,follow","9","1","0","1","11_09_40_08_09_14Concord_grapes_on_vine.jpg","09_09_48_10_09_14Poly table.jpg","","Health & Nutrition","0","0","Health & Nutrition","","");
INSERT INTO tbl_pages VALUES("11","news","News","<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>","News","","","index,follow","11","1","0","1","09_09_40_10_09_14Niagara_grapes_on_vine.jpg","09_09_17_10_09_14A-Grapes.png","","News","0","1","News","","");
INSERT INTO tbl_pages VALUES("12","contact-us","Contact","<div class=\\\"row\\\">\r\n<div class=\\\"col-lg-8\\\">\r\n<form action=\\\"\\\" method=\\\"post\\\">\r\n<div class=\\\"row\\\">\r\n<div class=\\\"col-lg-6\\\">\r\n<div class=\\\"form-group\\\">Name <input name=\\\"the_name\\\" type=\\\"text\\\" /></div>\r\n</div>\r\n\r\n<div class=\\\"col-lg-6\\\">\r\n<div class=\\\"form-group\\\">Title <input name=\\\"the_title\\\" type=\\\"text\\\" /></div>\r\n</div>\r\n\r\n<div class=\\\"col-lg-12\\\">\r\n<div class=\\\"form-group\\\">Company Name <input name=\\\"c_name\\\" type=\\\"text\\\" /></div>\r\n</div>\r\n\r\n<div class=\\\"col-lg-12\\\">\r\n<div class=\\\"form-group\\\">Address <input name=\\\"c_address\\\" type=\\\"text\\\" /></div>\r\n</div>\r\n\r\n<div class=\\\"col-lg-4\\\">\r\n<div class=\\\"form-group\\\">City <input name=\\\"city\\\" type=\\\"text\\\" /></div>\r\n</div>\r\n\r\n<div class=\\\"col-lg-4\\\">\r\n<div class=\\\"form-group\\\">State <input name=\\\"state\\\" type=\\\"text\\\" /></div>\r\n</div>\r\n\r\n<div class=\\\"col-lg-4\\\">\r\n<div class=\\\"form-group\\\">Zip Code <input name=\\\"zipcode\\\" type=\\\"text\\\" /></div>\r\n</div>\r\n\r\n<div class=\\\"col-lg-12\\\">\r\n<div class=\\\"form-group\\\">Country <select name=\\\"country\\\"><option selected=\\\"selected\\\" value=\\\"US\\\">United States</option><option value=\\\"AF\\\">Afghanistan</option><option value=\\\"AL\\\">Albania</option><option value=\\\"DZ\\\">Algeria</option><option value=\\\"AS\\\">American Samoa</option><option value=\\\"AD\\\">Andorra</option><option value=\\\"AO\\\">Angola</option><option value=\\\"AI\\\">Anguilla</option><option value=\\\"AQ\\\">Antarctica</option><option value=\\\"AG\\\">Antigua And Barbuda</option><option value=\\\"AR\\\">Argentina</option><option value=\\\"AM\\\">Armenia</option><option value=\\\"AW\\\">Aruba</option><option value=\\\"AU\\\">Australia</option><option value=\\\"AT\\\">Austria</option><option value=\\\"AZ\\\">Azerbaijan</option><option value=\\\"BS\\\">Bahamas</option><option value=\\\"BH\\\">Bahrain</option><option value=\\\"BD\\\">Bangladesh</option><option value=\\\"BB\\\">Barbados</option><option value=\\\"BY\\\">Belarus</option><option value=\\\"BE\\\">Belgium</option><option value=\\\"BZ\\\">Belize</option><option value=\\\"BJ\\\">Benin</option><option value=\\\"BM\\\">Bermuda</option><option value=\\\"BT\\\">Bhutan</option><option value=\\\"BO\\\">Bolivia</option><option value=\\\"BA\\\">Bosnia And Herzegowina</option><option value=\\\"BW\\\">Botswana</option><option value=\\\"BV\\\">Bouvet Island</option><option value=\\\"BR\\\">Brazil</option><option value=\\\"IO\\\">British Indian Ocean Territory</option><option value=\\\"BN\\\">Brunei Darussalam</option><option value=\\\"BG\\\">Bulgaria</option><option value=\\\"BF\\\">Burkina Faso</option><option value=\\\"BI\\\">Burundi</option><option value=\\\"KH\\\">Cambodia</option><option value=\\\"CM\\\">Cameroon</option><option value=\\\"CA\\\">Canada</option><option value=\\\"CV\\\">Cape Verde</option><option value=\\\"KY\\\">Cayman Islands</option><option value=\\\"CF\\\">Central African Republic</option><option value=\\\"TD\\\">Chad</option><option value=\\\"CL\\\">Chile</option><option value=\\\"CN\\\">China</option><option value=\\\"CX\\\">Christmas Island</option><option value=\\\"CC\\\">Cocos (Keeling) Islands</option><option value=\\\"CO\\\">Colombia</option><option value=\\\"KM\\\">Comoros</option><option value=\\\"CG\\\">Congo</option><option value=\\\"CK\\\">Cook Islands</option><option value=\\\"CR\\\">Costa Rica</option><option value=\\\"CI\\\">Cote D&#39;Ivoire</option><option value=\\\"HR\\\">Croatia (Local Name: Hrvatska)</option><option value=\\\"CU\\\">Cuba</option><option value=\\\"CY\\\">Cyprus</option><option value=\\\"CZ\\\">Czech Republic</option><option value=\\\"DK\\\">Denmark</option><option value=\\\"DJ\\\">Djibouti</option><option value=\\\"DM\\\">Dominica</option><option value=\\\"DO\\\">Dominican Republic</option><option value=\\\"TP\\\">East Timor</option><option value=\\\"EC\\\">Ecuador</option><option value=\\\"EG\\\">Egypt</option><option value=\\\"SV\\\">El Salvador</option><option value=\\\"GQ\\\">Equatorial Guinea</option><option value=\\\"ER\\\">Eritrea</option><option value=\\\"EE\\\">Estonia</option><option value=\\\"ET\\\">Ethiopia</option><option value=\\\"FK\\\">Falkland Islands (Malvinas)</option><option value=\\\"FO\\\">Faroe Islands</option><option value=\\\"FJ\\\">Fiji</option><option value=\\\"FI\\\">Finland</option><option value=\\\"FR\\\">France</option><option value=\\\"GF\\\">French Guiana</option><option value=\\\"PF\\\">French Polynesia</option><option value=\\\"TF\\\">French Southern Territories</option><option value=\\\"GA\\\">Gabon</option><option value=\\\"GM\\\">Gambia</option><option value=\\\"GE\\\">Georgia</option><option value=\\\"DE\\\">Germany</option><option value=\\\"GH\\\">Ghana</option><option value=\\\"GI\\\">Gibraltar</option><option value=\\\"GR\\\">Greece</option><option value=\\\"GL\\\">Greenland</option><option value=\\\"GD\\\">Grenada</option><option value=\\\"GP\\\">Guadeloupe</option><option value=\\\"GU\\\">Guam</option><option value=\\\"GT\\\">Guatemala</option><option value=\\\"GN\\\">Guinea</option><option value=\\\"GW\\\">Guinea-Bissau</option><option value=\\\"GY\\\">Guyana</option><option value=\\\"HT\\\">Haiti</option><option value=\\\"HM\\\">Heard And Mc Donald Islands</option><option value=\\\"VA\\\">Holy See (Vatican City State)</option><option value=\\\"HN\\\">Honduras</option><option value=\\\"HK\\\">Hong Kong</option><option value=\\\"HU\\\">Hungary</option><option value=\\\"IS\\\">Icel And</option><option value=\\\"IN\\\">India</option><option value=\\\"ID\\\">Indonesia</option><option value=\\\"IR\\\">Iran (Islamic Republic Of)</option><option value=\\\"IQ\\\">Iraq</option><option value=\\\"IE\\\">Ireland</option><option value=\\\"IL\\\">Israel</option><option value=\\\"IT\\\">Italy</option><option value=\\\"JM\\\">Jamaica</option><option value=\\\"JP\\\">Japan</option><option value=\\\"JO\\\">Jordan</option><option value=\\\"KZ\\\">Kazakhstan</option><option value=\\\"KE\\\">Kenya</option><option value=\\\"KI\\\">Kiribati</option><option value=\\\"KP\\\">Korea, Dem People&#39;S Republic</option><option value=\\\"KR\\\">Korea, Republic Of</option><option value=\\\"KW\\\">Kuwait</option><option value=\\\"KG\\\">Kyrgyzstan</option><option value=\\\"LA\\\">Lao People&#39;S Dem Republic</option><option value=\\\"LV\\\">Latvia</option><option value=\\\"LB\\\">Lebanon</option><option value=\\\"LS\\\">Lesotho</option><option value=\\\"LR\\\">Liberia</option><option value=\\\"LY\\\">Libyan Arab Jamahiriya</option><option value=\\\"LI\\\">Liechtenstein</option><option value=\\\"LT\\\">Lithuania</option><option value=\\\"LU\\\">Luxembourg</option><option value=\\\"MO\\\">Macau</option><option value=\\\"MK\\\">Macedonia</option><option value=\\\"MG\\\">Madagascar</option><option value=\\\"MW\\\">Malawi</option><option value=\\\"MY\\\">Malaysia</option><option value=\\\"MV\\\">Maldives</option><option value=\\\"ML\\\">Mali</option><option value=\\\"MT\\\">Malta</option><option value=\\\"MH\\\">Marshall Islands</option><option value=\\\"MQ\\\">Martinique</option><option value=\\\"MR\\\">Mauritania</option><option value=\\\"MU\\\">Mauritius</option><option value=\\\"YT\\\">Mayotte</option><option value=\\\"MX\\\">Mexico</option><option value=\\\"FM\\\">Micronesia, Federated States</option><option value=\\\"MD\\\">Moldova, Republic Of</option><option value=\\\"MC\\\">Monaco</option><option value=\\\"MN\\\">Mongolia</option><option value=\\\"MS\\\">Montserrat</option><option value=\\\"MA\\\">Morocco</option><option value=\\\"MZ\\\">Mozambique</option><option value=\\\"MM\\\">Myanmar</option><option value=\\\"NA\\\">Namibia</option><option value=\\\"NR\\\">Nauru</option><option value=\\\"NP\\\">Nepal</option><option value=\\\"NL\\\">Netherlands</option><option value=\\\"AN\\\">Netherlands Ant Illes</option><option value=\\\"NC\\\">New Caledonia</option><option value=\\\"NZ\\\">New Zealand</option><option value=\\\"NI\\\">Nicaragua</option><option value=\\\"NE\\\">Niger</option><option value=\\\"NG\\\">Nigeria</option><option value=\\\"NU\\\">Niue</option><option value=\\\"NF\\\">Norfolk Island</option><option value=\\\"MP\\\">Northern Mariana Islands</option><option value=\\\"NO\\\">Norway</option><option value=\\\"OM\\\">Oman</option><option value=\\\"PK\\\">Pakistan</option><option value=\\\"PW\\\">Palau</option><option value=\\\"PA\\\">Panama</option><option value=\\\"PG\\\">Papua New Guinea</option><option value=\\\"PY\\\">Paraguay</option><option value=\\\"PE\\\">Peru</option><option value=\\\"PH\\\">Philippines</option><option value=\\\"PN\\\">Pitcairn</option><option value=\\\"PL\\\">Poland</option><option value=\\\"PT\\\">Portugal</option><option value=\\\"PR\\\">Puerto Rico</option><option value=\\\"QA\\\">Qatar</option><option value=\\\"RE\\\">Reunion</option><option value=\\\"RO\\\">Romania</option><option value=\\\"RU\\\">Russian Federation</option><option value=\\\"RW\\\">Rwanda</option><option value=\\\"KN\\\">Saint K Itts And Nevis</option><option value=\\\"LC\\\">Saint Lucia</option><option value=\\\"VC\\\">Saint Vincent, The Grenadines</option><option value=\\\"WS\\\">Samoa</option><option value=\\\"SM\\\">San Marino</option><option value=\\\"ST\\\">Sao Tome And Principe</option><option value=\\\"SA\\\">Saudi Arabia</option><option value=\\\"SN\\\">Senegal</option><option value=\\\"SC\\\">Seychelles</option><option value=\\\"SL\\\">Sierra Leone</option><option value=\\\"SG\\\">Singapore</option><option value=\\\"SK\\\">Slovakia (Slovak Republic)</option><option value=\\\"SI\\\">Slovenia</option><option value=\\\"SB\\\">Solomon Islands</option><option value=\\\"SO\\\">Somalia</option><option value=\\\"ZA\\\">South Africa</option><option value=\\\"GS\\\">South Georgia , S Sandwich Is.</option><option value=\\\"ES\\\">Spain</option><option value=\\\"LK\\\">Sri Lanka</option><option value=\\\"SH\\\">St. Helena</option><option value=\\\"PM\\\">St. Pierre And Miquelon</option><option value=\\\"SD\\\">Sudan</option><option value=\\\"SR\\\">Suriname</option><option value=\\\"SJ\\\">Svalbard, Jan Mayen Islands</option><option value=\\\"SZ\\\">Sw Aziland</option><option value=\\\"SE\\\">Sweden</option><option value=\\\"CH\\\">Switzerland</option><option value=\\\"SY\\\">Syrian Arab Republic</option><option value=\\\"TW\\\">Taiwan</option><option value=\\\"TJ\\\">Tajikistan</option><option value=\\\"TZ\\\">Tanzania, United Republic Of</option><option value=\\\"TH\\\">Thailand</option><option value=\\\"TG\\\">Togo</option><option value=\\\"TK\\\">Tokelau</option><option value=\\\"TO\\\">Tonga</option><option value=\\\"TT\\\">Trinidad And Tobago</option><option value=\\\"TN\\\">Tunisia</option><option value=\\\"TR\\\">Turkey</option><option value=\\\"TM\\\">Turkmenistan</option><option value=\\\"TC\\\">Turks And Caicos Islands</option><option value=\\\"TV\\\">Tuvalu</option><option value=\\\"UG\\\">Uganda</option><option value=\\\"UA\\\">Ukraine</option><option value=\\\"AE\\\">United Arab Emirates</option><option value=\\\"GB\\\">United Kingdom</option><option value=\\\"US\\\">United States</option><option value=\\\"UM\\\">United States Minor Is.</option><option value=\\\"UY\\\">Uruguay</option><option value=\\\"UZ\\\">Uzbekistan</option><option value=\\\"VU\\\">Vanuatu</option><option value=\\\"VE\\\">Venezuela</option><option value=\\\"VN\\\">Viet Nam</option><option value=\\\"VG\\\">Virgin Islands (British)</option><option value=\\\"VI\\\">Virgin Islands (U.S.)</option><option value=\\\"WF\\\">Wallis And Futuna Islands</option><option value=\\\"EH\\\">Western Sahara</option><option value=\\\"YE\\\">Yemen</option><option value=\\\"YU\\\">Yugoslavia</option><option value=\\\"ZR\\\">Zaire</option><option value=\\\"ZM\\\">Zambia</option><option value=\\\"ZW\\\">Zimbabwe</option> </select></div>\r\n</div>\r\n\r\n<div class=\\\"col-lg-12\\\">\r\n<div class=\\\"form-group\\\">Email address <input name=\\\"the_email\\\" type=\\\"email\\\" /></div>\r\n</div>\r\n\r\n<div class=\\\"col-lg-12\\\">\r\n<div class=\\\"form-group\\\">Confirm Email address <input name=\\\"c_email\\\" type=\\\"email\\\" /></div>\r\n</div>\r\n\r\n<div class=\\\"col-lg-12\\\">\r\n<div class=\\\"form-group\\\">Product Interest <select name=\\\"p_interest\\\"><option>Concentrates</option><option>Blends</option><option>Essences</option><option>Other</option> </select></div>\r\n</div>\r\n\r\n<div class=\\\"col-lg-12\\\">\r\n<div class=\\\"form-group\\\">Applications of Interest <select name=\\\"a_interest\\\"><option>Juice / beverages /smoothies</option><option>Jams, Jellies &amp; Marmalades</option><option>Dairy &amp; Ice Cream</option><option>Frozen Desserts/Novelties</option><option>Confectionary</option><option>Sauces / Dips</option><option>Snacks / Bakery</option><option>Alcoholic Beverages / Mixers / Syrups</option> </select></div>\r\n</div>\r\n\r\n<div class=\\\"col-lg-12\\\">\r\n<div class=\\\"form-group\\\">Detailed Message<textarea name=\\\"msg\\\" rows=\\\"3\\\"></textarea></div>\r\n</div>\r\n\r\n<div class=\\\"col-lg-12\\\"><input name=\\\"email_submit\\\" type=\\\"submit\\\" value=\\\"Submit\\\" /></div>\r\n</div>\r\n</form>\r\n</div>\r\n</div>","Contact Us","","","index,follow","15","1","0","1","09_09_57_10_09_14Niagara_grapes_on_vine.jpg","","","Contact Us","0","1","Contact Us","","pgower@welchs.com");
INSERT INTO tbl_pages VALUES("13","careers","Careers","","Careers","","","index,follow","13","1","0","1","09_09_12_10_09_14Niagara_grapes_on_vine.jpg","","","Careers","0","1","Careers","http://www.welchs.com/about-us/careers","");



DROP TABLE IF EXISTS tbl_social;

CREATE TABLE `tbl_social` (
  `solid` int(11) NOT NULL AUTO_INCREMENT,
  `fb` varchar(255) NOT NULL,
  `tw` varchar(255) NOT NULL,
  `flicker` varchar(255) NOT NULL,
  `rss` varchar(255) NOT NULL,
  `gp` varchar(255) NOT NULL,
  `IStatus` tinyint(1) NOT NULL,
  PRIMARY KEY (`solid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO tbl_social VALUES("1","welchsgrapes","welchs","fl_welch","welchs","welchs","1");



DROP TABLE IF EXISTS tbl_terms;

CREATE TABLE `tbl_terms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO tbl_terms VALUES("1","dfds");



