<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$monarch_sections = array(
	'sharing' => array(
		'title'    => esc_html__( 'Social Sharing', 'Monarch' ),
		'contents' => array(
			'locations' => esc_html__( 'Locations', 'Monarch' ),
			'networks'  => esc_html__( 'Networks', 'Monarch' ),
			'sidebar'   => esc_html__( 'Sidebar', 'Monarch' ),
			'inline'    => esc_html__( 'Inline', 'Monarch' ),
			'popup'     => esc_html__( 'Pop Up', 'Monarch' ),
			'flyin'     => esc_html__( 'Fly In', 'Monarch' ),
			'media'     => esc_html__( 'On Media', 'Monarch' ),
		),
	),
	'follow'  => array(
		'title'    => esc_html__( 'Social Follow', 'Monarch' ),
		'contents' => array(
			'networks'  => esc_html__( 'Networks', 'Monarch' ),
			'widget'    => esc_html__( 'Widget', 'Monarch' ),
			'shortcode' => esc_html__( 'Shortcode', 'Monarch' ),
		),
	),
	'general' => array(
		'title'    => esc_html__( 'General Settings', 'Monarch' ),
		'contents' => array(
			'main' => esc_html__( 'Main', 'Monarch' ),
		),
	),
	'header'  => array(
		'contents' => array(
			'updates'      => esc_html__( 'Monarch Updates', 'Monarch' ),
			'importexport' => esc_html__( 'Import & Export', 'Monarch' ),
			'stats'        => esc_html__( 'Social Sharing Stats', 'Monarch' ),
		),
	),
);

$monarch_options_all = array(
	'icon_style' => array(
		'type'          => 'select_style',
		'title'         => esc_html__( 'Choose icon style', 'Monarch' ),
		'name'          => 'icon_style',
		'value'         => array(
			'flip',
			'darken',
			'slide',
			'simple',
		),
		'default'       => 'slide',
		'default_media' => 'simple',
	),
	'icon_style_sidebar' => array(
		'type'    => 'select_style',
		'title'   => esc_html__( 'Choose icon style', 'Monarch' ),
		'name'    => 'icon_style',
		'value'   => array(
			'flip',
			'border',
			'grow',
			'slide',
			'simple',
		),
		'default' => 'flip',
	),
	'icon_shape' => array(
		'type'            => 'select_shape',
		'title'           => esc_html__( 'Choose icon shape', 'Monarch' ),
		'name'            => 'icon_shape',
		'value'           => array(
			'rectangle',
			'rounded',
			'circle',
		),
		'default'         => 'rounded',
		'default_sidebar' => 'rectangle',
	),
	'title_text' => array(
		'section_start' => array(
			'type'  => 'section_start',
			'title' => esc_html__( 'Title', 'Monarch' ),
		),
		'option'        => array(
			'type'           => 'text',
			'rows'           => '1',
			'name'           => 'title_text',
			'placeholder'    => esc_html__( 'Share This', 'Monarch' ),
			'default'        => esc_html__( 'Share This', 'Monarch' ),
			'is_wpml_string' => 'true',
		),
	),
	'message_text' => array(
		'section_start' => array(
			'type'  => 'section_start',
			'title' => esc_html__( 'Message', 'Monarch' ),
		),
		'option'        => array(
			'type'           => 'text',
			'rows'           => '2',
			'name'           => 'message_text',
			'placeholder'    => esc_html__( 'Insert Text', 'Monarch' ),
			'default'        => esc_html__( 'Share this post with your friends!', 'Monarch' ),
			'is_wpml_string' => 'true',
		),
	),
	'api_settings' => array(
		'section_start'         => array(
			'type'       => 'section_start',
			'title'      => esc_html__( 'API Settings', 'Monarch' ),
			'name'       => 'follow_api',
			'display_if' => true,
		),
		'section_start_general' => array(
			'type'  => 'section_start',
			'title' => esc_html__( 'API Settings', 'Monarch' ),
		),
		'sub_section_vimeo' => array(
			'type'        => 'section_start',
			'sub_section' => true,
			'title'       => esc_html__( 'Vimeo', 'Monarch' ),
			'class'       => 'et_social_vimeo_api et_social_api_setting',
		),
		'option_vimeo_1' => array(
			'type'          => 'input_field',
			'subtype'       => 'text',
			'name'          => 'vimeo_id',
			'title'         => esc_html__( 'Client ID', 'Monarch' ),
			'default'       => '',
			'class'         => 'api_option api_option_client_id',
			'hide_contents' => true,
			'hint_text'     => sprintf(
				'<a href="%2$s" target="_blank">%1$s</a>',
				esc_html__( 'Click here for more information', 'Monarch' ),
				esc_url( 'http://www.elegantthemes.com/plugins/monarch/documentation/api/#vimeo' )
			),
			'hint_text_with_links' => 'on',
		),
		'option_vimeo_2' => array(
			'type'          => 'input_field',
			'subtype'       => 'text',
			'name'          => 'vimeo_secret',
			'title'         => esc_html__( 'Client Secret', 'Monarch' ),
			'default'       => '',
			'class'         => 'api_option api_option_client_secret',
			'hide_contents' => true,
			'hint_text'     => sprintf(
				'<a href="%2$s" target="_blank">%1$s</a>',
				esc_html__( 'Click here for more information', 'Monarch' ),
				esc_url( 'http://www.elegantthemes.com/plugins/monarch/documentation/api/#vimeo' )
			),
			'hint_text_with_links' => 'on',
		),
		'sub_section_instagram' => array(
			'type'        => 'section_start',
			'sub_section' => true,
			'title'       => esc_html__( 'Instagram', 'Monarch' ),
			'class'       => 'et_social_instagram_api et_social_api_setting',
		),
		'option_instagram_1' => array(
			'type'          => 'input_field',
			'subtype'       => 'text',
			'name'          => 'instagram_id',
			'title'         => esc_html__( 'Client ID', 'Monarch' ),
			'default'       => '',
			'class'         => 'api_option api_option_client_id',
			'hide_contents' => true,
			'hint_text'     => sprintf(
				'<a href="%2$s" target="_blank">%1$s</a>',
				esc_html__( 'Click here for more information', 'Monarch' ),
				esc_url( 'http://www.elegantthemes.com/plugins/monarch/documentation/api/#instagram' )
			),
			'hint_text_with_links' => 'on',
		),
		'option_instagram_2' => array(
			'type'          => 'input_field',
			'subtype'       => 'text',
			'name'          => 'instagram_secret',
			'title'         => esc_html__( 'Client Secret', 'Monarch' ),
			'default'       => '',
			'class'         => 'api_option api_option_client_secret',
			'hide_contents' => true,
			'hint_text'     => sprintf(
				'<a href="%2$s" target="_blank">%1$s</a>',
				esc_html__( 'Click here for more information', 'Monarch' ),
				esc_url( 'http://www.elegantthemes.com/plugins/monarch/documentation/api/#instagram' )
			),
			'hint_text_with_links' => 'on',
		),
		'sub_section_linkedin' => array(
			'type'        => 'section_start',
			'sub_section' => true,
			'title'       => esc_html__( 'LinkedIn', 'Monarch' ),
			'class'       => 'et_social_linkedin_api et_social_api_setting',
		),
		'option_linkedin_1' => array(
			'type'          => 'input_field',
			'subtype'       => 'text',
			'name'          => 'linkedin_id',
			'title'         => esc_html__( 'API Key', 'Monarch' ),
			'default'       => '',
			'class'         => 'api_option api_option_client_id',
			'hide_contents' => true,
			'hint_text'     => sprintf(
				'<a href="%2$s" target="_blank">%1$s</a>',
				esc_html__( 'Click here for more information', 'Monarch' ),
				esc_url( 'http://www.elegantthemes.com/plugins/monarch/documentation/api/#linkedin' )
			),
			'hint_text_with_links' => 'on',
		),
		'option_linkedin_2' => array(
			'type'          => 'input_field',
			'subtype'       => 'text',
			'name'          => 'linkedin_secret',
			'title'         => esc_html__( 'Secret Key', 'Monarch' ),
			'default'       => '',
			'class'         => 'api_option api_option_client_secret',
			'hide_contents' => true,
			'hint_text'     => sprintf(
				'<a href="%2$s" target="_blank">%1$s</a>',
				esc_html__( 'Click here for more information', 'Monarch' ),
				esc_url( 'http://www.elegantthemes.com/plugins/monarch/documentation/api/#linkedin' )
			),
			'hint_text_with_links' => 'on',
		),
		'sub_section_twitter' => array(
			'type'        => 'section_start',
			'sub_section' => true,
			'title'       => esc_html__( 'Twitter', 'Monarch' ),
			'class'       => 'et_social_twitter_api et_social_api_setting',
		),
		'option_twitter_1' => array(
			'type'          => 'input_field',
			'subtype'       => 'text',
			'name'          => 'twitter_api_key',
			'title'         => esc_html__( 'Consumer Key', 'Monarch' ),
			'default'       => '',
			'class'         => 'api_option api_option_api_key',
			'hide_contents' => true,
			'hint_text'     => sprintf(
				'<a href="%2$s" target="_blank">%1$s</a>',
				esc_html__( 'Click here for more information', 'Monarch' ),
				esc_url( 'http://www.elegantthemes.com/plugins/monarch/documentation/api/#twitter' )
			),
			'hint_text_with_links' => 'on',
		),
		'option_twitter_2' => array(
			'type'          => 'input_field',
			'subtype'       => 'text',
			'name'          => 'twitter_api_secret',
			'title'         => esc_html__( 'Consumer Secret', 'Monarch' ),
			'default'       => '',
			'class'         => 'api_option api_option_api_secret',
			'hide_contents' => true,
			'hint_text'     => sprintf(
				'<a href="%2$s" target="_blank">%1$s</a>',
				esc_html__( 'Click here for more information', 'Monarch' ),
				esc_url( 'http://www.elegantthemes.com/plugins/monarch/documentation/api/#twitter' )
			),
			'hint_text_with_links' => 'on',
		),
		'option_twitter_3' => array(
			'type'          => 'input_field',
			'subtype'       => 'text',
			'name'          => 'twitter_token',
			'title'         => esc_html__( 'Access Token', 'Monarch' ),
			'default'       => '',
			'class'         => 'api_option api_option_token',
			'hide_contents' => true,
			'hint_text'     => sprintf(
				'<a href="%2$s" target="_blank">%1$s</a>',
				esc_html__( 'Click here for more information', 'Monarch' ),
				esc_url( 'http://www.elegantthemes.com/plugins/monarch/documentation/api/#twitter' )
			),
			'hint_text_with_links' => 'on',
		),
		'option_twitter_4' => array(
			'type'          => 'input_field',
			'subtype'       => 'text',
			'name'          => 'twitter_token_secret',
			'title'         => esc_html__( 'Access Token Secret', 'Monarch' ),
			'default'       => '',
			'class'         => 'api_option api_option_token_secret',
			'hide_contents' => true,
			'hint_text'     => sprintf(
				'<a href="%2$s" target="_blank">%1$s</a>',
				esc_html__( 'Click here for more information', 'Monarch' ),
				esc_url( 'http://www.elegantthemes.com/plugins/monarch/documentation/api/#twitter' )
			),
			'hint_text_with_links' => 'on',
		),
		'sub_section_facebook' => array(
			'type'        => 'section_start',
			'sub_section' => true,
			'title'       => esc_html__( 'Facebook', 'Monarch' ),
			'class'       => 'et_social_facebook_api',
		),
		'option_facebook_1' => array(
			'type'          => 'input_field',
			'subtype'       => 'text',
			'name'          => 'facebook_id',
			'title'         => esc_html__( 'App ID', 'Monarch' ),
			'default'       => '',
			'class'         => 'api_option api_option_client_id',
			'hide_contents' => true,
			'hint_text'     => sprintf(
				'<a href="%2$s" target="_blank">%1$s</a>',
				esc_html__( 'Click here for more information', 'Monarch' ),
				esc_url( 'http://www.elegantthemes.com/plugins/monarch/documentation/api/#facebook' )
			),
			'hint_text_with_links' => 'on',
		),
		'option_facebook_2' => array(
			'type'          => 'input_field',
			'subtype'       => 'text',
			'name'          => 'facebook_secret',
			'title'         => esc_html__( 'App Secret', 'Monarch' ),
			'default'       => '',
			'class'         => 'api_option api_option_client_secret',
			'hide_contents' => true,
			'hint_text'     => sprintf(
				'<a href="%2$s" target="_blank">%1$s</a>',
				esc_html__( 'Click here for more information', 'Monarch' ),
				esc_url( 'http://www.elegantthemes.com/plugins/monarch/documentation/api/#facebook' )
			),
			'hint_text_with_links' => 'on',
		),
		'sub_section_youtube' => array(
			'type'        => 'section_start',
			'sub_section' => true,
			'title'       => esc_html__( 'Youtube', 'Monarch' ),
			'class'       => 'et_social_youtube_api et_social_api_setting',
		),
		'option_youtube_1' => array(
			'type'          => 'input_field',
			'subtype'       => 'text',
			'name'          => 'youtube_api_key',
			'title'         => esc_html__( 'API Key', 'Monarch' ),
			'default'       => '',
			'class'         => 'api_option api_option_api_key',
			'hide_contents' => true,
			'hint_text'     => sprintf(
				'<a href="%2$s" target="_blank">%1$s</a>',
				esc_html__( 'Click here for more information', 'Monarch' ),
				esc_url( 'http://www.elegantthemes.com/plugins/monarch/documentation/api/#youtube' )
			),
			'hint_text_with_links' => 'on',
		),
		'auth_button_vimeo' => array(
			'type'   => 'button',
			'title'  => esc_html__( 'Authorize', 'Monarch' ),
			'link'   => '#',
			'class'  => 'et_authorize_api',
			'action' => 'vimeo',
		),
		'auth_button_instagram' => array(
			'type'   => 'button',
			'title'  => esc_html__( 'Authorize', 'Monarch' ),
			'link'   => '#',
			'class'  => 'et_authorize_api',
			'action' => 'instagram',
		),
		'auth_button_linkedin' => array(
			'type'   => 'button',
			'title'  => esc_html__( 'Authorize', 'Monarch' ),
			'link'   => '#',
			'class'  => 'et_authorize_api',
			'action' => 'linkedin',
		),
		'auth_button_twitter' => array(
			'type'   => 'button',
			'title'  => esc_html__( 'Authorize', 'Monarch' ),
			'link'   => '#',
			'class'  => 'et_authorize_api et_authorize_twitter',
			'action' => 'twitter',
		),
		'auth_button_facebook' => array(
			'type'   => 'button',
			'title'  => esc_html__( 'Authorize', 'Monarch' ),
			'link'   => '#',
			'class'  => 'et_authorize_api',
			'action' => 'facebook',
		),
		'auth_button_youtube' => array(
			'type'   => 'button',
			'title'  => esc_html__( 'Authorize', 'Monarch' ),
			'link'   => '#',
			'class'  => 'et_authorize_api',
			'action' => 'youtube',
		),
	),
	'display_settings' => array(
		'section_start' => array(
			'type'  => 'section_start',
			'title' => esc_html__( 'Display Settings', 'Monarch' ),
		),
		'icons_placement' => array(
			'type'    => 'select',
			'title'   => esc_html__( 'Icon Placement', 'Monarch' ),
			'name'    => 'icons_location',
			'value'   => array(
				'top ' => esc_html__( 'Centered', 'Monarch' ),
				'left' => esc_html__( 'Left', 'Monarch' ),
			),
			'default' => 'top',
		),
		'icons_location_2' => array(
			'type'    => 'select',
			'title'   => esc_html__( 'Choose Location', 'Monarch' ),
			'name'    => 'icons_location',
			'value'   => array(
				'bottom_right' => esc_html__( 'Bottom Right', 'Monarch' ),
				'bottom_left'  => esc_html__( 'Bottom Left', 'Monarch' ),
			),
			'default' => 'bottom_right',
		),
		'icons_location_3' => array(
			'type'    => 'select',
			'title'   => esc_html__( 'Choose Location', 'Monarch' ),
			'name'    => 'icons_location',
			'value'   => array(
				'above'       => esc_html__( 'Above Content', 'Monarch' ),
				'below'       => esc_html__( 'Below Content', 'Monarch' ),
				'above_below' => esc_html__( 'Above + Below', 'Monarch' ),
			),
			'default' => 'above'
		),
		'icons_alignment' => array(
			'type'    => 'select',
			'title'   => esc_html__( 'Icon Alignment', 'Monarch' ),
			'name'    => 'icons_alignment',
			'value'   => array(
				'left' => esc_html__( 'Left', 'Monarch' ),
				'top'  => esc_html__( 'Centered', 'Monarch' ),
			),
			'default' => 'left',
		),
		'col_number_3' => array(
			'type'    => 'select',
			'title'   => esc_html__( 'Number of Columns', 'Monarch' ),
			'name'    => 'col_number',
			'value'   => array(
				'auto' => esc_html__( 'Auto Width', 'Monarch' ),
				'1'    => '1',
				'2'    => '2',
				'3'    => '3',
			),
			'default' => '2',
		),
		'col_number_4' => array(
			'type'    => 'select',
			'title'   => esc_html__( 'Choose Number of Columns', 'Monarch' ),
			'name'    => 'col_number',
			'value'   => array(
				'auto' => esc_html__( 'Auto Width', 'Monarch' ),
				'1'    => '1',
				'2'    => '2',
				'3'    => '3',
				'4'    => '4',
			),
			'default' => '2',
		),
		'col_number_6' => array(
			'type'           => 'select',
			'title'          => esc_html__( 'Number of Columns', 'Monarch' ),
			'name'           => 'col_number',
			'value'          => array(
				'auto' => esc_html__( 'Auto Width', 'Monarch' ),
				'1'    => '1',
				'2'    => '2',
				'3'    => '3',
				'4'    => '4',
				'5'    => '5',
				'6'    => '6',
			),
			'default'        => 'auto',
			'default_inline' => '4',
			'default_popup'  => '3',
		),
		'sidebar_orientation' => array(
			'type'    => 'select',
			'title'   => esc_html__( 'Sidebar Orientation', 'Monarch' ),
			'name'    => 'sidebar_orientation',
			'value'   => array(
				'left'  => esc_html__( 'Left', 'Monarch' ),
				'right' => esc_html__( 'Right', 'Monarch' ),
			),
			'default' => 'left',
		),
		'animation' => array(
			'type'            => 'select',
			'title'           => esc_html__( 'Intro Animation', 'Monarch' ),
			'name'            => 'animation',
			'value'           => array(
				'no_animation' => esc_html__( 'No Animation', 'Monarch' ),
				'fadein'       => esc_html__( 'Fade In', 'Monarch' ),
				'slideright'   => esc_html__( 'Slide Right', 'Monarch' ),
				'slideup'      => esc_html__( 'Slide Up', 'Monarch' ),
				'slidedown'    => esc_html__( 'Slide Down', 'Monarch' ),
				'slideup'      => esc_html__( 'Slide Up', 'Monarch' ),
			),
			'value_popup'  => array(
				'no_animation' => esc_html__( 'No Animation', 'Monarch' ),
				'fadein'       => esc_html__( 'Fade In', 'Monarch' ),
				'slideright'   => esc_html__( 'Slide Right', 'Monarch' ),
				'slideup'      => esc_html__( 'Slide Up', 'Monarch' ),
				'slidedown'    => esc_html__( 'Slide Down', 'Monarch' ),
				'slideup'      => esc_html__( 'Slide Up', 'Monarch' ),
				'lightspeedin' => esc_html__( 'Light Speed', 'Monarch' ),
				'zoomin'       => esc_html__( 'Zoom In', 'Monarch' ),
				'flipinx'      => esc_html__( 'Flip', 'Monarch' ),
				'bounce'       => esc_html__( 'Bounce', 'Monarch' ),
				'swing'        => esc_html__( 'Swing', 'Monarch' ),
				'tada'         => esc_html__( 'Tada!', 'Monarch' ),
			),
			'value_flyin'     => array(
				'no_animation' => esc_html__( 'No Animation', 'Monarch' ),
				'fadein'       => esc_html__( 'Fade In', 'Monarch' ),
				'slideright'   => esc_html__( 'Slide Right', 'Monarch' ),
				'slideup'      => esc_html__( 'Slide Up', 'Monarch' ),
				'slidedown'    => esc_html__( 'Slide Down', 'Monarch' ),
				'slideup'      => esc_html__( 'Slide Up', 'Monarch' ),
				'lightspeedin' => esc_html__( 'Light Speed', 'Monarch' ),
				'zoomin'       => esc_html__( 'Zoom In', 'Monarch' ),
				'flipinx'      => esc_html__( 'Flip', 'Monarch' ),
				'bounce'       => esc_html__( 'Bounce', 'Monarch' ),
				'swing'        => esc_html__( 'Swing', 'Monarch' ),
				'tada'         => esc_html__( 'Tada!', 'Monarch' ),
			),
			'hint_text'       => esc_html__( 'Define the animation that is used, when you load the page.', 'Monarch' ),
			'default'         => 'fadein',
			'default_sidebar' => 'slideright',
			'default_flyin'   => 'slideup',
		),
		'auto_popup' => array(
			'type'          => 'checkbox',
			'title'         => esc_html__( 'Trigger After Time Delay', 'Monarch' ),
			'name'          => 'auto_popup',
			'conditional'   => 'popup_delay',
			'default'       => '1',
			'default_flyin' => false,
		),
		'popup_delay' => array(
			'type'       => 'input_field',
			'subtype'    => 'number',
			'title'      => esc_html__( 'Delay ( in seconds )', 'Monarch' ),
			'name'       => 'popup_delay',
			'hint_text'  => esc_html__( 'Define how many seconds you want to wait before the pop up appears on the screen.', 'Monarch' ),
			'default'    => '20',
			'display_if' => true,
		),
		'trigger_idle' => array(
			'type'         => 'checkbox',
			'title'        => esc_html__( 'Trigger After Inactivity', 'Monarch' ),
			'name'         => 'trigger_idle',
			'default'      => false,
			'conditional'  => 'idle_timeout',
		),
		'idle_timeout' => array(
			'type'       => 'input_field',
			'subtype'    => 'number',
			'title'      => esc_html__( 'Idle Timeout ( in seconds )', 'Monarch' ),
			'name'       => 'idle_timeout',
			'hint_text'  => esc_html__( 'Define how many seconds user should be inactive before the pop up appears on screen.', 'Monarch' ),
			'default'    => '15',
			'display_if' => true,
		),
		'trigger_bottom' => array(
			'type'          => 'checkbox',
			'title'         => esc_html__( 'Trigger At The Bottom Of Post', 'Monarch' ),
			'name'          => 'trigger_bottom',
			'default'       => false,
			'default_flyin' => true,
		),
		'trigger_comment' => array(
			'type'  => 'checkbox',
			'title' => esc_html__( 'Trigger After Commenting', 'Monarch' ),
			'name'  => 'trigger_comment',
		),
		'scroll_trigger' => array(
			'type'        => 'checkbox',
			'title'       => esc_html__( 'Trigger After Scrolling', 'Monarch' ),
			'name'        => 'scroll_trigger',
			'conditional' => 'scroll_pos',
			'default'     => false,
		),
		'scroll_pos' => array(
			'type'       => 'input_field',
			'subtype'    => 'number',
			'title'      => esc_html__( 'Percentage Down The Page', 'Monarch' ),
			'name'       => 'scroll_pos',
			'hint_text'  => esc_html__( 'Define the % of the page to be scrolled before the pop up appears on the screen.', 'Monarch' ),
			'default'    => '50',
			'display_if' => true,
		),
		'trigger_purchase' => array(
			'type'      => 'checkbox',
			'title'     => esc_html__( 'Trigger After Purchasing', 'Monarch' ),
			'name'      => 'trigger_purchase',
			'hint_text' => esc_html__( 'Display on "Thank you" page of WooCommerce after purchase', 'Monarch' ),
			'default'   => false,
		),
		'counts' => array(
			'type'              => 'checkbox',
			'title'             => esc_html__( 'Display Share Counts', 'Monarch' ),
			'title_widget'      => esc_html__( 'Display Follower Counts', 'Monarch' ),
			'title_shortcode'   => esc_html__( 'Display Follower Counts', 'Monarch' ),
			'name'              => 'counts',
			'conditional'       => 'counts_num',
			'conditional_2'     => 'outer_color',
			'default'           => false,
			'default_inline'    => '1',
			'default_popup'     => '1',
			'default_widget'    => '1',
			'default_shortcode' => '1',
		),
		'counts_num' => array(
			'type'       => 'input_field',
			'subtype'    => 'number',
			'title'      => esc_html__( 'Minimum Count Display', 'Monarch' ),
			'name'       => 'counts_num',
			'hint_text'  => esc_html__( 'Threshold that must be reached for each network before a number is displayed.', 'Monarch' ),
			'default'    => '0',
			'display_if' => true,
		),
		'total' => array(
			'type'              => 'checkbox',
			'title'             => esc_html__( 'Display Total Shares', 'Monarch' ),
			'title_widget'      => esc_html__( 'Display Total Followers', 'Monarch' ),
			'title_shortcode'   => esc_html__( 'Display Total Followers', 'Monarch' ),
			'name'              => 'total',
			'conditional'       => 'total_color',
			'conditional_2'     => 'outer_color',
			'default'           => false,
			'default_widget'    => '1',
			'default_shortcode' => '1',
		),
		'total_color' => array(
			'type'       => 'select',
			'title'      => esc_html__( 'Total Shares Text Color', 'Monarch' ),
			'name'       => 'total_color',
			'value'      => array(
				'dark'  => esc_html__( 'Dark', 'Monarch' ),
				'light' => esc_html__( 'Light', 'Monarch' ),
			),
			'hint_text'  => esc_html__( 'Choose what color the Total Shares Text should be, depending on the background color of your website.' ),
			'default'    => 'dark',
			'display_if' => true,
		),
		'outer_color' => array(
			'type'       => 'select',
			'title'      => esc_html__( 'Outer Text Color', 'Monarch' ),
			'name'       => 'outer_color',
			'value'      => array(
				'dark'  => esc_html__( 'Dark', 'Monarch' ),
				'light' => esc_html__( 'Light', 'Monarch' ),
			),
			'hint_text'  => esc_html__( 'This color setting only applies to the total count, and network names/counts ( when circle buttons are used )', 'Monarch' ),
			'default'    => 'dark',
			'display_if' => true,
		),
		'network_names' => array(
			'type'        => 'checkbox',
			'title'       => esc_html__( 'Display Network Names', 'Monarch' ),
			'name'        => 'network_names',
			'default'     => '1',
			'conditional' => 'outer_color',
		),
		'display_all' => array(
			'type'      => 'checkbox',
			'title'     => esc_html__( "Display 'All Networks' Button" , 'Monarch' ),
			'name'      => 'display_all',
			'hint_text' => esc_html__( 'This button allows users to select and share from all available social networks.', 'Monarch' ),
			'default'   => false,
		),
		'spacing' => array(
			'type'    => 'checkbox',
			'title'   => esc_html__( 'Add Icon Spacing', 'Monarch' ),
			'name'    => 'spacing',
			'default' => false,
		),
		'no_spacing' => array(
			'type'    => 'checkbox',
			'title'   => esc_html__( 'Remove Icon Spacing', 'Monarch' ),
			'name'    => 'spacing',
			'default' => false,
		),
		'mobile' => array(
			'type'    => 'checkbox',
			'title'   => esc_html__( 'Hide On Mobile Devices', 'Monarch' ),
			'name'    => 'mobile',
			'default' => false,
		),
		'cookies' => array(
			'type'        => 'checkbox',
			'title'       => esc_html__( 'Display Once Per Session', 'Monarch' ),
			'name'        => 'cookies',
			'conditional' => 'cookie_duration',
			'default'     => false,
		),
		'cookie_duration' => array(
			'type'       => 'input_field',
			'subtype'    => 'number',
			'title'      => esc_html__( 'Session Duration (in days)', 'Monarch' ),
			'name'       => 'cookie_duration',
			'hint_text'  => esc_html__( "Define the length of time (in days) that a session lasts for. For example, if you input 2 a user will only see a popup on your site every two days.", 'Monarch' ),
			'default'    => '1',
			'display_if' => true,
		),
		'use_api' => array(
			'type'        => 'checkbox',
			'title'       => esc_html__( 'Get counts via API', 'Monarch' ),
			'name'        => 'use_api',
			'hint_text'   => esc_html__( 'if disabled, then manually specified values will be displayed', 'Monarch' ),
			'conditional' => 'follow_api',
			'default'     => false,
			'class'       => 'et_social_api_trigger',
		),
		'new_window' => array(
			'type'      => 'checkbox',
			'title'     => esc_html__( 'Open link in new window', 'Monarch' ),
			'name'      => 'new_window',
			'hint_text' => esc_html__( 'Disable this option if you do not want to open Follow links in new window', 'Monarch' ),
			'default'   => '1',
		),
	),
	'general_settings' => array(
		'section_start' => array(
			'type' => 'section_start',
		),
		'update_freq' => array(
			'type'      => 'input_field',
			'subtype'   => 'number',
			'title'     => esc_html__( 'Frequency of count updates (in hours)', 'Monarch' ),
			'name'      => 'update_freq',
			'hint_text' => esc_html__( "Adjust how often the plugin grabs and caches the counts from social networks that support APIs. Set to 0 if you don't want to use cache.", 'Monarch' ),
			'default'   => '3',
		),
		'reset_postdata' =>  array(
			'type'      => 'checkbox',
			'title'     => esc_html__( 'Reset WordPress loops', 'Monarch' ),
			'name'      => 'reset_postdata',
			'hint_text' => esc_html__( 'Enable the option if the plugin does not detect permalinks properly', 'Monarch' ),
			'default'   => false,
		),
	),

	'custom_css' => array(
		'section_start' => array(
			'type'  => 'section_start',
			'title' => esc_html__( 'Custom CSS', 'Monarch' ),
		),
		'option' => array(
			'type'        => 'text',
			'rows'        => '7',
			'name'        => 'custom_css',
			'placeholder' => esc_html__( 'insert your custom CSS code', 'Monarch' ),
			'default'     => '',
		),
	),
	'color_settings' =>array(
		'section_start' => array(
			'type'     => 'section_start',
			'title'    => esc_html__( 'Color Settings', 'Monarch' ),
			'subtitle' => esc_html__( 'If Background or Hover Background is not defined below, the default network colors will be used for that element.', 'Monarch' ),
		),
		'custom_colors' => array(
			'type'    => 'checkbox',
			'title'   => esc_html__( 'Use Custom Colors', 'Monarch' ),
			'name'    => 'custom_colors',
			'default' => false,
		),
		'bg_color' => array(
			'type'        => 'color_picker',
			'title'       => esc_html__( 'Background Color', 'Monarch' ),
			'name'        => 'bg_color',
			'placeholder' => esc_html__( 'Hex Value', 'Monarch' ),
			'default'     => '',
		),
		'bg_color_hover' => array(
			'type'        => 'color_picker',
			'title'       => esc_html__( 'Hover Background Color', 'Monarch' ),
			'name'        => 'bg_color_hover',
			'placeholder' => esc_html__( 'Hex Value', 'Monarch' ),
			'default'     => '',
		),
		'icon_color' => array(
			'type'        => 'color_picker',
			'title'       => esc_html__( 'Icon Color', 'Monarch' ),
			'name'        => 'icon_color',
			'placeholder' => esc_html__( 'Hex Value', 'Monarch' ),
			'default'     => '',
		),
		'icon_color_hover' => array(
			'type'        => 'color_picker',
			'title'       => esc_html__( 'Hover Icon Color', 'Monarch' ),
			'name'        => 'icon_color_hover',
			'placeholder' => esc_html__( 'Hex Value', 'Monarch' ),
			'default'     => '',
		),
	),
	'post_types' => array(
		array(
			'type'  => 'section_start',
			'title' => esc_html__( 'Post Type Settings', 'Monarch' ),
		),
		array(
			'type'            => 'checkbox_posts',
			'title'           => esc_html__( 'Post Type Settings', 'Monarch' ),
			'name'            => 'post_types',
			'include_home'    => true,
			'default'         => array( 'post' ),
			'default_sidebar' => array( 'post', 'page' ),
		),
		array(
			'type'         => 'checkbox_posts',
			'title'        => esc_html__( 'Post Type Settings', 'Monarch' ),
			'name'         => 'post_types',
			'include_home' => false,
			'value'        => array( 'post', 'product' ),
			'default'      => array( 'post' ),
		),
	),
	'sorting_share' => array(
		'type'        => 'sorting',
		'name'        => 'networks_sorting',
		'value'       => array(
			'facebook'      => esc_html__( 'Facebook', 'Monarch' ),
			'twitter'       => esc_html__( 'Twitter', 'Monarch' ),
			'googleplus'    => esc_html__( 'Google+', 'Monarch' ),
			'buffer'        => esc_html__( 'Buffer', 'Monarch' ),
			'digg'          => esc_html__( 'Digg', 'Monarch' ),
			'evernote'      => esc_html__( 'Evernote', 'Monarch' ),
			'pinterest'     => esc_html__( 'Pinterest', 'Monarch' ),
			'friendfeed'    => esc_html__( 'FriendFeed', 'Monarch' ),
			'hackernews'    => esc_html__( 'Hacker News', 'Monarch' ),
			'livejournal'   => esc_html__( 'LiveJournal', 'Monarch' ),
			'newsvine'      => esc_html__( 'Newsvine', 'Monarch' ),
			'aol'           => esc_html__( 'AOL', 'Monarch' ),
			'gmail'         => esc_html__( 'Gmail', 'Monarch' ),
			'printfriendly' => esc_html__( 'Print Friendly', 'Monarch' ),
			'yahoomail'     => esc_html__( 'Yahoo Mail', 'Monarch' ),
			'amazon'        => esc_html__( 'Amazon', 'Monarch' ),
			'delicious'     => esc_html__( 'Delicious', 'Monarch' ),
			'reddit'        => esc_html__( 'reddit', 'Monarch' ),
			'vkontakte'     => esc_html__( 'VKontakte', 'Monarch' ),
			'linkedin'      => esc_html__( 'LinkedIn', 'Monarch' ),
			'myspace'       => esc_html__( 'Myspace', 'Monarch' ),
			'blogger'       => esc_html__( 'Blogger', 'Monarch' ),
			'stumbleupon'   => esc_html__( 'StumbleUpon', 'Monarch' ),
			'tumblr'        => esc_html__( 'Tumblr', 'Monarch' ),
			'like'          => esc_html__( 'Like', 'Monarch' ),
		),
		'placeholder' => esc_html__( 'username', 'Monarch' ),
		'default'     => array(),
	),
	'sorting_follow' => array(
		'type'        => 'sorting',
		'name'        => 'networks_sorting',
		'value'       => array(
			'facebook'    => esc_html__( 'Facebook', 'Monarch' ),
			'twitter'     => esc_html__( 'Twitter', 'Monarch' ),
			'googleplus'  => esc_html__( 'Google+', 'Monarch' ),
			'buffer'      => esc_html__( 'Buffer', 'Monarch' ),
			'pinterest'   => esc_html__( 'Pinterest', 'Monarch' ),
			'rss'         => esc_html__( 'RSS', 'Monarch' ),
			'behance'     => esc_html__( 'Behance', 'Monarch' ),
			'aweber'      => esc_html__( 'AWeber', 'Monarch' ),
			'blinklist'   => esc_html__( 'BlinkList', 'Monarch' ),
			'github'      => esc_html__( 'GitHub', 'Monarch' ),
			'mailchimp'   => esc_html__( 'MailChimp', 'Monarch' ),
			'outlook'     => esc_html__( 'Outlook', 'Monarch' ),
			'soundcloud'  => esc_html__( 'SoundCloud', 'Monarch' ),
			'baidu'       => esc_html__( 'Baidu', 'Monarch' ),
			'box'         => esc_html__( 'Box', 'Monarch' ),
			'digg'        => esc_html__( 'Digg', 'Monarch' ),
			'evernote'    => esc_html__( 'Evernote', 'Monarch' ),
			'friendfeed'  => esc_html__( 'FriendFeed', 'Monarch' ),
			'hackernews'  => esc_html__( 'Hacker News', 'Monarch' ),
			'livejournal' => esc_html__( 'LiveJournal', 'Monarch' ),
			'newsvine'    => esc_html__( 'Newsvine', 'Monarch' ),
			'reddit'      => esc_html__( 'reddit', 'Monarch' ),
			'vkontakte'   => esc_html__( 'VKontakte', 'Monarch' ),
			'youtube'     => esc_html__( 'YouTube', 'Monarch' ),
			'amazon'      => esc_html__( 'Amazon', 'Monarch' ),
			'delicious'   => esc_html__( 'Delicious', 'Monarch' ),
			'instagram'   => esc_html__( 'Instagram', 'Monarch' ),
			'linkedin'    => esc_html__( 'LinkedIn', 'Monarch' ),
			'myspace'     => esc_html__( 'Myspace', 'Monarch' ),
			'picassa'     => esc_html__( 'Picasa', 'Monarch' ),
			'spotify'     => esc_html__( 'Spotify', 'Monarch' ),
			'yahoo'       => esc_html__( 'Yahoo', 'Monarch' ),
			'deviantart'  => esc_html__( 'deviantART', 'Monarch' ),
			'dribbble'    => esc_html__( 'Dribbble', 'Monarch' ),
			'flickr'      => esc_html__( 'Flickr', 'Monarch' ),
			'stumbleupon' => esc_html__( 'StumbleUpon', 'Monarch' ),
			'tumblr'      => esc_html__( 'Tumblr', 'Monarch' ),
			'vimeo'       => esc_html__( 'Vimeo', 'Monarch' ),
			'like'        => esc_html__( 'Like', 'Monarch' ) ),
		'placeholder' => 'http://',
		'default'     => array(),
	),
	'manage_locations' => array(
		'type'    => 'multi_select',
		'name'    => 'manage_locations',
		'value'   => array(
			'sidebar' => esc_html__( 'Sidebar', 'Monarch' ),
			'inline'  => esc_html__( 'Inline', 'Monarch' ),
			'popup'   => esc_html__( 'Pop Up', 'Monarch' ),
			'flyin'   => esc_html__( 'Fly In', 'Monarch' ),
			'media'   => esc_html__( 'Media', 'Monarch' ) ),
		'default' => array( 'sidebar' ),
	),
	'shortcode_option' => array(
		'type'        => 'shortcode',
		'button_text' => esc_html__( 'Generate Shortcode', 'Monarch' ),
		'name'        => 'shortcode',
		'placeholder' => esc_html__( 'Click the button above to generate your shortcode here', 'Monarch' ),
		'default'     => '',
	),
	'end_of_section' => array(
		'type' => 'section_end',
	),
	'end_of_sub_section' => array(
		'type'        => 'section_end',
		'sub_section' => 'true',
	),
	'locations_title' => array(
		'type'     => 'main_title',
		'title'    => esc_html__( 'Manage Locations', 'Monarch' ),
		'subtitle' => esc_html__( 'You can select any combination of the five placements below.', 'Monarch' ),
	),
	'networks_title' => array(
		'type'     => 'main_title',
		'title'    => esc_html__( 'Manage Networks', 'Monarch' ),
		'subtitle' => esc_html__( 'Add and rearrange any combination of social networks below. You can define the Network Label and Username to the right of each.', 'Monarch' ),
	),
	'sidebar_title' => array(
		'type'  => 'main_title',
		'title' => esc_html__( 'Configure sidebar share icons', 'Monarch' ),
	),
	'inline_title' => array(
		'type'  => 'main_title',
		'title' => esc_html__( 'Configure inline share icons', 'Monarch' ),
	),
	'popup_title' => array(
		'type'  => 'main_title',
		'title' => esc_html__( 'Configure social sharing pop up', 'Monarch' ),
	),
	'flyin_title' => array(
		'type'  => 'main_title',
		'title' => esc_html__( 'Configure social sharing flyin', 'Monarch' ),
	),
	'media_title' => array(
		'type'     => 'main_title',
		'title'    => esc_html__( 'Configure media sharing icons', 'Monarch' ),
		'subtitle' => esc_html__( 'Media sharing is only applied to blog post content.', 'Monarch' ),
	),
	'widget_title' => array(
		'type'     => 'main_title',
		'title'    => esc_html__( 'Configure social follow widget', 'Monarch' ),
		'subtitle' => esc_html__( 'Any Monarch widget added to a widget area will use the following settings.', 'Monarch' ),
	),
	'shortcode_title' => array(
		'type'     => 'main_title',
		'title'    => esc_html__( 'Configure social follow shortcode', 'Monarch' ),
		'subtitle' => esc_html__( 'Define settings and generate a unique shortcode below', 'Monarch' ),
	),
	'general_title' => array(
		'type'  => 'main_title',
		'title' => esc_html__( 'Configure general settings', 'Monarch' ),
	),
	'locations_note' => array(
		'type' => 'note',
		'text' => esc_html__( 'Selected locations will use the display settings defined from the menu on the left.', 'Monarch' ),
	),
	'networks_note' => array(
		'type' => 'note',
		'text' => esc_html__( 'Selected networks apply to all selected locations in "Locations" Settings.', 'Monarch' ),
	),
	'follow_location_note' => array(
		'type' => 'note',
		'text' => esc_html__( 'Selected networks apply to all widgets and shortcodes defined in the menu on the left.', 'Monarch' ),
	),
	'import_export' => array(
		'type'  => 'import_export',
		'title' => esc_html__( 'Import/Export', 'Monarch' ),
	),
	'stats' => array(
		'type'  => 'stats',
		'title' => esc_html__( 'Social Sharing Stats', 'Monarch' ),
	),
	'updates' => array(
		'type'  => 'updates',
		'title' => esc_html__( 'Monarch Updates', 'Monarch' ),
	),
);

$sharing_locations_options = array(
	$monarch_options_all[ 'locations_title' ],
	$monarch_options_all[ 'manage_locations' ],
	$monarch_options_all[ 'locations_note' ],
);

$sharing_networks_options = array(
	$monarch_options_all[ 'networks_title' ],
	$monarch_options_all[ 'sorting_share' ],
	$monarch_options_all[ 'networks_note' ],
);

$sharing_sidebar_options = array(
	$monarch_options_all[ 'sidebar_title' ],
	$monarch_options_all[ 'icon_style_sidebar' ],
	$monarch_options_all[ 'icon_shape' ],
	$monarch_options_all[ 'display_settings' ][ 'section_start' ],
		$monarch_options_all[ 'display_settings' ][ 'sidebar_orientation' ],
		$monarch_options_all[ 'display_settings' ][ 'animation' ],
		$monarch_options_all[ 'display_settings' ][ 'counts' ],
		$monarch_options_all[ 'display_settings' ][ 'counts_num' ],
		$monarch_options_all[ 'display_settings' ][ 'total' ],
		$monarch_options_all[ 'display_settings' ][ 'total_color' ],
		$monarch_options_all[ 'display_settings' ][ 'display_all' ],
		$monarch_options_all[ 'display_settings' ][ 'spacing' ],
		$monarch_options_all[ 'display_settings' ][ 'mobile' ],
		$monarch_options_all[ 'end_of_section' ],
	$monarch_options_all[ 'color_settings' ][ 'section_start' ],
		$monarch_options_all[ 'color_settings' ][ 'custom_colors' ],
		$monarch_options_all[ 'color_settings' ][ 'bg_color' ],
		$monarch_options_all[ 'color_settings' ][ 'bg_color_hover' ],
		$monarch_options_all[ 'color_settings' ][ 'icon_color' ],
		$monarch_options_all[ 'color_settings' ][ 'icon_color_hover' ],
		$monarch_options_all[ 'end_of_section' ],
	$monarch_options_all[ 'post_types' ][ 0 ],
		$monarch_options_all[ 'post_types' ][ 1 ],
		$monarch_options_all[ 'end_of_section' ],
);

$sharing_inline_options = array(
	$monarch_options_all[ 'inline_title' ],
	$monarch_options_all[ 'icon_style' ],
	$monarch_options_all[ 'icon_shape' ],
	$monarch_options_all[ 'display_settings' ][ 'section_start' ],
		$monarch_options_all[ 'display_settings' ][ 'icons_location_3' ],
		$monarch_options_all[ 'display_settings' ][ 'icons_alignment' ],
		$monarch_options_all[ 'display_settings' ][ 'col_number_6' ],
		$monarch_options_all[ 'display_settings' ][ 'counts' ],
		$monarch_options_all[ 'display_settings' ][ 'counts_num' ],
		$monarch_options_all[ 'display_settings' ][ 'total' ],
		$monarch_options_all[ 'display_settings' ][ 'network_names' ],
		$monarch_options_all[ 'display_settings' ][ 'display_all' ],
		$monarch_options_all[ 'display_settings' ][ 'outer_color' ],
		$monarch_options_all[ 'display_settings' ][ 'no_spacing' ],
		$monarch_options_all[ 'display_settings' ][ 'mobile' ],
		$monarch_options_all[ 'end_of_section' ],
	$monarch_options_all[ 'color_settings' ][ 'section_start' ],
		$monarch_options_all[ 'color_settings' ][ 'custom_colors' ],
		$monarch_options_all[ 'color_settings' ][ 'bg_color' ],
		$monarch_options_all[ 'color_settings' ][ 'bg_color_hover' ],
		$monarch_options_all[ 'color_settings' ][ 'icon_color' ],
		$monarch_options_all[ 'color_settings' ][ 'icon_color_hover' ],
		$monarch_options_all[ 'end_of_section' ],
	$monarch_options_all[ 'post_types' ][ 0 ],
		$monarch_options_all[ 'post_types' ][ 1 ],
		$monarch_options_all[ 'end_of_section' ],
);

$sharing_popup_options = array(
	$monarch_options_all[ 'popup_title' ],
	$monarch_options_all[ 'icon_style' ],
	$monarch_options_all[ 'icon_shape' ],
	$monarch_options_all[ 'title_text' ][ 'section_start' ],
		$monarch_options_all[ 'title_text' ][ 'option' ],
		$monarch_options_all[ 'end_of_section' ],
	$monarch_options_all[ 'message_text' ][ 'section_start' ],
		$monarch_options_all[ 'message_text' ][ 'option' ],
		$monarch_options_all[ 'end_of_section' ],
	$monarch_options_all[ 'display_settings' ][ 'section_start' ],
		$monarch_options_all[ 'display_settings' ][ 'icons_alignment' ],
		$monarch_options_all[ 'display_settings' ][ 'col_number_6' ],
		$monarch_options_all[ 'display_settings' ][ 'animation' ],
		$monarch_options_all[ 'display_settings' ][ 'auto_popup' ],
		$monarch_options_all[ 'display_settings' ][ 'popup_delay' ],
		$monarch_options_all[ 'display_settings' ][ 'trigger_idle' ],
		$monarch_options_all[ 'display_settings' ][ 'idle_timeout' ],
		$monarch_options_all[ 'display_settings' ][ 'trigger_bottom' ],
		$monarch_options_all[ 'display_settings' ][ 'trigger_comment' ],
		$monarch_options_all[ 'display_settings' ][ 'scroll_trigger' ],
		$monarch_options_all[ 'display_settings' ][ 'scroll_pos' ],
		$monarch_options_all[ 'display_settings' ][ 'trigger_purchase' ],
		$monarch_options_all[ 'display_settings' ][ 'cookies' ],
		$monarch_options_all[ 'display_settings' ][ 'cookie_duration' ],
		$monarch_options_all[ 'display_settings' ][ 'counts' ],
		$monarch_options_all[ 'display_settings' ][ 'counts_num' ],
		$monarch_options_all[ 'display_settings' ][ 'total' ],
		$monarch_options_all[ 'display_settings' ][ 'network_names' ],
		$monarch_options_all[ 'display_settings' ][ 'display_all' ],
		$monarch_options_all[ 'display_settings' ][ 'no_spacing' ],
		$monarch_options_all[ 'display_settings' ][ 'mobile' ],
		$monarch_options_all[ 'end_of_section' ],
	$monarch_options_all[ 'color_settings' ][ 'section_start' ],
		$monarch_options_all[ 'color_settings' ][ 'custom_colors' ],
		$monarch_options_all[ 'color_settings' ][ 'bg_color' ],
		$monarch_options_all[ 'color_settings' ][ 'bg_color_hover' ],
		$monarch_options_all[ 'color_settings' ][ 'icon_color' ],
		$monarch_options_all[ 'color_settings' ][ 'icon_color_hover' ],
		$monarch_options_all[ 'end_of_section' ],
	$monarch_options_all[ 'post_types' ][ 0 ],
		$monarch_options_all[ 'post_types' ][ 1 ],
		$monarch_options_all[ 'end_of_section' ],
);

$sharing_flyin_options = array(
	$monarch_options_all[ 'flyin_title' ],
	$monarch_options_all[ 'icon_style' ],
	$monarch_options_all[ 'icon_shape' ],
	$monarch_options_all[ 'title_text' ][ 'section_start' ],
		$monarch_options_all[ 'title_text' ][ 'option' ],
		$monarch_options_all[ 'end_of_section' ],
	$monarch_options_all[ 'message_text' ][ 'section_start' ],
		$monarch_options_all[ 'message_text' ][ 'option' ],
		$monarch_options_all[ 'end_of_section' ],
	$monarch_options_all[ 'display_settings' ][ 'section_start' ],
		$monarch_options_all[ 'display_settings' ][ 'icons_location_2' ],
		$monarch_options_all[ 'display_settings' ][ 'icons_alignment' ],
		$monarch_options_all[ 'display_settings' ][ 'col_number_3' ],
		$monarch_options_all[ 'display_settings' ][ 'animation' ],
		$monarch_options_all[ 'display_settings' ][ 'auto_popup' ],
		$monarch_options_all[ 'display_settings' ][ 'popup_delay' ],
		$monarch_options_all[ 'display_settings' ][ 'trigger_idle' ],
		$monarch_options_all[ 'display_settings' ][ 'idle_timeout' ],
		$monarch_options_all[ 'display_settings' ][ 'trigger_bottom' ],
		$monarch_options_all[ 'display_settings' ][ 'trigger_comment' ],
		$monarch_options_all[ 'display_settings' ][ 'scroll_trigger' ],
		$monarch_options_all[ 'display_settings' ][ 'scroll_pos' ],
		$monarch_options_all[ 'display_settings' ][ 'trigger_purchase' ],
		$monarch_options_all[ 'display_settings' ][ 'cookies' ],
		$monarch_options_all[ 'display_settings' ][ 'cookie_duration' ],
		$monarch_options_all[ 'display_settings' ][ 'counts' ],
		$monarch_options_all[ 'display_settings' ][ 'counts_num' ],
		$monarch_options_all[ 'display_settings' ][ 'total' ],
		$monarch_options_all[ 'display_settings' ][ 'network_names' ],
		$monarch_options_all[ 'display_settings' ][ 'display_all' ],
		$monarch_options_all[ 'display_settings' ][ 'no_spacing' ],
		$monarch_options_all[ 'display_settings' ][ 'mobile' ],
		$monarch_options_all[ 'end_of_section' ],
	$monarch_options_all[ 'color_settings' ][ 'section_start' ],
		$monarch_options_all[ 'color_settings' ][ 'custom_colors' ],
		$monarch_options_all[ 'color_settings' ][ 'bg_color' ],
		$monarch_options_all[ 'color_settings' ][ 'bg_color_hover' ],
		$monarch_options_all[ 'color_settings' ][ 'icon_color' ],
		$monarch_options_all[ 'color_settings' ][ 'icon_color_hover' ],
		$monarch_options_all[ 'end_of_section' ],
	$monarch_options_all[ 'post_types' ][ 0 ],
		$monarch_options_all[ 'post_types' ][ 1 ],
		$monarch_options_all[ 'end_of_section' ],
);

$sharing_media_options = array(
	$monarch_options_all[ 'media_title' ],
	$monarch_options_all[ 'icon_style' ],
	$monarch_options_all[ 'icon_shape' ],
	$monarch_options_all[ 'display_settings' ][ 'section_start' ],
		$monarch_options_all[ 'display_settings' ][ 'icons_alignment' ],
		$monarch_options_all[ 'display_settings' ][ 'col_number_6' ],
		$monarch_options_all[ 'display_settings' ][ 'counts' ],
		$monarch_options_all[ 'display_settings' ][ 'counts_num' ],
		$monarch_options_all[ 'display_settings' ][ 'total' ],
		$monarch_options_all[ 'display_settings' ][ 'network_names' ],
		$monarch_options_all[ 'display_settings' ][ 'display_all' ],
		$monarch_options_all[ 'display_settings' ][ 'outer_color' ],
		$monarch_options_all[ 'display_settings' ][ 'no_spacing' ],
		$monarch_options_all[ 'display_settings' ][ 'mobile' ],
		$monarch_options_all[ 'end_of_section' ],
	$monarch_options_all[ 'color_settings' ][ 'section_start' ],
		$monarch_options_all[ 'color_settings' ][ 'custom_colors' ],
		$monarch_options_all[ 'color_settings' ][ 'bg_color' ],
		$monarch_options_all[ 'color_settings' ][ 'bg_color_hover' ],
		$monarch_options_all[ 'color_settings' ][ 'icon_color' ],
		$monarch_options_all[ 'color_settings' ][ 'icon_color_hover' ],
		$monarch_options_all[ 'end_of_section' ],
	$monarch_options_all[ 'post_types' ][ 0 ],
		$monarch_options_all[ 'post_types' ][ 2 ],
		$monarch_options_all[ 'end_of_section' ],
);

$follow_networks_options = array(
	$monarch_options_all[ 'networks_title' ],
	$monarch_options_all[ 'sorting_follow' ],
	$monarch_options_all[ 'display_settings' ][ 'section_start' ],
		$monarch_options_all[ 'display_settings' ][ 'new_window' ],
		$monarch_options_all[ 'display_settings' ][ 'use_api' ],
		$monarch_options_all[ 'end_of_section' ],
	$monarch_options_all[ 'api_settings' ][ 'section_start' ],
		$monarch_options_all[ 'api_settings' ][ 'sub_section_vimeo' ],
			$monarch_options_all[ 'api_settings' ][ 'option_vimeo_1' ],
			$monarch_options_all[ 'api_settings' ][ 'option_vimeo_2' ],
			$monarch_options_all[ 'api_settings' ][ 'auth_button_vimeo' ],
		$monarch_options_all[ 'end_of_sub_section' ],
		$monarch_options_all[ 'api_settings' ][ 'sub_section_instagram' ],
			$monarch_options_all[ 'api_settings' ][ 'option_instagram_1' ],
			$monarch_options_all[ 'api_settings' ][ 'option_instagram_2' ],
			$monarch_options_all[ 'api_settings' ][ 'auth_button_instagram' ],
		$monarch_options_all[ 'end_of_sub_section' ],
		$monarch_options_all[ 'api_settings' ][ 'sub_section_linkedin' ],
			$monarch_options_all[ 'api_settings' ][ 'option_linkedin_1' ],
			$monarch_options_all[ 'api_settings' ][ 'option_linkedin_2' ],
			$monarch_options_all[ 'api_settings' ][ 'auth_button_linkedin' ],
		$monarch_options_all[ 'end_of_sub_section' ],
		$monarch_options_all[ 'api_settings' ][ 'sub_section_twitter' ],
			$monarch_options_all[ 'api_settings' ][ 'option_twitter_1' ],
			$monarch_options_all[ 'api_settings' ][ 'option_twitter_2' ],
			$monarch_options_all[ 'api_settings' ][ 'option_twitter_3' ],
			$monarch_options_all[ 'api_settings' ][ 'option_twitter_4' ],
			$monarch_options_all[ 'api_settings' ][ 'auth_button_twitter' ],
		$monarch_options_all[ 'end_of_sub_section' ],
		$monarch_options_all[ 'api_settings' ][ 'sub_section_youtube' ],
			$monarch_options_all[ 'api_settings' ][ 'option_youtube_1' ],
			$monarch_options_all[ 'api_settings' ][ 'auth_button_youtube' ],
		$monarch_options_all[ 'end_of_sub_section' ],
	$monarch_options_all[ 'end_of_section' ],
	$monarch_options_all[ 'follow_location_note' ],
);

$follow_widget_options = array(
	$monarch_options_all[ 'widget_title' ],
	$monarch_options_all[ 'icon_style' ],
	$monarch_options_all[ 'icon_shape' ],
	$monarch_options_all[ 'display_settings' ][ 'section_start' ],
		$monarch_options_all[ 'display_settings' ][ 'icons_placement' ],
		$monarch_options_all[ 'display_settings' ][ 'col_number_4' ],
		$monarch_options_all[ 'display_settings' ][ 'counts' ],
		$monarch_options_all[ 'display_settings' ][ 'counts_num' ],
		$monarch_options_all[ 'display_settings' ][ 'total' ],
		$monarch_options_all[ 'display_settings' ][ 'network_names' ],
		$monarch_options_all[ 'display_settings' ][ 'outer_color' ],
		$monarch_options_all[ 'display_settings' ][ 'no_spacing' ],
		$monarch_options_all[ 'display_settings' ][ 'mobile' ],
		$monarch_options_all[ 'end_of_section' ],
	$monarch_options_all[ 'color_settings' ][ 'section_start' ],
		$monarch_options_all[ 'color_settings' ][ 'custom_colors' ],
		$monarch_options_all[ 'color_settings' ][ 'bg_color' ],
		$monarch_options_all[ 'color_settings' ][ 'bg_color_hover' ],
		$monarch_options_all[ 'color_settings' ][ 'icon_color' ],
		$monarch_options_all[ 'color_settings' ][ 'icon_color_hover' ],
		$monarch_options_all[ 'end_of_section' ],
);

$follow_shortcode_options = array(
	$monarch_options_all[ 'shortcode_title' ],
	$monarch_options_all[ 'icon_style' ],
	$monarch_options_all[ 'icon_shape' ],
	$monarch_options_all[ 'display_settings' ][ 'section_start' ],
		$monarch_options_all[ 'display_settings' ][ 'icons_placement' ],
		$monarch_options_all[ 'display_settings' ][ 'col_number_6' ],
		$monarch_options_all[ 'display_settings' ][ 'counts' ],
		$monarch_options_all[ 'display_settings' ][ 'counts_num' ],
		$monarch_options_all[ 'display_settings' ][ 'total' ],
		$monarch_options_all[ 'display_settings' ][ 'network_names' ],
		$monarch_options_all[ 'display_settings' ][ 'outer_color' ],
		$monarch_options_all[ 'display_settings' ][ 'no_spacing' ],
		$monarch_options_all[ 'display_settings' ][ 'mobile' ],
		$monarch_options_all[ 'end_of_section' ],
	$monarch_options_all[ 'color_settings' ][ 'section_start' ],
		$monarch_options_all[ 'color_settings' ][ 'custom_colors' ],
		$monarch_options_all[ 'color_settings' ][ 'bg_color' ],
		$monarch_options_all[ 'color_settings' ][ 'bg_color_hover' ],
		$monarch_options_all[ 'color_settings' ][ 'icon_color' ],
		$monarch_options_all[ 'color_settings' ][ 'icon_color_hover' ],
		$monarch_options_all[ 'end_of_section' ],
	$monarch_options_all[ 'shortcode_option' ],
);

$general_main_options = array(
	$monarch_options_all[ 'general_title' ],
	$monarch_options_all[ 'general_settings' ][ 'section_start' ],
			$monarch_options_all[ 'general_settings' ][ 'update_freq' ],
			$monarch_options_all[ 'general_settings' ][ 'reset_postdata' ],
			$monarch_options_all[ 'end_of_section' ],
	$monarch_options_all[ 'api_settings' ][ 'section_start_general' ],
		$monarch_options_all[ 'api_settings' ][ 'sub_section_facebook' ],
				$monarch_options_all[ 'api_settings' ][ 'option_facebook_1' ],
				$monarch_options_all[ 'api_settings' ][ 'option_facebook_2' ],
				$monarch_options_all[ 'api_settings' ][ 'auth_button_facebook' ],
			$monarch_options_all[ 'end_of_sub_section' ],
		$monarch_options_all[ 'end_of_section' ],
	$monarch_options_all[ 'custom_css' ][ 'section_start' ],
			$monarch_options_all[ 'custom_css' ][ 'option' ],
			$monarch_options_all[ 'end_of_section' ],
);

$header_updates_options = array(
	$monarch_options_all[ 'updates' ]
);

$header_importexport_options = array(
	$monarch_options_all[ 'import_export' ]
);

$header_stats_options = array(
	$monarch_options_all[ 'stats' ]
);