<?php
	namespace Elementor;

	if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

	add_action( 'elementor/init','Elementor\chords_elements_init' );
	function chords_elements_init() {
		Plugin::instance()->elements_manager->add_category(
			'chords-elements',
			[
				'title'  => __( 'Chords Elements', 'ci_theme' ),
				'icon' => 'font',
			],
			1
		);
	}

	add_action( 'elementor/widgets/widgets_registered', 'Elementor\add_chords_elements' );
	function add_chords_elements() {
		class Widget_Post_Type extends Widget_Base {

			public function get_name() {
				return 'post_type_widget';
			}

			public function get_title() {
				return __( 'Chords Post Type', 'ci_theme' );
			}

			public function get_icon() {
				return 'fa fa-window-maximize';
			}

			public function get_categories() {
				return [ 'chords-elements' ];
			}

			protected function _register_controls() {
				$this->start_controls_section(
					'section_title',
					[
						'label' => __( 'Chords Post Type', 'ci_theme' ),
					]
				);

				$this->add_control(
					'html_msg',
					[
						'type'    => Controls_Manager::RAW_HTML,
						'raw' => __( 'Display any post type item from Chords by first selecting the post type, e.g. "Rooms" and then the item itself.', 'ci_theme' ),
						'content_classes' => 'ci-description',
					]
				);

				$this->add_control(
					'post_types',
					[
						'label'       => __( 'Post Type', 'ci_theme' ),
						'type' => Controls_Manager::SELECT,
						'default' => '',
						'options' => chords_post_types(),
					]
				);

				$this->add_control(
					'selected_post',
					[
						'label'       => __( 'Post', 'ci_theme' ),
						'type' => Controls_Manager::SELECT,
						'default' => '',
						'options' => '',
					]
				);

				$this->add_control(
					'view',
					[
						'label' => __( 'View', 'ci_theme' ),
						'type' => Controls_Manager::HIDDEN,
						'default' => 'traditional',
					]
				);

				$this->end_controls_section();

			}

			protected function render() {
				$settings = $this->get_settings();

				if ( empty( $settings['selected_post'] ) )
					return;

				$post_id = $settings['selected_post'];

				$q = new \WP_Query( array(
					'post_type' => get_post_type( $post_id ),
					'p'         => $post_id,
				) );

				while ( $q->have_posts() ) : $q->the_post(); ?>
					<div <?php post_class( 'item' ); ?>>
						<a href="<?php the_permalink(); ?>" class="item-hold">
							<figure class="item-thumb">
								<?php the_post_thumbnail( 'ci_blog_full' ); ?>
							</figure>
						</a>

						<?php get_template_part( 'listing-meta' ); ?>

						<a class="btn item-btn" href="<?php the_permalink(); ?>"><?php echo ci_get_read_more_text( get_post_type() ); ?></a>
					</div>
				<?php endwhile;

				wp_reset_postdata();

			}

		}
		Plugin::instance()->widgets_manager->register_widget_type( new Widget_Post_Type() );
	}

	add_action( 'elementor/editor/before_enqueue_scripts', 'Elementor\chords_ajax_posts' );
	function chords_ajax_posts() {

		if ( ! defined( 'ELEMENTOR_VERSION' ) ) {
			return;
		}

		wp_enqueue_script( 'ajax-script', get_template_directory_uri() . '/js/admin/post_ajax.js' );

		$params['no_posts_found'] = __( 'No posts found.', 'ci_theme' );
		$params['ajaxurl']        = admin_url( 'admin-ajax.php' );
		$params['chords_post_nonce']  = wp_create_nonce( 'chords_post_nonce' );

		wp_localize_script( 'ajax-script', 'ElementWidget', $params );
	}

