jQuery(window).load(function() {
  var $ = jQuery;
  
  $('img:not(".logo-img")').each(function() {
	if (/MSIE (\d+\.\d+);/.test(navigator.userAgent)){
	  var ieversion=new Number(RegExp.$1)
	  if (ieversion>=9)
		if (typeof this.naturalWidth === "undefined" || this.naturalWidth === 0) {
		  this.src = "http://placehold.it/" + ($(this).attr('width') || this.width || $(this).naturalWidth()) + "x" + (this.naturalHeight || $(this).attr('height') || $(this).height());
		}
	} else {
	  if (!this.complete || typeof this.naturalWidth === "undefined" || this.naturalWidth === 0) {
		this.src = "http://placehold.it/" + ($(this).attr('width') || this.width) + "x" + ($(this).attr('height') || $(this).height());
	  }
	}
  });
});
$(document).ready(function() {
      var owl = $("#owl-demo");	  

      owl.owlCarousel({
        navigation : true,
        singleItem : true,
		autoPlay : 5000,
		navigationText: [
      "<i class='fa fa-chevron-left fa-3x'></i>",
      "<i class='fa fa-chevron-right fa-3x'></i>"
      ],
      });
	  $("#owl-demo2").owlCarousel({
		navigation : true,
        items : 8,
        itemsDesktop : [1199,3],
        itemsDesktopSmall : [979,3],
		navigationText: [
      "<i class='fa fa-chevron-circle-left fa-3x color-lightpurple'></i>",
      "<i class='fa fa-chevron-circle-right fa-3x color-lightpurple'></i>"
      ],
      });
	  $('.gallery-item').hover( function() {
        $(this).find('.img-title').fadeIn(300);
    }, function() {
        $(this).find('.img-title').fadeOut(100);
    });
    });
	
//Calculating The Browser Scrollbar Width
var parent, child, scrollWidth, bodyWidth;

if (scrollWidth === undefined) {
  parent = jQuery('<div style="width: 50px; height: 50px; overflow: auto"><div/></div>').appendTo('body');
  child = parent.children();
  scrollWidth = child.innerWidth() - child.height(99).innerWidth();
  parent.remove();
}

//Form Stylization
function formStylization() {
  var $        = jQuery,
	  radio    = 'input[type="radio"]',
	  checkbox = 'input[type="checkbox"]';
  
  $(radio).wrap('<div class="new-radio"></div>');
  $('.new-radio').append('<span></span>');
  $(checkbox).wrap('<div class="new-checkbox"></div>');
  $('.new-checkbox').append('<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="15px" height="15px" viewBox="0 0 20 20" enable-background="new 0 0 20 20" xml:space="preserve"><polygon fill="#1e1e1e" points="9.298,13.391 4.18,9.237 3,10.079 9.297,17 17.999,4.678 16.324,3 "/></svg>');
  $(checkbox + ':checked').parent('.new-checkbox').addClass('checked');
  $(radio + ':checked').parent('.new-radio').addClass('checked');
  $(checkbox + ':disabled').parent().addClass('disabled');
  $(radio + ':disabled').parent().addClass('disabled');
  
  $('html').click(function(){
	$(radio).parent('.new-radio').removeClass('checked');
	$(radio + ':checked').parent('.new-radio').addClass('checked');
	$(checkbox).parent('.new-checkbox').removeClass('checked');
	$(checkbox + ':checked').parent('.new-checkbox').addClass('checked');
	$(radio).parent().removeClass('disabled');
	$(checkbox).parent().removeClass('disabled');
	$(radio + ':disabled').parent().addClass('disabled');
	$(checkbox + ':disabled').parent().addClass('disabled');
  });
  
  if(typeof($.fn.selectBox) !== 'undefined') {
	$('select:not(".without-styles")').selectBox();
  }
}

//Full Width Box
function fullWidthBox() {
  var $ = jQuery;
  
  if ($('.full-width-box.auto-width').length) {
	var windowWidth = $('body').outerWidth(),
		containerWidth    = $('.header .container').width();
	  
	$('.full-width-box.auto-width').each(function() {
	  $(this)
		.css({
		  left  : ( containerWidth - windowWidth) / 2,
		  width : windowWidth
		})
		.addClass('loaded');
	});
  }
}

//Animations
function animations() {
  var $ = jQuery;

  $('[data-appear-animation]').each(function() {
	var $this = $(this);

	$this.addClass('appear-animation');

	if(!$('body').hasClass('no-csstransitions') && ($('body').width() + scrollWidth) > 767) {
	  $this.appear(function() {
		var delay = ($this.attr('data-appear-animation-delay') ? $this.attr('data-appear-animation-delay') : 1);

		if(delay > 1) $this.css('animation-delay', delay + 'ms');
		$this.addClass($this.attr('data-appear-animation'));

		setTimeout(function() {
		  $this.addClass('appear-animation-visible');
		}, delay);
	  }, {accX: 0, accY: -150});
	} else {
	  $this.addClass('appear-animation-visible');
	}
  });
  
  /* Animation Progress Bars */
  $('[data-appear-progress-animation]').each(function() {
	var $this = $(this);

	$this.appear(function() {
	  var delay = ($this.attr('data-appear-animation-delay') ? $this.attr('data-appear-animation-delay') : 1);

	  if(delay > 1) $this.css('animation-delay', delay + 'ms');
	  
	  $this.find('.progress-bar').addClass($this.attr('data-appear-animation'));

	  setTimeout(function() {
		$this.find('.progress-bar').animate({
		  width: $this.attr('data-appear-progress-animation')
		}, 500, 'easeInCirc', function() {
		  $this.find('.progress-bar').animate({
			textIndent: 10
		  }, 1500, 'easeOutBounce');
		});
	  }, delay);
	}, {accX: 0, accY: -50});
  });
}

//Header Fixed
function headerCustomizer() {
  var $            = jQuery,
	  body         = $('body'),
	  topHeight    = 0,
	  headerHeight = 0,
	  scroll       = 0,
	  fixedH       = $('.fixed-header');
  
  if ($('#top-box').length) {
	topHeight = $('#top-box').outerHeight();
  }
	
  headerHeight = $('.header').outerHeight();
  
  if (!navigator.userAgent.match(/iPad|iPhone|Android/i)) {
	scroll = topHeight;
	
	if (body.hasClass('hidden-top')) {
	  scroll = 8;
	}
	
	if (body.hasClass('padding-top')) {
	  scroll = topHeight + 420;
	} else if (body.hasClass('boxed')) {
	  scroll = topHeight + 20;
	}
  
	$(window).scroll(function(){
	  var $this = $(this);
	  
	  if (body.hasClass('fixed-header')) {
		if ($this.scrollTop() >= scroll) {
		  body.addClass('fixed');
		} else {
		  body.removeClass('fixed');
		}
	  }
	  
	  if ($this.scrollTop() >= headerHeight) {
		fixedH.addClass('background-opacity');
	  } else {
		fixedH.removeClass('background-opacity');
	  }
	});
  
	$('.hidden-top .header, .hidden-top #top-box').not('.boxed .header, .boxed #top-box').hover(function(){
	  $('.hidden-top').addClass('visible-top');
	}, function(){
	  $('.hidden-top').removeClass('visible-top');
	});
  }
  
  $(window).scroll(function(){
    if ($(this).scrollTop() >= topHeight + headerHeight) {
	  $('.top-fixed-box').addClass('fixed');
	} else {
	  $('.top-fixed-box').removeClass('fixed');
	}
  });
}

//Header Menu
function menu() {
  var $       = jQuery,
	  body    = $('body'),
	  primary = '.primary';
  
  $(primary).find('.parent > a .open-sub, .megamenu .title .open-sub').remove();
  
  if ((body.width() + scrollWidth) <= 979 ) {
	$(primary).find('.parent > a, .megamenu .title').append('<span class="open-sub"><span></span><span></span></span>');
  } else {
	$(primary).find('ul').removeAttr('style').find('li').removeClass('active');
  }
  
  $(primary).find('.open-sub').click(function(event){
	event.preventDefault();
	
	var item = $(this).closest('li, .box');
	
	if ($(item).hasClass('active')) {
	  $(item).children().last().slideUp(600);
	  $(item).removeClass('active');
	} else {
	  var li = $(this).closest('li, .box').parent('ul, .sub-list').children('li, .box');
	  
	  if ($(li).is('.active')) {
		$(li).removeClass('active').children('ul').slideUp(600);
	  }
	  
	  $(item).children().last().slideDown(600);
	  $(item).addClass('active');
	}
  });

  $(primary).find('.parent > a').click(function(event){
	if (((body.width() + scrollWidth) > 979) &&  (navigator.userAgent.match(/iPad|iPhone|Android/i))) {
	  var $this = $(this);
	  
	  if ($this.parent().hasClass('open')) {
		$this.parent().removeClass('open')
	  } else {
		event.preventDefault();
		
		$this.parent().addClass('open')
	  }
	}
  });

  body.on('click', function(event) {
	if (!$(event.target).is(primary + ' *')) {
	  if ($(primary + ' .collapse').hasClass('in')) {
		$(primary + ' .navbar-toggle').addClass('collapsed');
		$(primary + ' .navbar-collapse').collapse('hide');
	  }
	}
  });
  
  /* Top Menu */
  var topMenu = $('.top-navbar').find('.collapse');

  if ((body.width() + scrollWidth) < 768) {
	topMenu.css('width', body.width());
  } else {
	topMenu.css('width', 'auto');
  }
}

//One Page
function scrollMenu() {
  var $            = jQuery,
	  link         = $('a.scroll'),
	  header       = $('.header'),
	  headerHeight = header.height();
	  
  if(($('body').width() + scrollWidth) < 991) {
	headerHeight = 0;
  }
  
  $(document).on('scroll', onScroll);
  
  link.on('click', function(e) {
	var target = $(this).attr('href'),
		$this = $(this);
		
	e.preventDefault();
	
	link.removeClass('active');
    $this.addClass('active');
	
	if ($(target).length) {
	  $('html, body').animate({scrollTop: $(target).offset().top - headerHeight}, 600);
	}
  });
  
  function onScroll(){
    var scrollPos = $(document).scrollTop();
	
    link.each(function () {
	  var currLink   = $(this),
		  refElement = $(currLink.attr('href'));
	  
	  if (
	  refElement.position().top - headerHeight <= scrollPos &&
	  refElement.position().top + refElement.height() > scrollPos) {
		link.removeClass('active');
		currLink.addClass('active');
	  } else {
		currLink.removeClass('active');
	  }
    });
  }
}



//Window Resize
(function() {
  var $ = jQuery;
  var delay = ( function() {
	var timeout = { };
	
	return function( callback, id, time ) {
	  if( id !== null ) {
		time = ( time !== null ) ? time : 100;
		clearTimeout( timeout[ id ] );
		timeout[ id ] = setTimeout( callback, time );
	  }
	};
  })();
  
  function resizeFunctions() {
    if (($('body').width + scrollWidth) > 767) {
	  $('.viewport').remove();
	} else {
	  $('head').append('<meta class="viewport" name="viewport" content="width=device-width, initial-scale=1.0">');
	}
	
	//Functions
	fullWidthBox();
	menu();
	footerStructure();
	tabs();
	modernGallery();
	animations();
	chart();
	isotopFilter();
	zoom();
	paralax();
	loginRegister();
	$('.modal-center:visible').each(centerModal);
	
	progressiveSlider();
	bannerSetCarousel();
	thumblist();
	carousel();
  }

  if(navigator.userAgent.match(/iPad|iPhone|Android/i)) {
	$(window).bind('orientationchange', function() {
	  setTimeout(function() {
		resizeFunctions();
	  }, 150);
	});
  } else {
	$(window).on('resize', function() {
	  delay( function() {
		
		resizeFunctions();

		var graphResize;
	  
		clearTimeout(graphResize);
		return graphResize = setTimeout(function() {
		  return graph(true);
		}, 500);
		  
	  }, 'resize');
	});
  }

}());