/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};

/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {

/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;

/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};

/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);

/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;

/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}


/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;

/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;

/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";

/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	jQuery(function($) {
	  var ExtraTabsView, FontsView, GridEditor, GridEditorModel, LayoutTabsView, PublishBlockView, gridEditor, model;
	  GridEditorModel = __webpack_require__(1).GridEditorModel;
	  GridEditor = __webpack_require__(2);
	  LayoutTabsView = __webpack_require__(10).LayoutTabsView;
	  ExtraTabsView = __webpack_require__(10).ExtraTabsView;
	  FontsView = __webpack_require__(11);
	  PublishBlockView = __webpack_require__(12);
	  rivets.configure({
	    prefix: 'rv',
	    preloadData: true
	  });
	  rivets.binders.color = {
	    publishes: true,
	    bind: function(el) {
	      return jQuery(el).wpColorPicker('option', 'change', (function(_this) {
	        return function(e, ui) {
	          return _this.observer.setValue(ui.color.toCSS());
	        };
	      })(this));
	    },
	    unbind: function(el) {
	      return jQuery(el).wpColorPicker('option', 'change', null);
	    },
	    routine: function(el, value) {
	      return jQuery(el).wpColorPicker('color', value);
	    }
	  };
	  rivets.binders['font-family'] = {
	    publishes: true,
	    bind: rivets.binders.value.bind,
	    unbind: rivets.binders.value.unbind,
	    routine: function(el, value) {
	      var font, i, len, option, ref, results, variant, variantsElement;
	      rivets.binders.value.routine(el, value);
	      variantsElement = jQuery(el).next();
	      variantsElement.find('option').remove();
	      if (font = this.view.components.fonts.find(function(item) {
	        return item.get('family') === value;
	      })) {
	        ref = font.get('variants');
	        results = [];
	        for (i = 0, len = ref.length; i < len; i++) {
	          variant = ref[i];
	          option = jQuery("<option />").text(variant);
	          if (option.text() === this.model.get('style')) {
	            option.attr('selected', 'selected');
	          }
	          results.push(variantsElement.append(option));
	        }
	        return results;
	      } else {
	        variantsElement.append(jQuery("<option value='light'>Light</option>"));
	        variantsElement.append(jQuery("<option value='regular' selected='selected'>Regular</option>"));
	        return variantsElement.append(jQuery("<option value='bold'>Bold</option>"));
	      }
	    }
	  };
	  model = new GridEditorModel();
	  gridEditor = new GridEditor({
	    el: jQuery('#post-body-content'),
	    model: model
	  });
	  new LayoutTabsView({
	    el: $('#grid_layout'),
	    model: model.get('layout')
	  });
	  new ExtraTabsView({
	    el: $('#grid_extras'),
	    model: model
	  });
	  new FontsView({
	    el: $('#grid_fonts'),
	    model: model.get('fonts')
	  });
	  new PublishBlockView({
	    el: $('#submitpost'),
	    model: model
	  });
	  model.set(model.parse($("#ug-data").val()));
	  gridEditor.chooseMode();
	  return $("#post").submit(function(e) {
	    $(this).parent().find(".spinner").show();
	    return $("#ug-data").val(JSON.stringify(model.toJSON()));
	  });
	});


/***/ },
/* 1 */
/***/ function(module, exports) {

	var AutoModeSettings, Cell, CellCollection, CellTemplate, CellTemplateCollection, CollectionBase, CustomFieldFilter, CustomFieldFilterCollection, Font, FontCollection, FontSettings, GridEditorModel, HoverOptions, LayoutModeSettings, LayoutSettings, LightboxOptions, LinkOptions, NestedModel, PaginationSettings, TaxonomyFilter, TaxonomyFilterCollection,
	  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
	  hasProp = {}.hasOwnProperty,
	  bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

	module.exports.NestedModel = NestedModel = (function(superClass) {
	  extend(NestedModel, superClass);

	  function NestedModel() {
	    return NestedModel.__super__.constructor.apply(this, arguments);
	  }

	  NestedModel.prototype.nested = {};

	  NestedModel.prototype.initialize = function() {
	    var klass, name, ref, results;
	    NestedModel.__super__.initialize.apply(this, arguments);
	    ref = this.nested;
	    results = [];
	    for (name in ref) {
	      klass = ref[name];
	      results.push(this.set(name, new klass));
	    }
	    return results;
	  };

	  NestedModel.prototype.toJSON = function() {
	    var json, name;
	    json = NestedModel.__super__.toJSON.apply(this, arguments);
	    for (name in this.nested) {
	      json[name] = this.get(name).toJSON();
	    }
	    return json;
	  };

	  NestedModel.prototype.parse = function(data) {
	    var attr, existing, prop;
	    if (!(_.isObject(data) || _.isUndefined(data))) {
	      data = JSON.parse(data);
	    }
	    if (_.isUndefined(data) || !data) {
	      return data;
	    }
	    for (prop in this.nested) {
	      attr = data[prop];
	      if ((existing = this.get(prop))) {
	        data[prop] = existing;
	      } else {
	        data[prop] = new this.nested[prop];
	      }
	      data[prop].set(data[prop].parse(attr));
	    }
	    return data;
	  };

	  NestedModel.prototype.clone = function() {
	    var clone, prop;
	    clone = NestedModel.__super__.clone.apply(this, arguments);
	    for (prop in this.nested) {
	      clone.set(prop, this.get(prop).clone());
	    }
	    return clone;
	  };

	  return NestedModel;

	})(Backbone.Model);

	module.exports.CollectionBase = CollectionBase = (function(superClass) {
	  extend(CollectionBase, superClass);

	  function CollectionBase() {
	    this.parse = bind(this.parse, this);
	    return CollectionBase.__super__.constructor.apply(this, arguments);
	  }

	  CollectionBase.prototype.parse = function(items) {
	    return _.map(items, (function(_this) {
	      return function(item) {
	        var newItem;
	        newItem = new _this.model;
	        return newItem.set(newItem.parse(item));
	      };
	    })(this));
	  };

	  return CollectionBase;

	})(Backbone.Collection);

	module.exports.HoverOptions = HoverOptions = (function(superClass) {
	  extend(HoverOptions, superClass);

	  function HoverOptions() {
	    return HoverOptions.__super__.constructor.apply(this, arguments);
	  }

	  HoverOptions.prototype.defaults = {
	    position: 'top_left',
	    background_image_position: 'repeat'
	  };

	  return HoverOptions;

	})(NestedModel);

	module.exports.LightboxOptions = LightboxOptions = (function(superClass) {
	  extend(LightboxOptions, superClass);

	  function LightboxOptions() {
	    this.isImageOrGrid = bind(this.isImageOrGrid, this);
	    return LightboxOptions.__super__.constructor.apply(this, arguments);
	  }

	  LightboxOptions.prototype.defaults = {
	    mode: 'image',
	    description_style: 'mini'
	  };

	  LightboxOptions.prototype.isImage = function() {
	    return this.get('mode') === 'image';
	  };

	  LightboxOptions.prototype.isGrid = function() {
	    return this.get('mode') === 'ubergrid';
	  };

	  LightboxOptions.prototype.isIframe = function() {
	    var ref;
	    return (ref = this.get('mode')) === 'iframe' || ref === 'ubergrid';
	  };

	  LightboxOptions.prototype.isImageOrGrid = function() {
	    return this.isImage() || this.isGrid();
	  };

	  return LightboxOptions;

	})(NestedModel);

	module.exports.LinkOptions = LinkOptions = (function(superClass) {
	  extend(LinkOptions, superClass);

	  function LinkOptions() {
	    return LinkOptions.__super__.constructor.apply(this, arguments);
	  }

	  LinkOptions.prototype.nested = {
	    lightbox: LightboxOptions
	  };

	  LinkOptions.prototype.defaults = {
	    mode: 'url'
	  };

	  return LinkOptions;

	})(NestedModel);

	module.exports.Cell = Cell = (function(superClass) {
	  extend(Cell, superClass);

	  function Cell() {
	    return Cell.__super__.constructor.apply(this, arguments);
	  }

	  Cell.prototype.nested = {
	    hover: HoverOptions,
	    label: Backbone.Model,
	    link: LinkOptions
	  };

	  Cell.prototype.defaults = function() {
	    return {
	      layout: 'r1c1-io',
	      title_position: 'center',
	      title_background_image_position: 'repeat'
	    };
	  };

	  Cell.prototype.clone = function() {
	    return this.collection.add(Cell.__super__.clone.apply(this, arguments));
	  };

	  return Cell;

	})(NestedModel);

	CellTemplate = (function(superClass) {
	  extend(CellTemplate, superClass);

	  function CellTemplate() {
	    return CellTemplate.__super__.constructor.apply(this, arguments);
	  }

	  CellTemplate.prototype.defaults = function() {
	    return _.extend(CellTemplate.__super__.defaults.apply(this, arguments), {
	      criteria: 'order'
	    });
	  };

	  CellTemplate.prototype.isPHP = function() {
	    return this.get('criteria') === 'php';
	  };

	  CellTemplate.prototype.initialize = function() {
	    CellTemplate.__super__.initialize.apply(this, arguments);
	    if (!this.get('criteria')) {
	      return this.set('criteria') === 'order';
	    }
	  };

	  return CellTemplate;

	})(Cell);

	CellCollection = (function(superClass) {
	  extend(CellCollection, superClass);

	  function CellCollection() {
	    return CellCollection.__super__.constructor.apply(this, arguments);
	  }

	  CellCollection.prototype.model = Cell;

	  return CellCollection;

	})(CollectionBase);

	CellTemplateCollection = (function(superClass) {
	  extend(CellTemplateCollection, superClass);

	  function CellTemplateCollection() {
	    return CellTemplateCollection.__super__.constructor.apply(this, arguments);
	  }

	  CellTemplateCollection.prototype.model = CellTemplate;

	  CellTemplateCollection.prototype.initialize = function() {
	    CellTemplateCollection.__super__.initialize.apply(this, arguments);
	    if (this.lentgh === 0) {
	      return this.add({});
	    }
	  };

	  return CellTemplateCollection;

	})(CellCollection);

	TaxonomyFilter = (function(superClass) {
	  extend(TaxonomyFilter, superClass);

	  function TaxonomyFilter() {
	    return TaxonomyFilter.__super__.constructor.apply(this, arguments);
	  }

	  TaxonomyFilter.prototype.defaults = {
	    operator: 'IN'
	  };

	  return TaxonomyFilter;

	})(Backbone.Model);

	TaxonomyFilterCollection = (function(superClass) {
	  extend(TaxonomyFilterCollection, superClass);

	  function TaxonomyFilterCollection() {
	    return TaxonomyFilterCollection.__super__.constructor.apply(this, arguments);
	  }

	  TaxonomyFilterCollection.prototype.model = TaxonomyFilter;

	  return TaxonomyFilterCollection;

	})(CollectionBase);

	CustomFieldFilter = (function(superClass) {
	  extend(CustomFieldFilter, superClass);

	  function CustomFieldFilter() {
	    return CustomFieldFilter.__super__.constructor.apply(this, arguments);
	  }

	  CustomFieldFilter.prototype.defaults = {
	    operator: '=',
	    type: 'CHAR'
	  };

	  return CustomFieldFilter;

	})(Backbone.Model);

	CustomFieldFilterCollection = (function(superClass) {
	  extend(CustomFieldFilterCollection, superClass);

	  function CustomFieldFilterCollection() {
	    return CustomFieldFilterCollection.__super__.constructor.apply(this, arguments);
	  }

	  CustomFieldFilterCollection.prototype.model = CustomFieldFilter;

	  return CustomFieldFilterCollection;

	})(CollectionBase);

	AutoModeSettings = (function(superClass) {
	  extend(AutoModeSettings, superClass);

	  function AutoModeSettings() {
	    return AutoModeSettings.__super__.constructor.apply(this, arguments);
	  }

	  AutoModeSettings.prototype.defaults = {
	    choose_template_method: 'sequential',
	    taxonomy_filters_relation: 'AND',
	    custom_field_filters_relation: 'AND'
	  };

	  AutoModeSettings.prototype.nested = {
	    taxonomyFilters: TaxonomyFilterCollection,
	    customFieldFilters: CustomFieldFilterCollection,
	    cellTemplates: CellTemplateCollection
	  };

	  return AutoModeSettings;

	})(NestedModel);

	Font = (function(superClass) {
	  extend(Font, superClass);

	  function Font() {
	    return Font.__super__.constructor.apply(this, arguments);
	  }

	  Font.prototype.defaults = {
	    font: '',
	    style: 'regular'
	  };

	  return Font;

	})(Backbone.Model);

	FontSettings = (function(superClass) {
	  extend(FontSettings, superClass);

	  function FontSettings() {
	    return FontSettings.__super__.constructor.apply(this, arguments);
	  }

	  FontSettings.prototype.nested = {
	    title: Font,
	    tagline: Font,
	    hover_title: Font,
	    hover_text: Font,
	    lightbox_title: Font,
	    lightbox_text: Font,
	    label_title: Font,
	    label_tagline: Font,
	    label_price: Font,
	    filters: Font,
	    pagination: Font
	  };

	  return FontSettings;

	})(NestedModel);

	module.exports.FontCollection = FontCollection = (function(superClass) {
	  extend(FontCollection, superClass);

	  function FontCollection() {
	    return FontCollection.__super__.constructor.apply(this, arguments);
	  }

	  FontCollection.prototype.url = "admin-ajax.php?action=uber_grid_get_fonts";

	  FontCollection.prototype.parse = function(data) {
	    return data.items;
	  };

	  return FontCollection;

	})(Backbone.Collection);

	LayoutModeSettings = (function(superClass) {
	  extend(LayoutModeSettings, superClass);

	  function LayoutModeSettings() {
	    return LayoutModeSettings.__super__.constructor.apply(this, arguments);
	  }

	  return LayoutModeSettings;

	})(NestedModel);

	LayoutSettings = (function(superClass) {
	  extend(LayoutSettings, superClass);

	  function LayoutSettings() {
	    return LayoutSettings.__super__.constructor.apply(this, arguments);
	  }

	  LayoutSettings.prototype.nested = {
	    "default": LayoutModeSettings,
	    '440': LayoutModeSettings,
	    '768': LayoutModeSettings
	  };

	  return LayoutSettings;

	})(NestedModel);

	PaginationSettings = (function(superClass) {
	  extend(PaginationSettings, superClass);

	  function PaginationSettings() {
	    return PaginationSettings.__super__.constructor.apply(this, arguments);
	  }

	  PaginationSettings.prototype.isPagination = function() {
	    return this.get('style') === 'pagination';
	  };

	  return PaginationSettings;

	})(Backbone.Model);

	module.exports.GridEditorModel = GridEditorModel = (function(superClass) {
	  extend(GridEditorModel, superClass);

	  function GridEditorModel() {
	    return GridEditorModel.__super__.constructor.apply(this, arguments);
	  }

	  GridEditorModel.prototype.nested = {
	    cells: CellCollection,
	    auto: AutoModeSettings,
	    fonts: FontSettings,
	    layout: LayoutSettings,
	    filters: Backbone.Model,
	    pagination: PaginationSettings,
	    effects: Backbone.Model
	  };

	  return GridEditorModel;

	})(NestedModel);


/***/ },
/* 2 */
/***/ function(module, exports, __webpack_require__) {

	var AutomaticEditorView, GridEditor, ManualEditorView,
	  bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
	  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
	  hasProp = {}.hasOwnProperty;

	ManualEditorView = __webpack_require__(3).ManualEditorView;

	AutomaticEditorView = __webpack_require__(9);

	module.exports = GridEditor = (function(superClass) {
	  extend(GridEditor, superClass);

	  function GridEditor() {
	    this.onAutomaticClicked = bind(this.onAutomaticClicked, this);
	    this.enableManual = bind(this.enableManual, this);
	    this.onManualClicked = bind(this.onManualClicked, this);
	    return GridEditor.__super__.constructor.apply(this, arguments);
	  }

	  GridEditor.prototype.ui = {
	    manualModeTab: '#ug-manual-mode-link',
	    autoModeTab: '#ug-auto-mode-link'
	  };

	  GridEditor.prototype.events = {
	    'click @ui.manualModeTab': 'onManualClicked',
	    'click @ui.autoModeTab': 'onAutomaticClicked'
	  };

	  GridEditor.prototype.regions = {
	    editor: '#ug-editor-wrapper'
	  };

	  GridEditor.prototype.initialize = function() {
	    GridEditor.__super__.initialize.apply(this, arguments);
	    this.bindUIElements();
	    return this.chooseMode();
	  };

	  GridEditor.prototype.chooseMode = function() {
	    if (this.model.get('mode') !== 'auto') {
	      return this.enableManual();
	    } else {
	      return this.enableAutomatic();
	    }
	  };

	  GridEditor.prototype.onManualClicked = function(e) {
	    e.preventDefault();
	    return this.enableManual();
	  };

	  GridEditor.prototype.enableManual = function() {
	    this.ui.autoModeTab.removeClass('nav-tab-active');
	    this.ui.manualModeTab.addClass('nav-tab-active');
	    this.model.set('mode', 'manual');
	    return this.editor.show(new ManualEditorView({
	      collection: this.model.get('cells')
	    }));
	  };

	  GridEditor.prototype.onAutomaticClicked = function(e) {
	    e.preventDefault();
	    return this.enableAutomatic();
	  };

	  GridEditor.prototype.enableAutomatic = function() {
	    this.ui.autoModeTab.addClass('nav-tab-active');
	    this.ui.manualModeTab.removeClass('nav-tab-active');
	    this.model.set('mode', 'auto');
	    return this.editor.show(new AutomaticEditorView({
	      model: this.model.get('auto')
	    }));
	  };

	  return GridEditor;

	})(Marionette.LayoutView);


/***/ },
/* 3 */
/***/ function(module, exports, __webpack_require__) {

	var Cell, CellEditorBase, CellEditorHoverSectionView, CellEditorLabelSectionView, CellEditorLayoutSectionView, CellEditorLinkingSectionView, CellEditorMainSectionView, CellEditorSectionView, CellEditorView, EmptyManualEditorView, ManualEditorView,
	  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
	  hasProp = {}.hasOwnProperty,
	  bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

	CellEditorBase = __webpack_require__(4);

	Cell = __webpack_require__(1).Cell;

	CellEditorMainSectionView = __webpack_require__(5).CellEditorMainSectionView;

	CellEditorSectionView = __webpack_require__(6);

	CellEditorLayoutSectionView = __webpack_require__(5).CellEditorLayoutSectionView;

	CellEditorHoverSectionView = __webpack_require__(5).CellEditorHoverSectionView;

	CellEditorLabelSectionView = __webpack_require__(5).CellEditorLabelSectionView;

	CellEditorLinkingSectionView = __webpack_require__(5).CellEditorLinkingSectionView;

	EmptyManualEditorView = (function(superClass) {
	  extend(EmptyManualEditorView, superClass);

	  function EmptyManualEditorView() {
	    return EmptyManualEditorView.__super__.constructor.apply(this, arguments);
	  }

	  EmptyManualEditorView.prototype.template = '#ug-manual-editor-no-cells-template';

	  EmptyManualEditorView.prototype.tagName = 'li';

	  EmptyManualEditorView.prototype.className = 'ug-no-cells';

	  return EmptyManualEditorView;

	})(Marionette.ItemView);

	CellEditorView = (function(superClass) {
	  extend(CellEditorView, superClass);

	  function CellEditorView() {
	    this.onTitleChanged = bind(this.onTitleChanged, this);
	    return CellEditorView.__super__.constructor.apply(this, arguments);
	  }

	  CellEditorView.prototype.template = '#ug-cell-manual-template';

	  CellEditorView.prototype.modelEvents = {
	    'change:title': 'onTitleChanged'
	  };

	  CellEditorView.prototype.onShow = function() {
	    return this.onTitleChanged();
	  };

	  CellEditorView.prototype.displaySections = function() {
	    this.main.show(new CellEditorMainSectionView({
	      model: this.model
	    }));
	    this.filtering.show(new CellEditorSectionView({
	      model: this.model,
	      className: 'ug-section ug-expandable',
	      template: '#ug-cell-filtering-section-template'
	    }));
	    this.layout.show(new CellEditorLayoutSectionView({
	      model: this.model
	    }));
	    this.hover.show(new CellEditorHoverSectionView({
	      model: this.model.get('hover')
	    }));
	    this.label.show(new CellEditorLabelSectionView({
	      model: this.model.get('label')
	    }));
	    this.binding = rivets.bind(this.$el, {
	      model: this.model
	    });
	    return this.linking.show(new CellEditorLinkingSectionView({
	      model: this.model.get('link')
	    }));
	  };

	  CellEditorView.prototype.hideSections = function() {
	    var j, len, ref, region, results;
	    this.binding.unbind();
	    ref = [this.main, this.filtering, this.layout, this.linking, this.hover, this.label];
	    results = [];
	    for (j = 0, len = ref.length; j < len; j++) {
	      region = ref[j];
	      results.push(region.empty());
	    }
	    return results;
	  };

	  CellEditorView.prototype.onTitleChanged = function() {
	    var i, text;
	    if (!(text = this.model.get('title'))) {
	      i = this.model.collection.indexOf(this.model) + 1;
	      text = "Cell " + i;
	    }
	    return this.ui.headerText.html(text);
	  };

	  return CellEditorView;

	})(CellEditorBase);

	module.exports.ManualEditorView = ManualEditorView = (function(superClass) {
	  extend(ManualEditorView, superClass);

	  function ManualEditorView() {
	    this.onAddCellAfterClicked = bind(this.onAddCellAfterClicked, this);
	    this.onAddCellBeforeClicked = bind(this.onAddCellBeforeClicked, this);
	    this.onSorted = bind(this.onSorted, this);
	    return ManualEditorView.__super__.constructor.apply(this, arguments);
	  }

	  ManualEditorView.prototype.template = '#ug-manual-editor-template';

	  ManualEditorView.prototype.childViewContainer = '> ul';

	  ManualEditorView.prototype.childView = CellEditorView;

	  ManualEditorView.prototype.emptyView = EmptyManualEditorView;

	  ManualEditorView.prototype.ui = function() {
	    return {
	      addCellBefore: 'button[data-action=add-new-before]',
	      addCellAfter: 'button[data-action=add-new-after]',
	      children: '>ul'
	    };
	  };

	  ManualEditorView.prototype.events = {
	    'click @ui.addCellBefore': 'onAddCellBeforeClicked',
	    'click @ui.addCellAfter': 'onAddCellAfterClicked'
	  };

	  ManualEditorView.prototype.bindUIElements = function() {
	    ManualEditorView.__super__.bindUIElements.apply(this, arguments);
	    return this.ui.children.sortable({
	      axis: 'y',
	      update: this.onSorted
	    });
	  };

	  ManualEditorView.prototype.onSorted = function(event, ui) {
	    var child, index, item;
	    item = ui.item[0];
	    child = this.children.find((function(_this) {
	      return function(child) {
	        return item === child.el;
	      };
	    })(this));
	    index = this.ui.children.find('> li').index(child.$el);
	    this.collection.remove(child.model);
	    return this.collection.add(child.model, {
	      at: index
	    });
	  };

	  ManualEditorView.prototype.onAddCellBeforeClicked = function(event) {
	    var cell;
	    event.preventDefault();
	    this.collection.add(cell = new Cell, {
	      at: 0
	    });
	    return this.children.findByModel(cell).scrollTo();
	  };

	  ManualEditorView.prototype.onAddCellAfterClicked = function(event) {
	    var cell;
	    event.preventDefault();
	    this.collection.add(cell = new Cell);
	    return this.children.findByModel(cell).scrollTo();
	  };

	  return ManualEditorView;

	})(Marionette.CompositeView);


/***/ },
/* 4 */
/***/ function(module, exports) {

	var CellEditorBase,
	  bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
	  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
	  hasProp = {}.hasOwnProperty;

	module.exports = CellEditorBase = (function(superClass) {
	  extend(CellEditorBase, superClass);

	  function CellEditorBase() {
	    this.onRemoveClicked = bind(this.onRemoveClicked, this);
	    this.onCloneClicked = bind(this.onCloneClicked, this);
	    return CellEditorBase.__super__.constructor.apply(this, arguments);
	  }

	  CellEditorBase.prototype.className = 'ug-cell';

	  CellEditorBase.prototype.tagName = 'li';

	  CellEditorBase.prototype.regions = function() {
	    return {
	      main: '.ug-cell-main-wrapper',
	      filtering: '.ug-cell-filtering-wrapper',
	      layout: '.ug-cell-layout-wrapper',
	      linking: '.ug-cell-linking-wrapper',
	      hover: '.ug-cell-hover-wrapper',
	      label: '.ug-cell-label-wrapper'
	    };
	  };

	  CellEditorBase.prototype.className = 'ug-cell';

	  CellEditorBase.prototype.ui = function() {
	    return {
	      header: '> h3',
	      headerText: 'h3 .heading',
	      cloneLink: '> h3 a[data-action=clone]',
	      removeLink: '> h3 a[data-action=remove]'
	    };
	  };

	  CellEditorBase.prototype.events = {
	    'click @ui.header': 'onHeaderClicked',
	    'click @ui.cloneLink': 'onCloneClicked',
	    'click @ui.removeLink': 'onRemoveClicked'
	  };

	  CellEditorBase.prototype.onCloneClicked = function(e) {
	    e.stopPropagation();
	    e.preventDefault();
	    return this.model.clone();
	  };

	  CellEditorBase.prototype.onRemoveClicked = function(e) {
	    e.preventDefault();
	    return this.model.collection.remove(this.model);
	  };

	  CellEditorBase.prototype.onHeaderClicked = function() {
	    this.$el.toggleClass('ug-expanded');
	    if (this.$el.hasClass('ug-expanded')) {
	      return this.displaySections();
	    } else {
	      return this.hideSections();
	    }
	  };

	  CellEditorBase.prototype.scrollTo = function() {
	    return this.$el.scrollTo();
	  };

	  return CellEditorBase;

	})(Marionette.LayoutView);


/***/ },
/* 5 */
/***/ function(module, exports, __webpack_require__) {

	var CellEditorHoverSectionView, CellEditorLabelSectionView, CellEditorLayoutSectionView, CellEditorLinkingSectionView, CellEditorMainSectionView, CellEditorSectionView, CellTemplateMainSectionView, ImageSelector, LayoutSelector, LightboxLinkingOptions, LinkingOptions,
	  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
	  hasProp = {}.hasOwnProperty,
	  bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

	CellEditorSectionView = __webpack_require__(6);

	ImageSelector = __webpack_require__(7);

	LayoutSelector = __webpack_require__(8);

	module.exports.CellEditorMainSectionView = CellEditorMainSectionView = (function(superClass) {
	  extend(CellEditorMainSectionView, superClass);

	  function CellEditorMainSectionView() {
	    return CellEditorMainSectionView.__super__.constructor.apply(this, arguments);
	  }

	  CellEditorMainSectionView.prototype.template = '#ug-cell-main-section-template';

	  CellEditorMainSectionView.prototype.className = function() {
	    return 'ug-section cell-title';
	  };

	  CellEditorMainSectionView.prototype.ui = function() {
	    return _.extend(CellEditorMainSectionView.__super__.ui.apply(this, arguments), {
	      titleEditor: 'input.ug-cell-title',
	      mainImageSelector: '.ug-main-image-selector',
	      backgroundImageSelector: '.ug-background-image-selector'
	    });
	  };

	  CellEditorMainSectionView.prototype.bindUIElements = function() {
	    CellEditorMainSectionView.__super__.bindUIElements.apply(this, arguments);
	    this.mainImageSelector = new ImageSelector({
	      el: this.ui.mainImageSelector,
	      model: this.model,
	      imageProperty: 'image',
	      obeyLayout: true
	    });
	    return this.backgroundImageSelector = new ImageSelector({
	      el: this.ui.backgroundImageSelector,
	      model: this.model,
	      imageProperty: 'background_image',
	      obeyLayout: true
	    });
	  };

	  return CellEditorMainSectionView;

	})(CellEditorSectionView);

	module.exports.CellTemplateMainSectionView = CellTemplateMainSectionView = (function(superClass) {
	  extend(CellTemplateMainSectionView, superClass);

	  function CellTemplateMainSectionView() {
	    return CellTemplateMainSectionView.__super__.constructor.apply(this, arguments);
	  }

	  return CellTemplateMainSectionView;

	})(CellEditorMainSectionView);

	module.exports.CellEditorLayoutSectionView = CellEditorLayoutSectionView = (function(superClass) {
	  extend(CellEditorLayoutSectionView, superClass);

	  function CellEditorLayoutSectionView() {
	    return CellEditorLayoutSectionView.__super__.constructor.apply(this, arguments);
	  }

	  CellEditorLayoutSectionView.prototype.template = '#ug-cell-section-layout-template';

	  CellEditorLayoutSectionView.prototype.className = function() {
	    return CellEditorLayoutSectionView.__super__.className.apply(this, arguments) + ' cell-layout';
	  };

	  CellEditorLayoutSectionView.prototype.ui = function() {
	    return _.extend(CellEditorLayoutSectionView.__super__.ui.apply(this, arguments), {
	      lightboxImageSelector: '.image-selector',
	      layouts: '.ug-layouts'
	    });
	  };

	  CellEditorLayoutSectionView.prototype.initialize = function() {
	    return CellEditorLayoutSectionView.__super__.initialize.apply(this, arguments);
	  };

	  CellEditorLayoutSectionView.prototype.bindUIElements = function() {
	    CellEditorLayoutSectionView.__super__.bindUIElements.apply(this, arguments);
	    return this.layoutSelector = new LayoutSelector({
	      el: this.ui.layouts,
	      model: this.model
	    });
	  };

	  return CellEditorLayoutSectionView;

	})(CellEditorSectionView);

	module.exports.CellEditorLinkingSectionView = CellEditorLinkingSectionView = (function(superClass) {
	  extend(CellEditorLinkingSectionView, superClass);

	  function CellEditorLinkingSectionView() {
	    this.onLinkModeChanged = bind(this.onLinkModeChanged, this);
	    this.onShow = bind(this.onShow, this);
	    return CellEditorLinkingSectionView.__super__.constructor.apply(this, arguments);
	  }

	  CellEditorLinkingSectionView.prototype.template = '#ug-cell-section-link-mode-template';

	  CellEditorLinkingSectionView.prototype.className = 'ug-section ug-expandable ug-cell-link';

	  CellEditorLinkingSectionView.prototype.regions = {
	    details: '.ug-linking-details'
	  };

	  CellEditorLinkingSectionView.prototype.ui = function() {
	    return _.extend(CellEditorLinkingSectionView.__super__.ui.apply(this, arguments), {
	      lightboxImageSelector: '.image-selector'
	    });
	  };

	  CellEditorLinkingSectionView.prototype.modelEvents = {
	    'change:mode': 'onLinkModeChanged'
	  };

	  CellEditorLinkingSectionView.prototype.visibilityProperty = 'enable';

	  CellEditorLinkingSectionView.prototype.onShow = function() {
	    return this.onLinkModeChanged();
	  };

	  CellEditorLinkingSectionView.prototype.onLinkModeChanged = function() {
	    this.details.show(this.getLinkingModeView());
	    if (this.binding) {
	      this.binding.unbind();
	    }
	    return this.binding = rivets.bind(this.$el, this.model);
	  };

	  CellEditorLinkingSectionView.prototype.getLinkingModeView = function() {
	    if (this.model.get('mode') === 'lightbox') {
	      return new LightboxLinkingOptions({
	        model: this.model.get('lightbox')
	      });
	    } else {
	      return new LinkingOptions({
	        model: this.model
	      });
	    }
	  };

	  CellEditorLinkingSectionView.prototype.remove = function() {
	    if (this.binding) {
	      this.binding.unbind();
	    }
	    return CellEditorLinkingSectionView.__super__.remove.apply(this, arguments);
	  };

	  return CellEditorLinkingSectionView;

	})(CellEditorSectionView);

	LightboxLinkingOptions = (function(superClass) {
	  extend(LightboxLinkingOptions, superClass);

	  function LightboxLinkingOptions() {
	    return LightboxLinkingOptions.__super__.constructor.apply(this, arguments);
	  }

	  LightboxLinkingOptions.prototype.template = '#ug-cell-linking-lightbox-template';

	  LightboxLinkingOptions.prototype.ui = {
	    imageSelector: '.image-selector'
	  };

	  LightboxLinkingOptions.prototype.onShow = function() {
	    return this.lightboxImageSelector = new ImageSelector({
	      el: this.ui.imageSelector,
	      model: this.model,
	      imageProperty: 'image'
	    });
	  };

	  LightboxLinkingOptions.prototype.remove = function() {
	    this.lightboxImageSelector.remove();
	    return LightboxLinkingOptions.__super__.remove.apply(this, arguments);
	  };

	  return LightboxLinkingOptions;

	})(Marionette.ItemView);

	LinkingOptions = (function(superClass) {
	  extend(LinkingOptions, superClass);

	  function LinkingOptions() {
	    return LinkingOptions.__super__.constructor.apply(this, arguments);
	  }

	  LinkingOptions.prototype.template = '#ug-cell-linking-url';

	  return LinkingOptions;

	})(Marionette.ItemView);

	module.exports.CellEditorHoverSectionView = CellEditorHoverSectionView = (function(superClass) {
	  extend(CellEditorHoverSectionView, superClass);

	  function CellEditorHoverSectionView() {
	    return CellEditorHoverSectionView.__super__.constructor.apply(this, arguments);
	  }

	  CellEditorHoverSectionView.prototype.template = '#ug-cell-section-hover-template';

	  CellEditorHoverSectionView.prototype.className = 'ug-section ug-expandable ug-cell-hover';

	  CellEditorHoverSectionView.prototype.ui = function() {
	    return _.extend(CellEditorHoverSectionView.__super__.ui.apply(this, arguments), {
	      hoverImageSelector: '.image-selector'
	    });
	  };

	  CellEditorHoverSectionView.prototype.visibilityProperty = 'enable';

	  CellEditorHoverSectionView.prototype.onShow = function() {
	    return this.hoverImageSelector = new ImageSelector({
	      el: this.ui.hoverImageSelector,
	      model: this.model,
	      imageProperty: 'background_image',
	      obeyLayout: false
	    });
	  };

	  return CellEditorHoverSectionView;

	})(CellEditorSectionView);

	module.exports.CellEditorLabelSectionView = CellEditorLabelSectionView = (function(superClass) {
	  extend(CellEditorLabelSectionView, superClass);

	  function CellEditorLabelSectionView() {
	    return CellEditorLabelSectionView.__super__.constructor.apply(this, arguments);
	  }

	  CellEditorLabelSectionView.prototype.template = '#ug-cell-section-label-template';

	  CellEditorLabelSectionView.prototype.className = 'ug-section ug-expandable ug-cell-label';

	  CellEditorLabelSectionView.prototype.visibilityProperty = 'enable';

	  return CellEditorLabelSectionView;

	})(CellEditorSectionView);


/***/ },
/* 6 */
/***/ function(module, exports) {

	var CellEditorSectionView,
	  bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
	  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
	  hasProp = {}.hasOwnProperty;

	module.exports = CellEditorSectionView = (function(superClass) {
	  extend(CellEditorSectionView, superClass);

	  function CellEditorSectionView() {
	    this.onHeaderLabelClicked = bind(this.onHeaderLabelClicked, this);
	    this.onHeaderCheckboxClicked = bind(this.onHeaderCheckboxClicked, this);
	    return CellEditorSectionView.__super__.constructor.apply(this, arguments);
	  }

	  CellEditorSectionView.prototype.ui = function() {
	    return {
	      header: 'label.huge',
	      headerCheckbox: 'label.huge :checkbox',
	      imageSelectors: '.image-selector',
	      columns: '.ug-columns-2, .ug-column-1',
	      colorPickers: '.color-picker'
	    };
	  };

	  CellEditorSectionView.prototype.events = function() {
	    return {
	      'change @ui.headerCheckbox': 'onHeaderCheckboxClicked',
	      'click @ui.header': 'onHeaderLabelClicked'
	    };
	  };

	  CellEditorSectionView.prototype.className = function() {
	    return 'ug-section ug-expandable';
	  };

	  CellEditorSectionView.prototype.initialize = function() {
	    CellEditorSectionView.__super__.initialize.apply(this, arguments);
	    if (this.model) {
	      return this.listenTo(this.model, "change:" + (this.getOption('visibilityProperty')), this.onHeaderLabelClicked);
	    }
	  };

	  CellEditorSectionView.prototype.bindUIElements = function() {
	    var visibilityProperty;
	    CellEditorSectionView.__super__.bindUIElements.apply(this, arguments);
	    if (visibilityProperty = this.getOption('visibilityProperty')) {
	      if (this.model.get(visibilityProperty)) {
	        this.$el.addClass('ug-expanded');
	      }
	    }
	    return this.ui.colorPickers.wpColorPicker();
	  };

	  CellEditorSectionView.prototype.onHeaderCheckboxClicked = function(e) {};

	  CellEditorSectionView.prototype.onHeaderLabelClicked = function(e) {
	    if (this.$el.hasClass('ug-expandable') && this.ui.headerCheckbox.length > 0) {
	      return this.$el.toggleClass('ug-expanded');
	    } else {
	      return this.$el.toggleClass('ug-expanded');
	    }
	  };

	  return CellEditorSectionView;

	})(Marionette.LayoutView);


/***/ },
/* 7 */
/***/ function(module, exports) {

	var ImageSelector,
	  bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
	  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
	  hasProp = {}.hasOwnProperty;

	module.exports = ImageSelector = (function(superClass) {
	  extend(ImageSelector, superClass);

	  function ImageSelector() {
	    this.loadNewImageById = bind(this.loadNewImageById, this);
	    this.loadNewImage = bind(this.loadNewImage, this);
	    this.onLayoutChanged = bind(this.onLayoutChanged, this);
	    this.setImageField = bind(this.setImageField, this);
	    this.onImageDeleteClicked = bind(this.onImageDeleteClicked, this);
	    this.onImageSelectClicked = bind(this.onImageSelectClicked, this);
	    this.onImageChanged = bind(this.onImageChanged, this);
	    this.onMouseOut = bind(this.onMouseOut, this);
	    this.onMouseEnter = bind(this.onMouseEnter, this);
	    return ImageSelector.__super__.constructor.apply(this, arguments);
	  }

	  ImageSelector.prototype.ui = {
	    input: 'input',
	    image: 'img',
	    actions: '.actions-wrapper',
	    overlay: '.overlay',
	    select: '.select-image',
	    remove: '.image-delete'
	  };

	  ImageSelector.prototype.events = {
	    'click button.select-image': 'onImageSelectClicked',
	    'click a.image-delete': 'onImageDeleteClicked',
	    mouseenter: 'onMouseEnter',
	    mouseleave: 'onMouseOut'
	  };

	  ImageSelector.prototype.modelEvents = {
	    'change:layout': 'onLayoutChanged'
	  };

	  ImageSelector.prototype.initialize = function() {
	    ImageSelector.__super__.initialize.apply(this, arguments);
	    this.bindUIElements();
	    return this.onImageChanged();
	  };

	  ImageSelector.prototype.bindUIElements = function() {
	    ImageSelector.__super__.bindUIElements.apply(this, arguments);
	    this.ui.image.hide();
	    if (this.ui.input.val()) {
	      this.model.loadImage(this.getOption('imageProperty'));
	      this.ui.select.hide();
	      this.ui.remove.show();
	      this.ui.overlay.show();
	    } else {
	      this.ui.select.show();
	      this.ui.remove.hide();
	      this.ui.overlay.hide();
	    }
	    return this.listenTo(this.model, "change:" + (this.getOption('imageProperty')), this.onImageChanged);
	  };

	  ImageSelector.prototype.onMouseEnter = function() {
	    if (this.model.get(this.getOption('imageProperty'))) {
	      this.ui.actions.fadeIn('fast');
	      return this.ui.overlay.fadeIn('fast');
	    }
	  };

	  ImageSelector.prototype.onMouseOut = function() {
	    if (this.model.get(this.getOption('imageProperty'))) {
	      this.ui.actions.fadeOut('fast');
	      return this.ui.overlay.fadeOut('fast');
	    }
	  };

	  ImageSelector.prototype.onImageChanged = function() {
	    var image;
	    if (image = this.model.get(this.getOption('imageProperty'))) {
	      return this.loadNewImageById(image);
	    }
	  };

	  ImageSelector.prototype.onImageSelectClicked = function(event) {
	    var flow, id, selector, state;
	    selector = this;
	    event.preventDefault();
	    id = selector.ui.input.val();
	    flow = wp.media({
	      title: "Select an image",
	      library: {
	        type: 'image'
	      },
	      button: {
	        text: "Select Image"
	      },
	      multiple: false
	    }).open();
	    state = flow.state();
	    if ('' !== id && -1 !== id) {
	      state.get('selection').reset([wp.media.model.Attachment.get(id)]);
	    }
	    state.set('display', false);
	    return state.on('select', function(el) {
	      var selection;
	      selection = this.get('selection').single();
	      selector.setImageField(selection.id);
	      return selector.loadNewImageById(selection.id);
	    });
	  };

	  ImageSelector.prototype.onImageDeleteClicked = function(event) {
	    event.preventDefault();
	    this.ui.input.val('');
	    this.model.set(this.getOption('imageProperty'), null);
	    this.ui.image.hide().attr('src', '');
	    this.ui.overlay.hide();
	    this.ui.select.fadeIn('fast');
	    this.ui.actions.show();
	    return this.ui.remove.hide();
	  };

	  ImageSelector.prototype.layouts = {
	    "r1c1-io": "r1c1",
	    "r1c2-ir": "r1c1",
	    "r1c2-il": "r1c1",
	    "r2c1-it": "r1c1",
	    "r2c1-ib": "r1c1",
	    "r2c2-io": "r2c2",
	    "r2c2-it": "r1c2",
	    "r2c2-ib": "r1c2",
	    "r2c2-il": "r2c1",
	    "r2c2-ir": "r2c1",
	    "r1c2-io": "r1c2",
	    "r2c1-io": "r2c1"
	  };

	  ImageSelector.prototype.setImageField = function(selection) {
	    this.ui.input.val(selection);
	    return this.model.set(this.getOption('imageProperty'), selection);
	  };

	  ImageSelector.prototype.onLayoutChanged = function() {
	    var image;
	    if (image = this.model.get(this.getOption('imageProperty'))) {
	      return this.loadNewImageById(image);
	    }
	  };

	  ImageSelector.prototype.loadNewImage = function(url) {
	    this.ui.image.attr('src', url).show();
	    this.$el.find('.image-delete').fadeIn('fast');
	    this.$el.find('.actions-wrapper, .overlay').fadeOut('fast');
	    return false;
	  };

	  ImageSelector.prototype.loadNewImageById = function(id) {
	    var layout;
	    if (this.getOption('obeyLayout')) {
	      layout = this.layouts[this.model.get('layout')];
	    } else {
	      layout = 'thumbnail';
	    }
	    return jQuery.post('admin-ajax.php?action=uber_grid_reload_images', {
	      ids: id,
	      layout: layout
	    }, (function(_this) {
	      return function(response) {
	        return _this.loadNewImage(response.srcs[0]);
	      };
	    })(this));
	  };

	  return ImageSelector;

	})(Marionette.ItemView);


/***/ },
/* 8 */
/***/ function(module, exports) {

	var LayoutSelector,
	  bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
	  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
	  hasProp = {}.hasOwnProperty;

	module.exports = LayoutSelector = (function(superClass) {
	  extend(LayoutSelector, superClass);

	  function LayoutSelector() {
	    this.onLayoutChanged = bind(this.onLayoutChanged, this);
	    return LayoutSelector.__super__.constructor.apply(this, arguments);
	  }

	  LayoutSelector.prototype.ui = {
	    options: 'li',
	    input: 'input'
	  };

	  LayoutSelector.prototype.events = {
	    'click @ui.options': 'onLayoutChanged'
	  };

	  LayoutSelector.prototype.initialize = function() {
	    LayoutSelector.__super__.initialize.apply(this, arguments);
	    return this.bindUIElements();
	  };

	  LayoutSelector.prototype.bindUIElements = function() {
	    var layout;
	    LayoutSelector.__super__.bindUIElements.apply(this, arguments);
	    if ((layout = this.model.get('layout'))) {
	      return this.$el.find("li." + layout).addClass("selected");
	    }
	  };

	  LayoutSelector.prototype.onLayoutChanged = function(event) {
	    var clicked;
	    clicked = jQuery(event.target).parent();
	    this.ui.options.removeClass("selected");
	    clicked.addClass("selected");
	    return this.model.set('layout', clicked.attr("class").split(/\s+/)[0]);
	  };

	  return LayoutSelector;

	})(Marionette.ItemView);


/***/ },
/* 9 */
/***/ function(module, exports, __webpack_require__) {

	var AutoCategoriesView, AutoEditorQueryView, AutomaticEditorView, CellEditorBase, CellEditorHoverSectionView, CellEditorLabelSectionView, CellEditorLayoutSectionView, CellEditorLinkingSectionView, CellEditorSectionView, CellTemplateMainSectionView, CellTemplateView, CellTemplatesView, CustomFieldFilterView, CustomFieldFiltersView, FilterView, FiltersView, ManualEditorView, TaxonomyFilterView, TaxonomyFiltersView,
	  bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
	  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
	  hasProp = {}.hasOwnProperty;

	ManualEditorView = __webpack_require__(3).ManualEditorView;

	CellEditorBase = __webpack_require__(4);

	CellEditorSectionView = __webpack_require__(6);

	CellTemplateMainSectionView = __webpack_require__(5).CellTemplateMainSectionView;

	CellEditorLayoutSectionView = __webpack_require__(5).CellEditorLayoutSectionView;

	CellEditorHoverSectionView = __webpack_require__(5).CellEditorHoverSectionView;

	CellEditorLabelSectionView = __webpack_require__(5).CellEditorLabelSectionView;

	CellEditorLinkingSectionView = __webpack_require__(5).CellEditorLinkingSectionView;

	FiltersView = (function(superClass) {
	  extend(FiltersView, superClass);

	  function FiltersView() {
	    this.onAddClicked = bind(this.onAddClicked, this);
	    return FiltersView.__super__.constructor.apply(this, arguments);
	  }

	  FiltersView.prototype.ui = {
	    addButton: 'button[data-action=add]'
	  };

	  FiltersView.prototype.events = {
	    'click @ui.addButton': 'onAddClicked'
	  };

	  FiltersView.prototype.childViewContainer = 'ul';

	  FiltersView.prototype.onShow = function() {
	    return this.binding = rivets.bind(this.$el, this.model);
	  };

	  FiltersView.prototype.onAddClicked = function(e) {
	    e.preventDefault();
	    return this.collection.add({});
	  };

	  return FiltersView;

	})(Marionette.CompositeView);

	FilterView = (function(superClass) {
	  extend(FilterView, superClass);

	  function FilterView() {
	    return FilterView.__super__.constructor.apply(this, arguments);
	  }

	  FilterView.prototype.tagName = 'li';

	  FilterView.prototype.ui = function() {
	    return {
	      'button': 'button'
	    };
	  };

	  FilterView.prototype.events = {
	    'click @ui.button': 'onRemoveClicked'
	  };

	  FilterView.prototype.onShow = function() {
	    return this.binding = rivets.bind(this.$el, {
	      model: this.model
	    });
	  };

	  FilterView.prototype.onRemoveClicked = function() {
	    return this.model.collection.remove(this.model);
	  };

	  return FilterView;

	})(Marionette.ItemView);

	TaxonomyFilterView = (function(superClass) {
	  extend(TaxonomyFilterView, superClass);

	  function TaxonomyFilterView() {
	    return TaxonomyFilterView.__super__.constructor.apply(this, arguments);
	  }

	  TaxonomyFilterView.prototype.template = '#ug-taxonomy-filter-template';

	  TaxonomyFilterView.prototype.ui = function() {
	    return _.extend(TaxonomyFilterView.__super__.ui.apply(this, arguments), {
	      taxonomySelect: 'select[role=taxonomy]'
	    });
	  };

	  TaxonomyFilterView.prototype.onShow = function() {
	    TaxonomyFilterView.__super__.onShow.apply(this, arguments);
	    if (!this.model.get('taxonomy')) {
	      return this.model.set('taxonomy', this.ui.taxonomySelect.find('option:first-child').attr('value'));
	    }
	  };

	  return TaxonomyFilterView;

	})(FilterView);

	TaxonomyFiltersView = (function(superClass) {
	  extend(TaxonomyFiltersView, superClass);

	  function TaxonomyFiltersView() {
	    return TaxonomyFiltersView.__super__.constructor.apply(this, arguments);
	  }

	  TaxonomyFiltersView.prototype.template = '#ug-taxonomy-filters-template';

	  TaxonomyFiltersView.prototype.childView = TaxonomyFilterView;

	  return TaxonomyFiltersView;

	})(FiltersView);

	CustomFieldFilterView = (function(superClass) {
	  extend(CustomFieldFilterView, superClass);

	  function CustomFieldFilterView() {
	    return CustomFieldFilterView.__super__.constructor.apply(this, arguments);
	  }

	  CustomFieldFilterView.prototype.template = '#ug-custom-fields-filter-template';

	  CustomFieldFilterView.prototype.ui = function() {
	    return _.extend(CustomFieldFilterView.__super__.ui.apply(this, arguments), {
	      keySelect: 'select[role=key]'
	    });
	  };

	  CustomFieldFilterView.prototype.onShow = function() {
	    CustomFieldFilterView.__super__.onShow.apply(this, arguments);
	    if (!this.model.get('key')) {
	      return this.model.set('key', this.ui.keySelect.find('option:first-child').attr('value'));
	    }
	  };

	  return CustomFieldFilterView;

	})(FilterView);

	CustomFieldFiltersView = (function(superClass) {
	  extend(CustomFieldFiltersView, superClass);

	  function CustomFieldFiltersView() {
	    return CustomFieldFiltersView.__super__.constructor.apply(this, arguments);
	  }

	  CustomFieldFiltersView.prototype.template = '#ug-custom-fields-filters-template';

	  CustomFieldFiltersView.prototype.childView = CustomFieldFilterView;

	  return CustomFieldFiltersView;

	})(FiltersView);

	CellTemplateView = (function(superClass) {
	  extend(CellTemplateView, superClass);

	  function CellTemplateView() {
	    this.onCollectionChange = bind(this.onCollectionChange, this);
	    return CellTemplateView.__super__.constructor.apply(this, arguments);
	  }

	  CellTemplateView.prototype.template = '#ug-auto-cell-template-template';

	  CellTemplateView.prototype.regions = function() {
	    return _.extend(CellTemplateView.__super__.regions.apply(this, arguments), {
	      legend: '.ug-cell-legend-wrapper',
	      application: '.ug-cell-application-wrapper'
	    });
	  };

	  CellTemplateView.prototype.ui = function() {
	    return _.extend(CellTemplateView.__super__.ui.apply(this, arguments), {
	      application: '.ug-cell-application-wrapper'
	    });
	  };

	  CellTemplateView.prototype.initialize = function() {
	    this.listenTo(this.model.collection, 'remove', this.onCollectionChange);
	    this.listenTo(this.model.collection, 'add', this.onCollectionChange);
	    return this.listenTo(this.getOption('ownerModel'), 'change:choose_template_method', this.onTemplateSelectionMethodChanged);
	  };

	  CellTemplateView.prototype.onCollectionChange = function() {
	    if (this.model.collection.length === 1) {
	      if (this.ui.removeLink.hide) {
	        return this.ui.removeLink.hide();
	      }
	    } else {
	      if (this.ui.removeLink.show) {
	        return this.ui.removeLink.show();
	      }
	    }
	  };

	  CellTemplateView.prototype.onTemplateSelectionMethodChanged = function() {
	    var method, params;
	    params = {
	      model: this.model,
	      className: 'ug-section ug-expandable'
	    };
	    method = this.getOption('ownerModel').get('choose_template_method');
	    switch (method) {
	      case 'php':
	        this.ui.application.show();
	        return this.application.show(new CellEditorSectionView(_.extend(params, {
	          template: '#ug-auto-cell-template-php-application-mode'
	        })));
	      case 'taxonomy':
	        this.ui.application.show();
	        return this.application.show(new CellEditorSectionView(_.extend(params, {
	          template: '#ug-auto-cell-template-taxonomy-application-mode'
	        })));
	      default:
	        this.ui.application.hide();
	        return this.application.empty();
	    }
	  };

	  CellTemplateView.prototype.onShow = function() {
	    return this.onCollectionChange();
	  };

	  CellTemplateView.prototype.displaySections = function() {
	    this.legend.show(new CellEditorSectionView({
	      template: '#ug-auto-cell-template-legend-section-template',
	      className: 'ug-section ug-expandable'
	    }));
	    this.onTemplateSelectionMethodChanged();
	    this.main.show(new CellTemplateMainSectionView({
	      model: this.model,
	      className: 'ug-section ug-expandable'
	    }));
	    this.layout.show(new CellEditorLayoutSectionView({
	      model: this.model,
	      className: 'ug-section ug-expandable'
	    }));
	    this.hover.show(new CellEditorHoverSectionView({
	      model: this.model.get('hover')
	    }));
	    this.label.show(new CellEditorLabelSectionView({
	      model: this.model.get('label')
	    }));
	    this.binding = rivets.bind(this.$el, {
	      model: this.model
	    });
	    return this.linking.show(new CellEditorLinkingSectionView({
	      model: this.model.get('link')
	    }));
	  };

	  CellTemplateView.prototype.hideSections = function() {
	    var i, len, ref, region, results;
	    this.binding.unbind();
	    ref = [this.legend, this.main, this.layout, this.linking, this.hover, this.label];
	    results = [];
	    for (i = 0, len = ref.length; i < len; i++) {
	      region = ref[i];
	      results.push(region.empty());
	    }
	    return results;
	  };

	  return CellTemplateView;

	})(CellEditorBase);

	CellTemplatesView = (function(superClass) {
	  extend(CellTemplatesView, superClass);

	  function CellTemplatesView() {
	    this.onAddCellClicked = bind(this.onAddCellClicked, this);
	    this.childViewOptions = bind(this.childViewOptions, this);
	    return CellTemplatesView.__super__.constructor.apply(this, arguments);
	  }

	  CellTemplatesView.prototype.template = '#ug-auto-cell-templates-wrapper-template';

	  CellTemplatesView.prototype.childView = CellTemplateView;

	  CellTemplatesView.prototype.ui = function() {
	    return _.extend(CellTemplatesView.__super__.ui.apply(this, arguments), {
	      header: '.cells-header'
	    });
	  };

	  CellTemplatesView.prototype.childViewOptions = function(child, index) {
	    return {
	      ownerModel: this.model
	    };
	  };

	  CellTemplatesView.prototype.onAddCellClicked = function(event) {
	    var cell;
	    event.preventDefault();
	    this.collection.add(cell = new CellTemplate);
	    return this.children.findByModel(cell).scrollTo();
	  };

	  CellTemplatesView.prototype.onShow = function() {
	    return this.binding = rivets.bind(this.ui.header, this.model);
	  };

	  return CellTemplatesView;

	})(ManualEditorView);

	AutoEditorQueryView = (function(superClass) {
	  extend(AutoEditorQueryView, superClass);

	  function AutoEditorQueryView() {
	    return AutoEditorQueryView.__super__.constructor.apply(this, arguments);
	  }

	  AutoEditorQueryView.prototype.id = 'auto-post-settings';

	  AutoEditorQueryView.prototype.template = "#ug-auto-mode-query-template";

	  AutoEditorQueryView.prototype.className = 'ug-cell';

	  AutoEditorQueryView.prototype.regions = {
	    taxonomyFilters: '.ug-taxonomy-filters-wrapper',
	    customFieldFilters: '.ug-custom-field-filters-wrapper'
	  };

	  AutoEditorQueryView.prototype.onShow = function() {
	    this.binding = rivets.bind(this.$el, {
	      model: this.model
	    });
	    this.taxonomyFilters.show(new TaxonomyFiltersView({
	      collection: this.model.get('taxonomyFilters'),
	      model: this.model
	    }));
	    return this.customFieldFilters.show(new CustomFieldFiltersView({
	      collection: this.model.get('customFieldFilters'),
	      model: this.model
	    }));
	  };

	  return AutoEditorQueryView;

	})(Marionette.LayoutView);

	AutoCategoriesView = (function(superClass) {
	  extend(AutoCategoriesView, superClass);

	  function AutoCategoriesView() {
	    return AutoCategoriesView.__super__.constructor.apply(this, arguments);
	  }

	  AutoCategoriesView.prototype.template = '#ug-auto-mode-filters-source';

	  AutoCategoriesView.prototype.className = 'ug-cell';

	  AutoCategoriesView.prototype.onAttach = function() {
	    return this.binding = rivets.bind(this.$el, this.model);
	  };

	  return AutoCategoriesView;

	})(Marionette.ItemView);

	module.exports = AutomaticEditorView = (function(superClass) {
	  extend(AutomaticEditorView, superClass);

	  function AutomaticEditorView() {
	    return AutomaticEditorView.__super__.constructor.apply(this, arguments);
	  }

	  AutomaticEditorView.prototype.template = '#auto-mode-template';

	  AutomaticEditorView.prototype.regions = {
	    query: '.ug-post-query-wrapper',
	    categories: '.ug-categories-wrapper',
	    cellTemplate: '.ug-cell-template'
	  };

	  AutomaticEditorView.prototype.onShow = function() {
	    this.query.show(new AutoEditorQueryView({
	      model: this.model
	    }));
	    this.categories.show(new AutoCategoriesView({
	      model: this.model
	    }));
	    return this.cellTemplate.show(new CellTemplatesView({
	      collection: this.model.get('cellTemplates'),
	      model: this.model
	    }));
	  };

	  return AutomaticEditorView;

	})(Marionette.LayoutView);


/***/ },
/* 10 */
/***/ function(module, exports) {

	var ExtraTabsView, LayoutTabsView, TabsView,
	  bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
	  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
	  hasProp = {}.hasOwnProperty;

	TabsView = (function(superClass) {
	  extend(TabsView, superClass);

	  function TabsView() {
	    this.onLinkClicked = bind(this.onLinkClicked, this);
	    return TabsView.__super__.constructor.apply(this, arguments);
	  }

	  TabsView.prototype.ui = function() {
	    return {
	      links: '.ubergrid-tabs li a',
	      panels: '.ubergrid-panels li',
	      firstPanel: '.ubergrid-panels li:first-child',
	      firstLink: '.ubergrid-tabs li:first-child a'
	    };
	  };

	  TabsView.prototype.events = {
	    'click @ui.links': 'onLinkClicked'
	  };

	  TabsView.prototype.initialize = function(params) {
	    TabsView.__super__.initialize.call(this, params);
	    return this.bindUIElements();
	  };

	  TabsView.prototype.bindUIElements = function() {
	    TabsView.__super__.bindUIElements.apply(this, arguments);
	    this.ui.firstLink.addClass('ubergrid-current');
	    return this.ui.firstPanel.addClass('ubergrid-current');
	  };

	  TabsView.prototype.onLinkClicked = function(event) {
	    var index;
	    event.preventDefault();
	    this.ui.panels.removeClass('ubergrid-current');
	    index = this.ui.links.index(event.target);
	    this.ui.panels.eq(index).addClass('ubergrid-current');
	    this.ui.links.parent().removeClass('ubergrid-current');
	    return jQuery(event.target).parent().addClass('ubergrid-current');
	  };

	  return TabsView;

	})(Marionette.ItemView);

	module.exports.LayoutTabsView = LayoutTabsView = (function(superClass) {
	  extend(LayoutTabsView, superClass);

	  function LayoutTabsView() {
	    return LayoutTabsView.__super__.constructor.apply(this, arguments);
	  }

	  LayoutTabsView.prototype.ui = function() {
	    return _.extend(LayoutTabsView.__super__.ui.apply(this, arguments), {
	      "default": '#ubergrid-layout-default',
	      under768: '#ubergrid-layout-768',
	      under440: '#ubergrid-layout-440'
	    });
	  };

	  LayoutTabsView.prototype.initialize = function() {
	    LayoutTabsView.__super__.initialize.apply(this, arguments);
	    this.bindUIElements();
	    this.defaultBinding = rivets.bind(this.ui["default"], this.model.get('default'));
	    this.binding440 = rivets.bind(this.ui.under440, this.model.get('440'));
	    return this.binding768 = rivets.bind(this.ui.under768, this.model.get('768'));
	  };

	  return LayoutTabsView;

	})(TabsView);

	module.exports.ExtraTabsView = ExtraTabsView = (function(superClass) {
	  extend(ExtraTabsView, superClass);

	  function ExtraTabsView() {
	    return ExtraTabsView.__super__.constructor.apply(this, arguments);
	  }

	  ExtraTabsView.prototype.initialize = function() {
	    ExtraTabsView.__super__.initialize.apply(this, arguments);
	    this.bindUIElements();
	    return this.binding = rivets.bind(this.$el, {
	      model: this.model
	    });
	  };

	  return ExtraTabsView;

	})(TabsView);


/***/ },
/* 11 */
/***/ function(module, exports, __webpack_require__) {

	var FontCollection, FontsView,
	  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
	  hasProp = {}.hasOwnProperty;

	FontCollection = __webpack_require__(1).FontCollection;

	module.exports = FontsView = (function(superClass) {
	  extend(FontsView, superClass);

	  function FontsView() {
	    return FontsView.__super__.constructor.apply(this, arguments);
	  }

	  FontsView.prototype.ui = {
	    fontSelectors: 'select[role=font]',
	    fontVariantSelectors: 'select[role=style]',
	    spinner: '.spin-wrapper',
	    content: '#fonts'
	  };

	  FontsView.prototype.initialize = function() {
	    FontsView.__super__.initialize.apply(this, arguments);
	    this.bindUIElements();
	    this.fonts = new FontCollection;
	    this.listenTo(this.fonts, 'sync', this.onFontsSync);
	    return this.fonts.fetch();
	  };

	  FontsView.prototype.onFontsSync = function(param) {
	    var font, i, len, ref;
	    ref = this.fonts.models;
	    for (i = 0, len = ref.length; i < len; i++) {
	      font = ref[i];
	      this.ui.fontSelectors.append(jQuery("<option />").text(font.get('family')));
	    }
	    this.ui.spinner.remove();
	    this.ui.content.css('visibility', 'visible');
	    return this.bind();
	  };

	  FontsView.prototype.bind = function() {
	    return this.binding = rivets.bind(this.$el, this.model, {
	      components: {
	        fonts: this.fonts
	      }
	    });
	  };

	  return FontsView;

	})(Marionette.ItemView);


/***/ },
/* 12 */
/***/ function(module, exports) {

	var PublishBlockView,
	  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
	  hasProp = {}.hasOwnProperty;

	module.exports = PublishBlockView = (function(superClass) {
	  extend(PublishBlockView, superClass);

	  function PublishBlockView() {
	    return PublishBlockView.__super__.constructor.apply(this, arguments);
	  }

	  PublishBlockView.prototype.ui = {
	    previewButton: '#preview',
	    publishButton: '#publish'
	  };

	  PublishBlockView.prototype.events = {
	    'click @ui.previewButton': 'onPreviewClick'
	  };

	  PublishBlockView.prototype.initialize = function() {
	    PublishBlockView.__super__.initialize.apply(this, arguments);
	    this.bindUIElements();
	    return this.ui.publishButton.removeAttr("disabled");
	  };

	  PublishBlockView.prototype.onPreviewClick = function() {
	    jQuery("#preview-backdrop, #preview-window").show();
	    jQuery("#preview-content").html("");
	    jQuery.post("admin-ajax.php?action=uber_grid_preview", {
	      data: JSON.stringify(this.model.toJSON()),
	      id: jQuery('#post_ID').val()
	    }, function(response) {
	      jQuery("#preview-content").css("visibility", "hidden");
	      jQuery("#preview-content").html(jQuery(response));
	      jQuery("#preview-content").css("visibility", "visible");
	      return setTimeout((function() {
	        return jQuery("#preview-content .uber-grid").packery("layout");
	      }), 200);
	    });
	    return jQuery("#preview-close, #preview-footer-close").click(function() {
	      return jQuery("#preview-backdrop, #preview-window").hide();
	    });
	  };

	  return PublishBlockView;

	})(Marionette.ItemView);


/***/ }
/******/ ]);